/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDebugMessage;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLDebug00NEWT
extends UITestCase {
    static String dbgTstMsg0 = "Hello World";
    static int dbgTstId0 = 42;

    WindowContext createWindow(GLProfile gLProfile, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)window);
        window.setSize(128, 128);
        window.setVisible(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable((NativeSurface)window);
        Assert.assertNotNull((Object)gLDrawable);
        gLDrawable.setRealized(true);
        GLContext gLContext = gLDrawable.createContext(null);
        Assert.assertNotNull((Object)gLContext);
        gLContext.enableGLDebugMessage(bl);
        int n = gLContext.makeCurrent();
        Assert.assertTrue((2 == n || 1 == n ? 1 : 0) != 0);
        return new WindowContext(window, gLContext);
    }

    void destroyWindow(WindowContext windowContext) {
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        Assert.assertNotNull((Object)windowContext.context);
        windowContext.context.destroy();
        Assert.assertNotNull((Object)gLDrawable);
        gLDrawable.setRealized(false);
        Assert.assertNotNull((Object)windowContext.window);
        windowContext.window.destroy();
    }

    void test01GLDebug01EnableDisable(boolean bl) throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        WindowContext windowContext = this.createWindow(gLProfile, bl);
        String string = windowContext.context.getGLDebugMessageExtension();
        System.err.println("glDebug extension: " + string);
        System.err.println("glDebug enabled: " + windowContext.context.isGLDebugMessageEnabled());
        System.err.println("glDebug sync: " + windowContext.context.isGLDebugSynchronous());
        System.err.println("context version: " + windowContext.context.getGLVersion());
        Assert.assertEquals((Object)(null == string ? false : bl), (Object)windowContext.context.isGLDebugMessageEnabled());
        this.destroyWindow(windowContext);
    }

    @Test
    public void test01GLDebugDisabled() throws InterruptedException {
        this.test01GLDebug01EnableDisable(false);
    }

    @Test
    public void test01GLDebugEnabled() throws InterruptedException {
        this.test01GLDebug01EnableDisable(true);
    }

    @Test
    public void test02GLDebugError() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        WindowContext windowContext = this.createWindow(gLProfile, true);
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(33350, 33356, 37190);
        windowContext.context.addGLDebugListener((GLDebugListener)myGLDebugListener);
        GL gL = windowContext.context.getGL();
        gL.glBindFramebuffer(-1, -1);
        if (windowContext.context.isGLDebugMessageEnabled()) {
            Assert.assertEquals((Object)true, (Object)myGLDebugListener.received());
        }
        this.destroyWindow(windowContext);
    }

    @Test
    public void test03GLDebugInsert() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        WindowContext windowContext = this.createWindow(gLProfile, true);
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(dbgTstMsg0, dbgTstId0);
        windowContext.context.addGLDebugListener((GLDebugListener)myGLDebugListener);
        String string = windowContext.context.getGLDebugMessageExtension();
        Assert.assertEquals((Object)(null != string ? 1 : 0), (Object)windowContext.context.isGLDebugMessageEnabled());
        if (windowContext.context.isGLDebugMessageEnabled()) {
            windowContext.context.glDebugMessageInsert(33354, 33361, dbgTstId0, 37191, dbgTstMsg0);
            Assert.assertEquals((Object)true, (Object)myGLDebugListener.received());
        }
        this.destroyWindow(windowContext);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLDebug00NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    public class MyGLDebugListener
    implements GLDebugListener {
        int recSource;
        int recType;
        int recSeverity;
        String recMsg;
        int recId;
        boolean received = false;

        public MyGLDebugListener(int n, int n2, int n3) {
            this.recSource = n;
            this.recType = n2;
            this.recSeverity = n3;
            this.recMsg = null;
            this.recId = -1;
        }

        public MyGLDebugListener(String string, int n) {
            this.recSource = -1;
            this.recType = -1;
            this.recSeverity = -1;
            this.recMsg = string;
            this.recId = n;
        }

        public boolean received() {
            return this.received;
        }

        public void messageSent(GLDebugMessage gLDebugMessage) {
            System.err.println("XXX: " + gLDebugMessage);
            if (null != this.recMsg && this.recMsg.equals(gLDebugMessage.getDbgMsg()) && this.recId == gLDebugMessage.getDbgId()) {
                this.received = true;
            } else if (0 <= this.recSource && this.recSource == gLDebugMessage.getDbgSource() && this.recType == gLDebugMessage.getDbgType() && this.recSeverity == gLDebugMessage.getDbgSeverity()) {
                this.received = true;
            }
        }
    }

    public class WindowContext {
        public final Window window;
        public final GLContext context;

        public WindowContext(Window window, GLContext gLContext) {
            this.window = window;
            this.context = gLContext;
        }
    }
}

