/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDebugMessage;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLDebug01NEWT
extends UITestCase {
    static String dbgTstMsg0 = "Hello World";
    static int dbgTstId0 = 42;

    GLWindow createWindow(GLProfile gLProfile, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setContextCreationFlags(bl ? 32 : 0);
        gLWindow.setSize(128, 128);
        gLWindow.setVisible(true);
        Assert.assertNotNull((Object)gLWindow.getContext());
        Assert.assertNotNull((Object)gLWindow.getContext().isCreated());
        return gLWindow;
    }

    void destroyWindow(GLWindow gLWindow) {
        gLWindow.destroy();
    }

    void test01GLDebug01EnableDisable(boolean bl, final String string, final int n) throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        GLWindow gLWindow = this.createWindow(gLProfile, bl);
        GLContext gLContext = gLWindow.getContext();
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(string, n);
        if (bl) {
            gLContext.addGLDebugListener((GLDebugListener)myGLDebugListener);
        }
        String string2 = gLContext.getGLDebugMessageExtension();
        System.err.println("glDebug extension: " + string2);
        System.err.println("glDebug enabled: " + gLContext.isGLDebugMessageEnabled());
        System.err.println("glDebug sync: " + gLContext.isGLDebugSynchronous());
        System.err.println("context version: " + gLContext.getGLVersion());
        Assert.assertEquals((Object)(null == string2 ? false : bl), (Object)gLContext.isGLDebugMessageEnabled());
        if (gLContext.isGLDebugMessageEnabled() && null != string && 0 <= n) {
            gLWindow.invoke(true, new GLRunnable(){

                public boolean run(GLAutoDrawable gLAutoDrawable) {
                    gLAutoDrawable.getContext().glDebugMessageInsert(33354, 33361, n, 37191, string);
                    return true;
                }
            });
            Assert.assertEquals((Object)true, (Object)myGLDebugListener.received());
        }
        this.destroyWindow(gLWindow);
    }

    @Test
    public void test01GLDebug01Disabled() throws InterruptedException {
        this.test01GLDebug01EnableDisable(false, null, -1);
    }

    @Test
    public void test01GLDebug01Enabled() throws InterruptedException {
        this.test01GLDebug01EnableDisable(true, dbgTstMsg0, dbgTstId0);
    }

    @Test
    public void test02GLDebug01Error() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        GLWindow gLWindow = this.createWindow(gLProfile, true);
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(33350, 33356, 37190);
        gLWindow.getContext().addGLDebugListener((GLDebugListener)myGLDebugListener);
        gLWindow.invoke(true, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                gLAutoDrawable.getGL().glBindFramebuffer(-1, -1);
                return true;
            }
        });
        if (gLWindow.getContext().isGLDebugMessageEnabled()) {
            Assert.assertEquals((Object)true, (Object)myGLDebugListener.received());
        }
        this.destroyWindow(gLWindow);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLDebug01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    public class MyGLDebugListener
    implements GLDebugListener {
        int recSource;
        int recType;
        int recSeverity;
        String recMsg;
        int recId;
        boolean received = false;

        public MyGLDebugListener(int n, int n2, int n3) {
            this.recSource = n;
            this.recType = n2;
            this.recSeverity = n3;
            this.recMsg = null;
            this.recId = -1;
        }

        public MyGLDebugListener(String string, int n) {
            this.recSource = -1;
            this.recType = -1;
            this.recSeverity = -1;
            this.recMsg = string;
            this.recId = n;
        }

        public boolean received() {
            return this.received;
        }

        public void messageSent(GLDebugMessage gLDebugMessage) {
            System.err.println("XXX: " + gLDebugMessage);
            if (null != this.recMsg && this.recMsg.equals(gLDebugMessage.getDbgMsg()) && this.recId == gLDebugMessage.getDbgId()) {
                this.received = true;
            } else if (0 <= this.recSource && this.recSource == gLDebugMessage.getDbgSource() && this.recType == gLDebugMessage.getDbgType() && this.recSeverity == gLDebugMessage.getDbgSeverity()) {
                this.received = true;
            }
        }
    }
}

