/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.util.List;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2NEWT0
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2ES2")) {
            glp = GLProfile.get((String)"GL2ES2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2NEWT0.setTestSupported(false);
        }
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, GearsES2 gearsES2, GLContext gLContext) throws InterruptedException {
        boolean bl = null != gLContext;
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedContext(gLContext);
        }
        gLWindow.setSize(width, height);
        gLWindow.addGLEventListener((GLEventListener)gearsES2);
        animator.add((GLAutoDrawable)gLWindow);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, true));
        gLWindow.display();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLWindow, true));
        Assert.assertTrue((String)"Gears not initialized", (boolean)gearsES2.waitForInit(true));
        return gLWindow;
    }

    @Test
    public void testCommonAnimatorShared() throws InterruptedException {
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, gearsES2, null);
        GLContext gLContext = gLWindow.getContext();
        Assert.assertTrue((String)"Ctx is shared before shared creation", (!gLContext.isShared() ? 1 : 0) != 0);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        System.err.println("XXX-C-2.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGearsObjects(gearsES2.getGear1(), gearsES2.getGear2(), gearsES2.getGear3());
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, gearsES22, gLWindow.getContext());
        GLContext gLContext2 = gLWindow2.getContext();
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Object object = gLContext.getCreatedShares();
        List list = gLContext2.getCreatedShares();
        System.err.println("XXX-C-2.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        System.err.println("XXX-C-2.2:");
        MiscUtils.dumpSharedGLContext(gLContext2);
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)1L, (long)object.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)1L, (long)list.size());
        object = new GearsES2(0);
        ((GearsES2)object).setSharedGearsObjects(gearsES2.getGear1(), gearsES2.getGear2(), gearsES2.getGear3());
        list = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), (GearsES2)object, gLWindow.getContext());
        GLContext gLContext3 = list.getContext();
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        List list2 = gLContext.getCreatedShares();
        List list3 = gLContext2.getCreatedShares();
        List list4 = gLContext3.getCreatedShares();
        System.err.println("XXX-C-3.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        System.err.println("XXX-C-3.2:");
        MiscUtils.dumpSharedGLContext(gLContext2);
        System.err.println("XXX-C-3.3:");
        MiscUtils.dumpSharedGLContext(gLContext3);
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list4.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)((GearsES2)object).usesSharedGears());
        animator.start();
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        gLWindow.destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLWindow, false));
        list2 = gLContext.getCreatedShares();
        list3 = gLContext2.getCreatedShares();
        list4 = gLContext3.getCreatedShares();
        System.err.println("XXX-D-2.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        System.err.println("XXX-D-2.2:");
        MiscUtils.dumpSharedGLContext(gLContext2);
        System.err.println("XXX-D-2.3:");
        MiscUtils.dumpSharedGLContext(gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)1L, (long)list3.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)1L, (long)list4.size());
        gLWindow2.destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLWindow2, false));
        list2 = gLContext.getCreatedShares();
        list3 = gLContext2.getCreatedShares();
        list4 = gLContext3.getCreatedShares();
        System.err.println("XXX-D-1.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        System.err.println("XXX-D-1.2:");
        MiscUtils.dumpSharedGLContext(gLContext2);
        System.err.println("XXX-D-1.3:");
        MiscUtils.dumpSharedGLContext(gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)1L, (long)list2.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)1L, (long)list3.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)0L, (long)list4.size());
        list.destroy();
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(list, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(list, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)list, false));
        list2 = gLContext.getCreatedShares();
        list3 = gLContext2.getCreatedShares();
        list4 = gLContext3.getCreatedShares();
        System.err.println("XXX-D-0.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        System.err.println("XXX-D-0.2:");
        MiscUtils.dumpSharedGLContext(gLContext2);
        System.err.println("XXX-D-0.3:");
        MiscUtils.dumpSharedGLContext(gLContext3);
        Assert.assertTrue((String)"Ctx1 is shared", (!gLContext.isShared() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Ctx2 is shared", (!gLContext2.isShared() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Ctx3 is shared", (!gLContext3.isShared() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)0L, (long)list2.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)0L, (long)list3.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)0L, (long)list4.size());
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextVBOES2NEWT0.class.getName()});
    }

    static {
        duration = 1000L;
    }
}

