/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestShutdownCompleteAWT
extends UITestCase {
    static long duration = 300L;

    protected void runTestGL() throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame("Gears AWT Test");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getGL2ES2()));
        Assert.assertNotNull((Object)gLCanvas);
        frame.add((Component)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2(1));
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(256, 256);
                frame.setVisible(true);
            }
        });
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isVisible());
        Assert.assertEquals((Object)true, (Object)gLCanvas.isDisplayable());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)true, (Object)gLCanvas.isRealized());
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove((Component)gLCanvas);
                frame.dispose();
            }
        });
    }

    protected void oneLife() throws InterruptedException, InvocationTargetException {
        long l = System.nanoTime();
        GLProfile.initSingleton();
        long l2 = System.nanoTime();
        this.runTestGL();
        long l3 = System.nanoTime();
        GLProfile.shutdown();
        long l4 = System.nanoTime();
        System.err.println("Total:                          " + (double)(l4 - l) / 1000000.0 + "ms");
        System.err.println("  GLProfile.initSingleton():    " + (double)(l2 - l) / 1000000.0 + "ms");
        System.err.println("  Demo Code:                    " + (double)(l3 - l2) / 1000000.0 + "ms");
        System.err.println("  GLProfile.shutdown():         " + (double)(l4 - l3) / 1000000.0 + "ms");
    }

    @Test
    public void test01OneLife() throws InterruptedException, InvocationTargetException {
        this.oneLife();
    }

    @Test
    public void test01AnotherLife() throws InterruptedException, InvocationTargetException {
        this.oneLife();
    }

    @Test
    public void test01TwoLifes() throws InterruptedException, InvocationTargetException {
        this.oneLife();
        this.oneLife();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestShutdownCompleteAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

