/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.ect;

import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.AnimatorBase;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class ExclusiveContextBase00
extends UITestCase {
    static boolean testExclusiveWithAWT = false;
    static final int durationParts = 9;
    static long duration = 2880L;
    static boolean showFPS = false;
    static int showFPSRate = 100;
    static final int demoSize = 128;
    static InsetsImmutable insets = null;
    static int scrnHeight;
    static int scrnWidth;
    static int num_x;
    static int num_y;
    static int swapInterval;

    @BeforeClass
    public static void initClass00() {
        Window window = NewtFactory.createWindow((CapabilitiesImmutable)new Capabilities());
        window.setSize(128, 128);
        window.setVisible(true);
        Assert.assertEquals((Object)true, (Object)window.isVisible());
        Assert.assertEquals((Object)true, (Object)window.isNativeValid());
        insets = window.getInsets();
        scrnHeight = window.getScreen().getHeight();
        scrnWidth = window.getScreen().getWidth();
        num_x = scrnWidth / (128 + insets.getTotalWidth()) - 2;
        num_y = scrnHeight / (128 + insets.getTotalHeight()) - 2;
        window.destroy();
    }

    @AfterClass
    public static void releaseClass00() {
    }

    protected abstract boolean isAWTTestCase();

    protected abstract Thread getAWTRenderThread();

    protected abstract AnimatorBase createAnimator();

    protected abstract GLAutoDrawable createGLAutoDrawable(String var1, int var2, int var3, int var4, int var5, GLCapabilitiesImmutable var6);

    protected abstract void setGLAutoDrawableVisible(GLAutoDrawable[] var1);

    protected abstract void destroyGLAutoDrawableVisible(GLAutoDrawable var1);

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        int n2;
        int n3;
        boolean bl4 = this.isAWTTestCase();
        if (bl4 && bl) {
            if (testExclusiveWithAWT) {
                System.err.println("Warning: Testing AWT + Exclusive -> Not advised!");
            } else {
                System.err.println("Info: Skip test: AWT + Exclusive!");
                return;
            }
        }
        if (bl4 && bl && !testExclusiveWithAWT) {
            System.err.println("Skip test: AWT + Exclusive -> Not advised!");
            return;
        }
        Thread thread = this.getAWTRenderThread();
        AnimatorBase animatorBase = this.createAnimator();
        if (!bl4) {
            animatorBase.setModeBits(false, 1);
        }
        GLAutoDrawable[] gLAutoDrawableArray = new GLAutoDrawable[n];
        for (n3 = 0; n3 < n; ++n3) {
            n2 = n3 % num_x * (128 + insets.getTotalHeight()) + insets.getLeftWidth();
            int n4 = n3 / num_x % num_y * (128 + insets.getTotalHeight()) + insets.getTopHeight();
            gLAutoDrawableArray[n3] = this.createGLAutoDrawable("Win #" + n3, n2, n4, 128, 128, gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLAutoDrawableArray[n3]);
            GearsES2 gearsES2 = new GearsES2(swapInterval);
            gearsES2.setVerbose(false);
            gLAutoDrawableArray[n3].addGLEventListener((GLEventListener)gearsES2);
        }
        if (bl2) {
            for (n3 = 0; n3 < n; ++n3) {
                animatorBase.add(gLAutoDrawableArray[n3]);
            }
            if (bl) {
                if (bl4) {
                    Assert.assertEquals(null, (Object)animatorBase.setExclusiveContext(thread));
                } else {
                    Assert.assertEquals((Object)false, (Object)animatorBase.setExclusiveContext(true));
                }
            }
        }
        Assert.assertFalse((boolean)animatorBase.isAnimating());
        Assert.assertFalse((boolean)animatorBase.isStarted());
        Assert.assertTrue((boolean)animatorBase.start());
        Assert.assertTrue((boolean)animatorBase.isStarted());
        if (bl2) {
            Assert.assertTrue((boolean)animatorBase.isAnimating());
        } else {
            Assert.assertFalse((boolean)animatorBase.isAnimating());
            if (bl) {
                if (bl4) {
                    Assert.assertEquals(null, (Object)animatorBase.setExclusiveContext(thread));
                } else {
                    Assert.assertEquals((Object)false, (Object)animatorBase.setExclusiveContext(true));
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                animatorBase.add(gLAutoDrawableArray[n3]);
            }
            Assert.assertTrue((boolean)animatorBase.isAnimating());
        }
        Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
        Thread thread2 = animatorBase.getExclusiveContextThread();
        if (bl) {
            if (bl4) {
                Assert.assertEquals((Object)thread, (Object)thread2);
            } else {
                Assert.assertEquals((Object)animatorBase.getThread(), (Object)thread2);
            }
        } else {
            Assert.assertEquals(null, (Object)thread2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            Assert.assertEquals((Object)thread2, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
        }
        this.setGLAutoDrawableVisible(gLAutoDrawableArray);
        animatorBase.setUpdateFPSFrames(showFPSRate, showFPS ? System.err : null);
        Thread.sleep(duration / 9L);
        if (!bl3) {
            int n5;
            if (bl) {
                thread2 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals((Object)thread, (Object)thread2);
                } else {
                    Assert.assertEquals((Object)animatorBase.getThread(), (Object)thread2);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    Thread thread3 = gLAutoDrawableArray[n2].setExclusiveContextThread(null);
                    Assert.assertEquals((Object)thread2, (Object)thread3);
                }
                Thread.sleep(duration / 9L);
                for (n2 = 0; n2 < n; ++n2) {
                    int n6;
                    boolean bl5 = null == gLAutoDrawableArray[n2].getExclusiveContextThread();
                    for (n6 = 0; !bl5 && n6 < 250; ++n6) {
                        Thread.sleep(20L);
                        bl5 = null == gLAutoDrawableArray[n2].getExclusiveContextThread();
                    }
                    if (n6 > 0) {
                        System.err.println("Clearing drawable ECT was done 'later' @ " + n6 * 20 + "ms, ok " + bl5);
                    }
                    Assert.assertEquals((Object)true, (Object)bl5);
                    Thread thread4 = gLAutoDrawableArray[n2].setExclusiveContextThread(thread2);
                    Assert.assertEquals(null, (Object)thread4);
                }
                Thread.sleep(duration / 9L);
            }
            if (bl) {
                thread2 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals((Object)thread, (Object)thread2);
                } else {
                    Assert.assertEquals((Object)animatorBase.getThread(), (Object)thread2);
                }
                Assert.assertEquals((Object)true, (Object)animatorBase.setExclusiveContext(false));
                Assert.assertFalse((boolean)animatorBase.isExclusiveContextEnabled());
                for (n2 = 0; n2 < n; ++n2) {
                    Assert.assertEquals(null, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
                }
                Thread.sleep(duration / 9L);
                Assert.assertEquals(null, (Object)animatorBase.setExclusiveContext(thread2));
                Assert.assertTrue((boolean)animatorBase.isExclusiveContextEnabled());
                Assert.assertEquals((Object)thread2, (Object)animatorBase.getExclusiveContextThread());
                for (n2 = 0; n2 < n; ++n2) {
                    Assert.assertEquals((Object)thread2, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
                }
                Thread.sleep(duration / 9L);
            }
            Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
            Assert.assertTrue((boolean)animatorBase.isStarted());
            Assert.assertTrue((boolean)animatorBase.isAnimating());
            Assert.assertFalse((boolean)animatorBase.isPaused());
            Assert.assertTrue((boolean)animatorBase.pause());
            Assert.assertTrue((boolean)animatorBase.isStarted());
            Assert.assertFalse((boolean)animatorBase.isAnimating());
            Assert.assertTrue((boolean)animatorBase.isPaused());
            Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
            if (bl) {
                thread2 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals((Object)thread, (Object)thread2);
                } else {
                    Assert.assertEquals((Object)animatorBase.getThread(), (Object)thread2);
                }
            } else {
                Assert.assertEquals(null, (Object)animatorBase.getExclusiveContextThread());
            }
            for (n5 = 0; n5 < n; ++n5) {
                Assert.assertEquals(null, (Object)gLAutoDrawableArray[n5].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            Assert.assertTrue((boolean)animatorBase.resume());
            Assert.assertTrue((boolean)animatorBase.isStarted());
            Assert.assertTrue((boolean)animatorBase.isAnimating());
            Assert.assertFalse((boolean)animatorBase.isPaused());
            Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
            if (bl) {
                Thread thread5 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals((Object)thread, (Object)thread5);
                } else {
                    Assert.assertEquals((Object)animatorBase.getThread(), (Object)thread5);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    Assert.assertEquals((Object)thread5, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
                }
            } else {
                Assert.assertEquals(null, (Object)animatorBase.getExclusiveContextThread());
                for (n5 = 0; n5 < n; ++n5) {
                    Assert.assertEquals(null, (Object)gLAutoDrawableArray[n5].getExclusiveContextThread());
                }
            }
            Thread.sleep(duration / 9L);
            Assert.assertTrue((boolean)animatorBase.stop());
            Assert.assertFalse((boolean)animatorBase.isAnimating());
            Assert.assertFalse((boolean)animatorBase.isStarted());
            Assert.assertFalse((boolean)animatorBase.isPaused());
            Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
            Assert.assertEquals(null, (Object)animatorBase.getExclusiveContextThread());
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals(null, (Object)gLAutoDrawableArray[i].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            Assert.assertTrue((boolean)animatorBase.start());
            Assert.assertTrue((boolean)animatorBase.isStarted());
            Assert.assertTrue((boolean)animatorBase.isAnimating());
            Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
            Thread thread6 = animatorBase.getExclusiveContextThread();
            if (bl) {
                if (bl4) {
                    Assert.assertEquals((Object)thread, (Object)thread6);
                } else {
                    Assert.assertEquals((Object)animatorBase.getThread(), (Object)thread6);
                }
            } else {
                Assert.assertEquals(null, (Object)thread6);
            }
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertEquals((Object)thread6, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            for (int i = 0; i < n; ++i) {
                GLAutoDrawable gLAutoDrawable = gLAutoDrawableArray[i];
                animatorBase.remove(gLAutoDrawable);
                Assert.assertEquals(null, (Object)gLAutoDrawable.getExclusiveContextThread());
            }
            Assert.assertTrue((boolean)animatorBase.isStarted());
            Assert.assertFalse((boolean)animatorBase.isAnimating());
        }
        Assert.assertTrue((boolean)animatorBase.stop());
        Assert.assertFalse((boolean)animatorBase.isAnimating());
        Assert.assertFalse((boolean)animatorBase.isStarted());
        Assert.assertFalse((boolean)animatorBase.isPaused());
        Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
        Assert.assertEquals(null, (Object)animatorBase.getExclusiveContextThread());
        for (int i = 0; i < n; ++i) {
            this.destroyGLAutoDrawableVisible(gLAutoDrawableArray[i]);
            Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLAutoDrawableArray[i], false));
        }
    }

    @Test
    public void test01NormalPre_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, false, true, false);
    }

    @Test
    public void test02NormalPost_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, false, false, true);
    }

    @Test
    public void test03ExclPre_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, true, true, false);
    }

    @Test
    public void test04ExclPost_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, true, false, true);
    }

    @Test
    public void test05NormalPre_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, false, true, false);
    }

    @Test
    public void test06NormalPost_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, false, false, true);
    }

    @Test
    public void test07ExclPre_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, true, true, false);
    }

    @Test
    public void test08ExclPost_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, true, false, true);
    }

    static {
        swapInterval = 0;
    }
}

