/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAWT01GLn
extends UITestCase {
    @BeforeClass
    public static void startup() {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException {
        final Frame frame = new Frame("Texture Test");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2());
        frame.add((Component)gLCanvas);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(512, 512);
                    frame.validate();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLCanvas.display();
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.start();
        Thread.sleep(500L);
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test
    public void test01GLDefault() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile Default: " + gLProfile);
        if (gLProfile.isGL2ES2()) {
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities);
        } else {
            System.out.println("not a GL2ES2 profile");
        }
    }

    @Test
    public void test02GL2() throws InterruptedException {
        if (GLProfile.isAvailable((String)"GL2")) {
            GLProfile gLProfile = GLProfile.get((String)"GL2");
            System.out.println("GLProfile GL2: " + gLProfile);
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities);
        } else {
            System.out.println("GL2 n/a");
        }
    }

    @Test
    public void test02ES2() throws InterruptedException {
        if (GLProfile.isAvailable((String)"GLES2")) {
            GLProfile gLProfile = GLProfile.get((String)"GLES2");
            System.out.println("GLProfile GLES2: " + gLProfile);
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities);
        } else {
            System.out.println("GLES2 n/a");
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestAWT01GLn.class.getName()});
    }
}

