/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.AnimatorBase;
import com.jogamp.opengl.util.FPSAnimator;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLCanvasAWTActionDeadlock01AWT
extends UITestCase {
    static long durationPerTest = 1000L;
    static final int width = 512;
    static final int height = 512;
    GLEventListener gle1 = null;
    GLEventListener gle2 = null;
    int frameCount = 0;

    @Test
    public void test00NoAnimator() throws InterruptedException, InvocationTargetException {
        this.testImpl(null, 0, false);
    }

    @Test
    public void test01Animator() throws InterruptedException, InvocationTargetException {
        this.testImpl((AnimatorBase)new Animator(), 0, false);
    }

    @Test
    public void test02FPSAnimator() throws InterruptedException, InvocationTargetException {
        this.testImpl((AnimatorBase)new FPSAnimator(30), 0, false);
    }

    @Test
    public void test02FPSAnimator_RestartOnAWTEDT() throws InterruptedException, InvocationTargetException {
        this.testImpl((AnimatorBase)new FPSAnimator(30), 200, false);
    }

    private static void setFrameTitle(final Frame frame, final String string) {
        System.err.println("About to setTitle: <" + string + "> CT " + Thread.currentThread().getName() + ", " + frame + ", displayable " + frame.isDisplayable() + ", valid " + frame.isValid() + ", visible " + frame.isVisible());
        AWTEDTExecutor.singleton.invoke(true, new Runnable(){

            @Override
            public void run() {
                frame.setTitle(string);
            }
        });
    }

    void testImpl(final AnimatorBase animatorBase, int n, boolean bl) throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame("Frame 1");
        final Applet applet = new Applet(){
            private static final long serialVersionUID = 1L;
        };
        VersionNumber versionNumber = new VersionNumber(1, 7, 0);
        final boolean bl2 = Platform.OSType.MACOS == Platform.getOSType() && 0 > Platform.getJavaVersionNumber().compareTo(versionNumber);
        System.err.println("OSX CALayer AWT-Mod Bug " + bl2);
        System.err.println("OSType " + Platform.getOSType());
        System.err.println("Java Version " + Platform.getJavaVersionNumber());
        Assert.assertNotNull((Object)frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setLayout(null);
                frame.pack();
                Insets insets = frame.getInsets();
                int n = 512 + insets.left + insets.right;
                int n2 = 512 + insets.top + insets.bottom;
                frame.setSize(n, n2);
                int n3 = n2 - insets.top - insets.bottom;
                applet.setBounds((n - 512) / 2, insets.top + (n3 - 512) / 2, 512, 512);
                frame.setLocation(0, 0);
                frame.setTitle("Generic Title");
                frame.add(applet);
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TestGLCanvasAWTActionDeadlock01AWT.this.dispose(frame, applet);
            }
        });
        this.gle1 = new GLEventListener(){
            boolean justInitialized = true;

            public void init(GLAutoDrawable gLAutoDrawable) {
                this.justInitialized = true;
                if (!bl2) {
                    System.err.println("*Init*: CT " + Thread.currentThread().getName());
                    TestGLCanvasAWTActionDeadlock01AWT.setFrameTitle(frame, "INIT");
                    frame.setResizable(false);
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
                System.err.println("*Dispose*: CT " + Thread.currentThread().getName());
                TestGLCanvasAWTActionDeadlock01AWT.setFrameTitle(frame, "DISPOSE");
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                if (!bl2 || !this.justInitialized) {
                    System.err.println("*Display*: CT " + Thread.currentThread().getName());
                    TestGLCanvasAWTActionDeadlock01AWT.setFrameTitle(frame, "f " + TestGLCanvasAWTActionDeadlock01AWT.this.frameCount + ", fps " + (null != animatorBase ? animatorBase.getLastFPS() : 0.0f));
                    frame.setResizable(false);
                }
                ++TestGLCanvasAWTActionDeadlock01AWT.this.frameCount;
                this.justInitialized = false;
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                if (!bl2 || !this.justInitialized) {
                    System.err.println("*Reshape*: CT " + Thread.currentThread().getName());
                    TestGLCanvasAWTActionDeadlock01AWT.setFrameTitle(frame, "RESHAPE");
                }
            }
        };
        this.gle2 = new GearsES2();
        GLCanvas gLCanvas = this.createGLCanvas();
        gLCanvas.addGLEventListener(this.gle1);
        gLCanvas.addGLEventListener(this.gle2);
        if (null != animatorBase) {
            System.err.println("About to start Animator: CT " + Thread.currentThread().getName());
            animatorBase.setUpdateFPSFrames(60, System.err);
            animatorBase.add((GLAutoDrawable)gLCanvas);
            animatorBase.start();
        }
        this.attachGLCanvas(applet, gLCanvas, false);
        System.err.println("About to setVisible.0 CT " + Thread.currentThread().getName());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    System.err.println("About to setVisible.1.0 CT " + Thread.currentThread().getName());
                    frame.setVisible(true);
                    System.err.println("About to setVisible.1.X CT " + Thread.currentThread().getName());
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        System.err.println("About to setVisible.X CT " + Thread.currentThread().getName());
        long l = 0 < n ? (long)n : 100L;
        for (long i = durationPerTest; 0L < i; i -= l) {
            if (null == animatorBase) {
                gLCanvas.display();
            }
            if (0 < n) {
                gLCanvas = this.restart(applet, gLCanvas, bl);
            }
            Thread.sleep(l);
        }
        this.dispose(frame, applet);
        if (null != animatorBase) {
            animatorBase.stop();
        }
        this.gle1 = null;
        this.gle2 = null;
    }

    GLCanvas createGLCanvas() {
        System.err.println("*** createGLCanvas.0");
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        gLCanvas.setBounds(0, 0, 512, 512);
        Assert.assertNotNull((Object)gLCanvas);
        System.err.println("*** createGLCanvas.X");
        this.frameCount = 0;
        return gLCanvas;
    }

    void dispose(final Frame frame, final Applet applet) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.remove(applet);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    GLCanvas restart(Applet applet, GLCanvas gLCanvas, boolean bl) throws InterruptedException {
        gLCanvas.disposeGLEventListener(this.gle1, true);
        gLCanvas.disposeGLEventListener(this.gle2, true);
        this.detachGLCanvas(applet, gLCanvas, bl);
        gLCanvas = this.createGLCanvas();
        this.attachGLCanvas(applet, gLCanvas, bl);
        gLCanvas.addGLEventListener(this.gle1);
        gLCanvas.addGLEventListener(this.gle2);
        return gLCanvas;
    }

    void attachGLCanvas(final Applet applet, final GLCanvas gLCanvas, boolean bl) {
        System.err.println("*** attachGLCanvas.0 on-current-thread " + bl + ", currentThread " + Thread.currentThread().getName());
        if (bl) {
            applet.setLayout(new BorderLayout());
            applet.add((Component)gLCanvas, "Center");
            applet.validate();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        applet.setLayout(new BorderLayout());
                        applet.add((Component)gLCanvas, "Center");
                        applet.validate();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Assume.assumeNoException((Throwable)throwable);
            }
        }
        System.err.println("*** attachGLCanvas.X");
    }

    void detachGLCanvas(final Applet applet, final GLCanvas gLCanvas, boolean bl) {
        System.err.println("*** detachGLCanvas.0 on-current-thread " + bl + ", currentThread " + Thread.currentThread().getName());
        if (bl) {
            applet.remove((Component)gLCanvas);
            applet.validate();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        applet.remove((Component)gLCanvas);
                        applet.validate();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Assume.assumeNoException((Throwable)throwable);
            }
        }
        System.err.println("*** detachGLCanvas.X");
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
        }
        JUnitCore.main((String[])new String[]{TestGLCanvasAWTActionDeadlock01AWT.class.getName()});
    }
}

