/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw02ES2ListenerFBO;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureState;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLJPanelTextureStateAWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 100L;

    @BeforeClass
    public static void initClass() {
    }

    public void testImpl(final boolean bl, int n) throws InterruptedException, IOException {
        GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        if (!GLProfile.isAvailable((String)"GL2ES2")) {
            System.err.println(this.getSimpleTestName(".") + ": GLProfile n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        final GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Dimension dimension = new Dimension(800, 400);
        gLJPanel.setMinimumSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        final JFrame jFrame = new JFrame("TestGLJPanelTextureStateAWT");
        Assert.assertNotNull((Object)jFrame);
        jFrame.getContentPane().add((Component)gLJPanel);
        Object object = new GearsES2(0);
        final TextureDraw02ES2ListenerFBO textureDraw02ES2ListenerFBO = new TextureDraw02ES2ListenerFBO((GLEventListener)object, 1, n);
        textureDraw02ES2ListenerFBO.setKeepTextureBound(bl);
        textureDraw02ES2ListenerFBO.setClearBuffers(false);
        object = new RedSquareES2(1);
        ((RedSquareES2)object).setClearBuffers(false);
        gLJPanel.addGLEventListener(new GLEventListener((RedSquareES2)object, gLReadBufferUtil, n){
            int gle0X;
            int gle0Y;
            int gle0W;
            int gle0H;
            int gle1X;
            int gle1Y;
            int gle1W;
            int gle1H;
            int tX;
            int tY;
            int tW;
            int tH;
            int shot = 0;
            final int border = 5;
            final /* synthetic */ RedSquareES2 val$gle1;
            final /* synthetic */ GLReadBufferUtil val$screenshot;
            final /* synthetic */ int val$texUnit;
            {
                this.val$gle1 = redSquareES2;
                this.val$screenshot = gLReadBufferUtil;
                this.val$texUnit = n;
            }

            void setupTex(GL gL) {
                if (bl) {
                    gL.glTexParameteri(3553, 10240, 9729);
                    gL.glTexParameteri(3553, 10241, 9729);
                    gL.glTexParameteri(3553, 10242, 10497);
                    gL.glTexParameteri(3553, 10243, 10497);
                }
            }

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                gL2ES2.glActiveTexture(33985);
                gL2ES2.glBindTexture(3553, 0);
                gL2ES2.glTexParameteri(3553, 10240, 9729);
                gL2ES2.glTexParameteri(3553, 10241, 9728);
                gL2ES2.glTexParameteri(3553, 10242, 10497);
                gL2ES2.glTexParameteri(3553, 10243, 10497);
                gL2ES2.glActiveTexture(33984);
                gL2ES2.glBindTexture(3553, 0);
                gL2ES2.glTexParameteri(3553, 10240, 9729);
                gL2ES2.glTexParameteri(3553, 10241, 9728);
                gL2ES2.glTexParameteri(3553, 10242, 10497);
                gL2ES2.glTexParameteri(3553, 10243, 10497);
                textureDraw02ES2ListenerFBO.init(gLAutoDrawable);
                this.val$gle1.init(gLAutoDrawable);
                this.setupTex((GL)gL2ES2);
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
                textureDraw02ES2ListenerFBO.dispose(gLAutoDrawable);
                this.val$gle1.dispose(gLAutoDrawable);
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                String string;
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gL2ES2.glClear(16640);
                int[] nArray = new int[]{0, 0, 0, 0};
                gL2ES2.glGetIntegerv(2978, nArray, 0);
                if (this.gle0X != nArray[0] || this.gle0Y != nArray[1] || this.gle0W != nArray[2] || this.gle0H != nArray[3]) {
                    string = "Expected " + nArray[0] + "/" + nArray[1] + " " + nArray[2] + "x" + nArray[3] + ", actual " + this.gle0X + "/" + this.gle0Y + " " + this.gle0W + "x" + this.gle0H;
                    Assert.assertTrue((String)("Viewport not restored: " + string), (boolean)false);
                }
                textureDraw02ES2ListenerFBO.display(gLAutoDrawable);
                gL2ES2.glViewport(this.gle1X, this.gle1Y, this.gle1W, this.gle1H);
                this.val$gle1.display(gLAutoDrawable);
                ++this.shot;
                if (4 == this.shot) {
                    gL2ES2.glViewport(this.tX, this.tY, this.tW, this.tH);
                    TestGLJPanelTextureStateAWT.this.snapshot(0, null, gLAutoDrawable.getGL(), this.val$screenshot, "png", null);
                }
                gL2ES2.glViewport(this.gle0X, this.gle0Y, this.gle0W, this.gle0H);
                string = new TextureState(gLAutoDrawable.getGL(), 3553);
                Assert.assertEquals((String)"Texture unit changed", (long)(33984 + this.val$texUnit), (long)string.getUnit());
                if (bl) {
                    Assert.assertEquals((String)"Texture mag-filter changed", (long)9729L, (long)string.getMagFilter());
                    Assert.assertEquals((String)"Texture mag-filter changed", (long)9729L, (long)string.getMinFilter());
                    Assert.assertEquals((String)"Texture wrap-s changed", (long)10497L, (long)string.getWrapS());
                    Assert.assertEquals((String)"Texture wrap-t changed", (long)10497L, (long)string.getWrapT());
                }
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                this.gle0X = n + 5;
                this.gle0Y = n2;
                this.gle0W = n3 / 2 - 10;
                this.gle0H = n4;
                this.gle1X = this.gle0X + this.gle0W + 10;
                this.gle1Y = n2;
                this.gle1W = n3 / 2 - 10;
                this.gle1H = n4;
                this.tX = n;
                this.tY = n2;
                this.tW = n3;
                this.tH = n4;
                GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                gL2ES2.glViewport(this.gle0X, this.gle0Y, this.gle0W, this.gle0H);
                textureDraw02ES2ListenerFBO.reshape(gLAutoDrawable, this.gle0X, this.gle0Y, this.gle0W, this.gle0H);
                gL2ES2.glViewport(this.gle1X, this.gle1Y, this.gle1W, this.gle1H);
                this.val$gle1.reshape(gLAutoDrawable, this.gle1X, this.gle1Y, this.gle1W, this.gle1H);
                gL2ES2.glViewport(this.gle0X, this.gle0Y, this.gle0W, this.gle0H);
                if (bl) {
                    this.setupTex((GL)gL2ES2);
                }
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLJPanel);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)quitAdapter).addTo((Component)gLJPanel);
        new AWTWindowAdapter((WindowListener)quitAdapter).addTo((Component)gLJPanel);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.remove((Component)gLJPanel);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test
    public void test01_texUnit0_keepTex0_ES2() throws InterruptedException, IOException {
        this.testImpl(false, 0);
    }

    @Test
    public void test02_texUnit0_keepTex1_ES2() throws InterruptedException, IOException {
        this.testImpl(true, 0);
    }

    @Test
    public void test03_texUnit1_keepTex1_ES2() throws InterruptedException, IOException {
        this.testImpl(true, 1);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestGLJPanelTextureStateAWT.class.getName()});
    }
}

