/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.awt;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.awt.AWTGLPixelBuffer;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.nio.FloatBuffer;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2GLJPanelsAWT
extends UITestCase {
    static int demoCount = 4;
    static boolean jOpaque = false;
    static boolean glOpaque = true;
    static float glAlpha = 0.3f;
    static boolean jZOrder = false;
    static GLProfile glp;
    static boolean shallUsePBuffer;
    static boolean shallUseBitmap;
    static boolean useMSAA;
    static int swapInterval;
    static boolean useAnimator;
    static boolean manualTest;
    static boolean initSingleBuffer;
    static AWTGLPixelBuffer.SingleAWTGLPixelBufferProvider singleAWTGLPixelBufferProvider;
    static final boolean useInterPanel = true;
    public static final FloatBuffer red;
    public static final FloatBuffer green;
    public static final FloatBuffer blue;
    public static final FloatBuffer yellow;
    public static final FloatBuffer grey;
    public static final float grayf = 0.3f;
    public static final float[] redish;
    public static final float[] greenish;
    public static final float[] blueish;
    public static final float[] yellowish;
    public static final float[] greyish;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
        } else {
            TestGearsES2GLJPanelsAWT.setTestSupported(false);
        }
        if (initSingleBuffer) {
            singleAWTGLPixelBufferProvider = new AWTGLPixelBuffer.SingleAWTGLPixelBufferProvider(glp.isGL2ES3());
            singleAWTGLPixelBufferProvider.initSingleton(4, 600, 600, 1, true);
        } else {
            singleAWTGLPixelBufferProvider = null;
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    private JComponent addPanel(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLAnimatorControl gLAnimatorControl, JFrame jFrame, boolean bl, int n, int n2, int n3, int n4, FloatBuffer floatBuffer, float[] fArray) throws InterruptedException, InvocationTargetException {
        Object object;
        Object object2;
        GLJPanel gLJPanel = new GLJPanel(gLCapabilitiesImmutable);
        if (initSingleBuffer) {
            gLJPanel.setPixelBufferProvider((AWTGLPixelBuffer.AWTGLPixelBufferProvider)singleAWTGLPixelBufferProvider);
        }
        gLJPanel.setOpaque(bl);
        if (gLCapabilitiesImmutable.isBitmap()) {
            object2 = new Gears(swapInterval);
        } else {
            object = new GearsES2(swapInterval);
            ((GearsES2)object).setIgnoreFocus(true);
            ((GearsES2)object).setGearsColors(floatBuffer, floatBuffer, floatBuffer);
            ((GearsES2)object).setClearColor(fArray);
            object2 = object;
        }
        gLJPanel.addGLEventListener((GLEventListener)object2);
        if (null != gLAnimatorControl) {
            gLAnimatorControl.add((GLAutoDrawable)gLJPanel);
        }
        object = new JPanel(new BorderLayout());
        ((Component)object).setBounds(n, n2, n3, n4);
        ((JComponent)object).setOpaque(bl);
        JTextField jTextField = new JTextField(n + "/" + n2 + " " + n3 + "x" + n4);
        jTextField.setOpaque(true);
        SwingUtilities.invokeAndWait(new Runnable((JPanel)object, jTextField, gLJPanel, jFrame){
            final /* synthetic */ JPanel val$panel;
            final /* synthetic */ JTextField val$text;
            final /* synthetic */ GLJPanel val$canvas;
            final /* synthetic */ JFrame val$frame;
            {
                this.val$panel = jPanel;
                this.val$text = jTextField;
                this.val$canvas = gLJPanel;
                this.val$frame = jFrame;
            }

            @Override
            public void run() {
                this.val$panel.add((Component)this.val$text, "North");
                this.val$panel.add((Component)this.val$canvas, "Center");
                this.val$frame.getContentPane().add((Component)this.val$panel, 0);
            }
        });
        return object;
    }

    protected void relayout(Container container, float f, float f2) {
        int n = container.getComponentCount();
        int n2 = container.getWidth();
        int n3 = container.getHeight();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            float f3 = (float)component.getX() / f;
            float f4 = (float)component.getY() / f2;
            float f5 = (float)component.getWidth() / f;
            float f6 = (float)component.getHeight() / f2;
            component.setBounds((int)(f3 * (float)n2), (int)(f4 * (float)n3), (int)(f5 * (float)n2), (int)(f6 * (float)n3));
        }
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws AWTException, InterruptedException, InvocationTargetException {
        long l;
        Object object;
        if (!glOpaque) {
            gLCapabilities.setAlphaBits(gLCapabilities.getRedBits());
        }
        final JFrame jFrame = new JFrame("Swing GLJPanel");
        Assert.assertNotNull((Object)jFrame);
        FPSAnimator fPSAnimator = useAnimator ? new FPSAnimator(60) : null;
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.getContentPane().setLayout(null);
            }
        });
        final float[] fArray = new float[]{600.0f, 600.0f};
        jFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = jFrame.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    TestGearsES2GLJPanelsAWT.this.relayout(jFrame.getContentPane(), fArray[0], fArray[1]);
                }
                jFrame.getContentPane().invalidate();
                jFrame.getContentPane().validate();
                fArray[0] = jFrame.getContentPane().getWidth();
                fArray[1] = jFrame.getContentPane().getHeight();
            }
        });
        if (demoCount > 0) {
            this.addPanel((GLCapabilitiesImmutable)gLCapabilities, (GLAnimatorControl)fPSAnimator, jFrame, jOpaque, 50, 50, 300, 300, red, redish);
        }
        if (demoCount > 1) {
            this.addPanel((GLCapabilitiesImmutable)gLCapabilities, (GLAnimatorControl)fPSAnimator, jFrame, jOpaque, 0, 250, 300, 300, blue, blueish);
        }
        if (demoCount > 2) {
            this.addPanel((GLCapabilitiesImmutable)gLCapabilities, (GLAnimatorControl)fPSAnimator, jFrame, jOpaque, 300, 0, 150, 150, green, greenish);
        }
        if (demoCount > 3) {
            this.addPanel((GLCapabilitiesImmutable)gLCapabilities, (GLAnimatorControl)fPSAnimator, jFrame, jOpaque, 300, 300, 100, 100, yellow, yellowish);
        }
        if (jZOrder) {
            object = jFrame.getContentPane();
            int n = ((Container)object).getComponentCount();
            for (int i = 0; i < n; ++i) {
                ((Container)object).setComponentZOrder(((Container)object).getComponent(i), n - 1 - i);
            }
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setSize((int)fArray[0], (int)fArray[1]);
                jFrame.getContentPane().validate();
                jFrame.setVisible(true);
            }
        });
        if (useAnimator) {
            fPSAnimator.setUpdateFPSFrames(60, System.err);
            fPSAnimator.start();
            Assert.assertEquals((Object)true, (Object)fPSAnimator.isAnimating());
        }
        object = new QuitAdapter();
        long l2 = l = System.currentTimeMillis();
        while (!((QuitAdapter)((Object)object)).shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull((Object)jFrame);
        Assert.assertNotNull((Object)fPSAnimator);
        if (useAnimator) {
            fPSAnimator.stop();
            Assert.assertEquals((Object)false, (Object)fPSAnimator.isAnimating());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
    }

    @Test
    public void test01_DefaultNorm() throws AWTException, InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        if (useMSAA) {
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setSampleBuffers(true);
        }
        if (shallUsePBuffer) {
            gLCapabilities.setPBuffer(true);
        }
        if (shallUseBitmap) {
            gLCapabilities.setBitmap(true);
        }
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test02_DefaultMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test03_PbufferNorm() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setPBuffer(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test04_PbufferMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setPBuffer(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test05_BitmapNorm() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setBitmap(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test06_BitmapMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setBitmap(true);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-msaa")) {
                useMSAA = true;
                continue;
            }
            if (stringArray[i].equals("-jOpaque")) {
                jOpaque = MiscUtils.atob(stringArray[++i], jOpaque);
                continue;
            }
            if (stringArray[i].equals("-glOpaque")) {
                glOpaque = MiscUtils.atob(stringArray[++i], glOpaque);
                continue;
            }
            if (stringArray[i].equals("-alpha")) {
                glAlpha = MiscUtils.atof(stringArray[++i], glAlpha);
                continue;
            }
            if (stringArray[i].equals("-initSingleBuffer")) {
                initSingleBuffer = MiscUtils.atob(stringArray[++i], initSingleBuffer);
                continue;
            }
            if (stringArray[i].equals("-jZOrder")) {
                jZOrder = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-pbuffer")) {
                shallUsePBuffer = true;
                continue;
            }
            if (stringArray[i].equals("-bitmap")) {
                shallUseBitmap = true;
                continue;
            }
            if (stringArray[i].equals("-manual")) {
                manualTest = true;
                continue;
            }
            if (!stringArray[i].equals("-demos")) continue;
            demoCount = MiscUtils.atoi(stringArray[++i], demoCount);
        }
        System.err.println("swapInterval " + swapInterval);
        System.err.println("opaque gl " + glOpaque + ", java/gljpanel " + jOpaque);
        System.err.println("alpha " + glAlpha);
        System.err.println("jZOrder " + jZOrder);
        System.err.println("demos " + demoCount);
        System.err.println("useMSAA " + useMSAA);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("shallUsePBuffer " + shallUsePBuffer);
        System.err.println("shallUseBitmap " + shallUseBitmap);
        System.err.println("manualTest " + manualTest);
        System.err.println("useSingleBuffer " + initSingleBuffer);
        JUnitCore.main((String[])new String[]{TestGearsES2GLJPanelsAWT.class.getName()});
    }

    static {
        shallUsePBuffer = false;
        shallUseBitmap = false;
        useMSAA = false;
        swapInterval = 0;
        useAnimator = true;
        manualTest = false;
        initSingleBuffer = false;
        red = Buffers.newDirectFloatBuffer((float[])new float[]{1.0f, 0.0f, 0.0f, 1.0f});
        green = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 1.0f, 0.0f, 1.0f});
        blue = Buffers.newDirectFloatBuffer((float[])new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        yellow = Buffers.newDirectFloatBuffer((float[])new float[]{1.0f, 1.0f, 0.0f, 1.0f});
        grey = Buffers.newDirectFloatBuffer((float[])new float[]{0.5f, 0.5f, 0.5f, 1.0f});
        redish = new float[]{0.3f, 0.0f, 0.0f, glAlpha};
        greenish = new float[]{0.0f, 0.3f, 0.0f, glAlpha};
        blueish = new float[]{0.0f, 0.0f, 0.3f, glAlpha};
        yellowish = new float[]{0.3f, 0.3f, 0.0f, glAlpha};
        greyish = new float[]{0.3f, 0.3f, 0.3f, glAlpha};
        duration = 500L;
    }
}

