/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2.awt;

import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsAWTAnalyzeBug455
extends UITestCase {
    static long duration = 500L;
    static boolean waitForKey = false;
    static boolean altSwap = true;
    static GLProfile glp;
    static int width;
    static int height;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
            width = 512;
            height = 512;
        } else {
            TestGearsAWTAnalyzeBug455.setTestSupported(false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame("Gears AWT Test");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.setAutoSwapBufferMode(!altSwap);
        frame.add((Component)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new Gears(0));
        gLCanvas.addGLEventListener((GLEventListener)new Swapper());
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter)).addTo((Component)gLCanvas);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter)).addTo((Component)frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(512, 512);
                frame.setVisible(true);
            }
        });
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull((Object)frame);
        Assert.assertNotNull((Object)gLCanvas);
        Assert.assertNotNull((Object)animator);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove((Component)gLCanvas);
                frame.dispose();
            }
        });
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setDoubleBuffered(true);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (!stringArray[i].equals("-autoswap")) continue;
            altSwap = false;
        }
        System.err.println("altSwap " + altSwap);
        if (waitForKey) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main((String[])new String[]{TestGearsAWTAnalyzeBug455.class.getName()});
    }

    static class Swapper
    implements GLEventListener {
        Swapper() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            System.err.println("auto-swap: " + gLAutoDrawable.getAutoSwapBufferMode());
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            if (!gLAutoDrawable.getAutoSwapBufferMode()) {
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                gL2.glReadBuffer(1029);
                gL2.glDrawBuffer(1028);
                gL2.glCopyPixels(0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), 6144);
                gL2.glDrawBuffer(1029);
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    }
}

