/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.swt;

import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.opengl.test.junit.jogl.demos.es1.OneTriangle;
import com.jogamp.opengl.test.junit.util.UITestCase;
import javax.media.opengl.GL2ES1;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLProfile;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSWTEclipseGLCanvas01GLn
extends UITestCase {
    static int duration = 250;
    static final int iwidth = 640;
    static final int iheight = 480;
    Display display = null;
    Shell shell = null;
    Composite composite = null;

    @BeforeClass
    public static void startup() {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
    }

    @Before
    public void init() {
        SWTAccessor.invoke((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestSWTEclipseGLCanvas01GLn.this.display = new Display();
                Assert.assertNotNull((Object)TestSWTEclipseGLCanvas01GLn.this.display);
                TestSWTEclipseGLCanvas01GLn.this.shell = new Shell(TestSWTEclipseGLCanvas01GLn.this.display);
                Assert.assertNotNull((Object)TestSWTEclipseGLCanvas01GLn.this.shell);
                TestSWTEclipseGLCanvas01GLn.this.shell.setLayout((Layout)new FillLayout());
                TestSWTEclipseGLCanvas01GLn.this.composite = new Composite((Composite)TestSWTEclipseGLCanvas01GLn.this.shell, 0);
                TestSWTEclipseGLCanvas01GLn.this.composite.setLayout((Layout)new FillLayout());
                Assert.assertNotNull((Object)TestSWTEclipseGLCanvas01GLn.this.composite);
            }
        });
    }

    @After
    public void release() {
        Assert.assertNotNull((Object)this.display);
        Assert.assertNotNull((Object)this.shell);
        Assert.assertNotNull((Object)this.composite);
        try {
            SWTAccessor.invoke((boolean)true, (Runnable)new Runnable(){

                @Override
                public void run() {
                    TestSWTEclipseGLCanvas01GLn.this.composite.dispose();
                    TestSWTEclipseGLCanvas01GLn.this.shell.dispose();
                    TestSWTEclipseGLCanvas01GLn.this.display.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        this.display = null;
        this.shell = null;
        this.composite = null;
    }

    protected void runTestAGL(GLProfile gLProfile) throws InterruptedException {
        GLData gLData = new GLData();
        gLData.doubleBuffer = true;
        final GLCanvas gLCanvas = new GLCanvas(this.composite, 262144, gLData);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.setCurrent();
        final GLContext gLContext = GLDrawableFactory.getFactory((GLProfile)gLProfile).createExternalGLContext();
        Assert.assertNotNull((Object)gLContext);
        gLCanvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = gLCanvas.getClientArea();
                gLCanvas.setCurrent();
                gLContext.makeCurrent();
                GL2ES1 gL2ES1 = gLContext.getGL().getGL2ES1();
                OneTriangle.setup(gL2ES1, rectangle.width, rectangle.height);
                gLContext.release();
                System.err.println("resize");
            }
        });
        gLCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle rectangle = gLCanvas.getClientArea();
                gLCanvas.setCurrent();
                gLContext.makeCurrent();
                GL2ES1 gL2ES1 = gLContext.getGL().getGL2ES1();
                OneTriangle.render(gL2ES1, rectangle.width, rectangle.height);
                gLCanvas.swapBuffers();
                gLContext.release();
                System.err.println("paint");
            }
        });
        this.shell.setText(this.getClass().getName());
        this.shell.setSize(640, 480);
        this.shell.open();
        long l = System.currentTimeMillis();
        long l2 = l + (long)duration;
        try {
            while (System.currentTimeMillis() < l2 && !gLCanvas.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                Thread.sleep(10L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLCanvas.dispose();
    }

    @Test
    public void test() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES1();
        this.runTestAGL(gLProfile);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = TestSWTEclipseGLCanvas01GLn.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + duration);
        JUnitCore.main((String[])new String[]{TestSWTEclipseGLCanvas01GLn.class.getName()});
    }
}

