/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureData;
import com.jogamp.opengl.util.texture.spi.JPEGImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.Buffer;
import javax.imageio.ImageIO;
import javax.media.opengl.GLProfile;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestJPEGJoglAWTBenchmarkNewtAWT
extends UITestCase {
    static boolean showFPS = false;
    static String fname = "j1-baseline.jpg";

    @Test
    public void benchmark() throws IOException {
        this.benchmarkImpl(100, fname);
    }

    void benchmarkImpl(int n, String string) throws IOException {
        TextureData textureData;
        Object object;
        URLConnection uRLConnection;
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            uRLConnection = IOUtil.getResource(this.getClass(), (String)string);
            InputStream inputStream = uRLConnection.getInputStream();
            object = JPEGImage.read((InputStream)inputStream);
            int n2 = object.getBytesPerPixel() == 4 ? 6408 : 6407;
            textureData = new TextureData(GLProfile.getGL2ES2(), n2, object.getWidth(), object.getHeight(), 0, new GLPixelBuffer.GLPixelAttributes(object.getGLFormat(), object.getGLType()), false, false, false, (Buffer)object.getData(), null);
            if (0 == i || n - 1 == i) {
                System.err.println(i + ": " + object.toString());
                System.err.println(i + ": " + textureData + ", buffer " + textureData.getBuffer());
            }
            inputStream.close();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        float f = (float)l3 / (float)n;
        System.err.println("JOGL.RGB Loops " + n + ", dt " + l3 + " ms, " + f + " ms/l");
        l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            uRLConnection = IOUtil.getResource(this.getClass(), (String)string);
            InputStream inputStream = uRLConnection.getInputStream();
            object = JPEGImage.read((InputStream)inputStream, (TextureData.ColorSpace)TextureData.ColorSpace.YCbCr);
            int n3 = object.getBytesPerPixel() == 4 ? 6408 : 6407;
            textureData = new TextureData(GLProfile.getGL2ES2(), n3, object.getWidth(), object.getHeight(), 0, new GLPixelBuffer.GLPixelAttributes(object.getGLFormat(), object.getGLType()), false, false, false, (Buffer)object.getData(), null);
            if (0 == i || n - 1 == i) {
                System.err.println(i + ": " + object.toString());
                System.err.println(i + ": " + textureData + ", buffer " + textureData.getBuffer());
            }
            inputStream.close();
        }
        long l4 = System.currentTimeMillis();
        long l5 = l4 - l;
        float f2 = (float)l5 / (float)n;
        System.err.println("JOGL.YUV Loops " + n + ", dt " + l5 + " ms, " + f2 + " ms/l");
        l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            uRLConnection = IOUtil.getResource(this.getClass(), (String)string);
            InputStream inputStream = uRLConnection.getInputStream();
            object = null;
            try {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                textureData = new AWTTextureData(GLProfile.getGL2ES2(), 0, 0, false, bufferedImage);
                object = textureData.getBuffer();
                if (0 == i || n - 1 == i) {
                    System.err.println(i + ": " + textureData + ", buffer " + object);
                }
            }
            catch (Exception exception) {
                System.err.println("AWT ImageIO failure w/ file " + string + ": " + exception.getMessage());
            }
            inputStream.close();
        }
        long l6 = System.currentTimeMillis();
        long l7 = l6 - l;
        float f3 = (float)l7 / (float)n;
        System.err.println("AWT..... Loops " + n + ", dt " + l7 + " ms, " + f3 + " ms/l");
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-file")) continue;
            fname = stringArray[++i];
        }
        JUnitCore.main((String[])new String[]{TestJPEGJoglAWTBenchmarkNewtAWT.class.getName()});
    }
}

