/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.TextureDraw01GL2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestJPEGTextureFromFileNEWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 100L;
    InputStream testTextureStream01YUV444_Base;
    InputStream testTextureStream01YUV444_Prog;
    InputStream testTextureStream01YUV422h_Base;
    InputStream testTextureStream01YUV422h_Prog;
    InputStream testTextureStream02YUV420_Base;
    InputStream testTextureStream02YUV420_Prog;
    InputStream testTextureStream02YUV420_BaseGray;
    InputStream testTextureStream03CMYK_01;
    InputStream testTextureStream03YCCK_01;
    InputStream testTextureStream04QTTDefPostFrame;

    @Before
    public void initTest() throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), (String)"test-ntscN_3-01-160x90-90pct-yuv444-base.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream01YUV444_Base = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream01YUV444_Base);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"test-ntscN_3-01-160x90-90pct-yuv444-prog.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream01YUV444_Prog = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream01YUV444_Prog);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"test-ntscN_3-01-160x90-60pct-yuv422h-base.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream01YUV422h_Base = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream01YUV422h_Base);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"test-ntscN_3-01-160x90-60pct-yuv422h-prog.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream01YUV422h_Prog = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream01YUV422h_Prog);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"j1-baseline.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream02YUV420_Base = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream02YUV420_Base);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"j2-progressive.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream02YUV420_Prog = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream02YUV420_Prog);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"j3-baseline_gray.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream02YUV420_BaseGray = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream02YUV420_BaseGray);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"test-cmyk-01.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream03CMYK_01 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream03CMYK_01);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"test-ycck-01.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream03YCCK_01 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream03YCCK_01);
        uRLConnection = IOUtil.getResource(this.getClass(), (String)"bug745_qttdef_post_frame.jpg");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream04QTTDefPostFrame = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream04QTTDefPostFrame);
    }

    @After
    public void cleanupTest() {
        this.testTextureStream01YUV444_Base = null;
        this.testTextureStream01YUV444_Prog = null;
        this.testTextureStream01YUV422h_Base = null;
        this.testTextureStream01YUV422h_Prog = null;
        this.testTextureStream02YUV420_Base = null;
        this.testTextureStream02YUV420_Prog = null;
        this.testTextureStream02YUV420_BaseGray = null;
        this.testTextureStream03CMYK_01 = null;
        this.testTextureStream03YCCK_01 = null;
        this.testTextureStream04QTTDefPostFrame = null;
    }

    public void testImpl(boolean bl, InputStream inputStream) throws InterruptedException, IOException {
        GLProfile gLProfile;
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        if (bl && GLProfile.isAvailable((String)"GL2")) {
            gLProfile = GLProfile.getMaxFixedFunc((boolean)true);
        } else if (!bl && GLProfile.isAvailable((String)"GL2ES2")) {
            gLProfile = GLProfile.getGL2ES2();
        } else {
            System.err.println(this.getSimpleTestName(".") + ": GLProfile n/a, useFFP: " + bl);
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(1);
        TextureData textureData = TextureIO.newTextureData((GLProfile)gLProfile, (InputStream)inputStream, (boolean)false, (String)"jpg");
        System.err.println("TextureData: " + textureData);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle("TestPNGTextureGL2FromFileNEWT");
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        final GLEventListener gLEventListener = bl ? new TextureDraw01GL2Listener(textureData) : new TextureDraw01ES2Listener(textureData, 0);
        gLWindow.addGLEventListener(gLEventListener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != ((TextureDraw01Accessor)gLEventListener).getTexture() && !this.shot) {
                    this.shot = true;
                    TestJPEGTextureFromFileNEWT.this.snapshot(0, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test01YUV444Base__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStream01YUV444_Base);
    }

    @Test
    public void test01YUV444Base__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream01YUV444_Base);
    }

    @Test
    public void test01YUV444Prog__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStream01YUV444_Prog);
    }

    @Test
    public void test01YUV444Prog__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream01YUV444_Prog);
    }

    @Test
    public void test01YUV422hBase__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream01YUV422h_Base);
    }

    @Test
    public void test01YUV422hProg_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream01YUV422h_Prog);
    }

    @Test
    public void test02YUV420Base__ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream02YUV420_Base);
    }

    @Test
    public void test02YUV420Prog_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream02YUV420_Prog);
    }

    @Test
    public void test02YUV420BaseGray_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream02YUV420_BaseGray);
    }

    @Test
    public void test03CMYK_01_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream03CMYK_01);
    }

    @Test
    public void test03YCCK_01_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream03YCCK_01);
    }

    @Test
    public void test04QTTDefPostFrame_ES2() throws InterruptedException, IOException {
        this.testImpl(false, this.testTextureStream04QTTDefPostFrame);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestJPEGTextureFromFileNEWT.class.getName()});
    }
}

