/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.PNGImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.Buffer;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPNGImage01NEWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 200L;
    static String _fname = null;

    public void testImpl(InputStream inputStream) throws InterruptedException, IOException {
        PNGImage pNGImage = PNGImage.read((InputStream)inputStream);
        Assert.assertNotNull((Object)pNGImage);
        boolean bl = 4 == pNGImage.getBytesPerPixel();
        System.err.println("PNGImage: " + pNGImage);
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (bl) {
            gLCapabilities.setAlphaBits(1);
        }
        int n = gLProfile.isGL2ES3() ? (bl ? 32856 : 32849) : (bl ? 6408 : 6407);
        TextureData textureData = new TextureData(gLProfile, n, pNGImage.getWidth(), pNGImage.getHeight(), 0, new GLPixelBuffer.GLPixelAttributes(pNGImage.getGLFormat(), pNGImage.getGLType()), false, false, false, (Buffer)pNGImage.getData(), null);
        System.err.println("TextureData: " + textureData);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle("TestPNGImage01NEWT");
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        final TextureDraw01ES2Listener textureDraw01ES2Listener = new TextureDraw01ES2Listener(textureData, 0);
        gLWindow.addGLEventListener((GLEventListener)textureDraw01ES2Listener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            public void init(GLAutoDrawable gLAutoDrawable) {
                System.err.println("Chosen Caps: " + gLAutoDrawable.getChosenGLCapabilities());
                System.err.println("GL ctx: " + gLAutoDrawable.getGL().getContext());
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != textureDraw01ES2Listener.getTexture() && !this.shot) {
                    this.shot = true;
                    TestPNGImage01NEWT.this.snapshot(0, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void testRead01_RGBn_exp() throws InterruptedException, IOException, MalformedURLException {
        String string = null == _fname ? "bug724-transparent-grey_gimpexp.png" : _fname;
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), (String)string);
        this.testImpl(uRLConnection.getInputStream());
    }

    @Test
    public void testRead02_RGBn_orig() throws InterruptedException, IOException, MalformedURLException {
        if (null != _fname) {
            return;
        }
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), (String)"bug724-transparent-grey_orig.png");
        this.testImpl(uRLConnection.getInputStream());
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (!stringArray[i].equals("-file")) continue;
            _fname = stringArray[++i];
        }
        JUnitCore.main((String[])new String[]{TestPNGImage01NEWT.class.getName()});
    }
}

