/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.util.Point;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLProfile;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestCloseNewtAWT
extends UITestCase {
    GLWindow newtWindow = null;
    NewtCanvasAWT newtCanvas = null;
    JFrame frame = null;

    @Test
    public void testCloseNewtAWT() throws InterruptedException, InvocationTargetException {
        this.newtWindow = GLWindow.create((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getDefault()));
        this.newtCanvas = new MyCanvas((Window)this.newtWindow);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TestCloseNewtAWT.this.frame = new JFrame("NEWT Close Test");
                TestCloseNewtAWT.this.frame.setDefaultCloseOperation(2);
                TestCloseNewtAWT.this.frame.getContentPane().add((Component)TestCloseNewtAWT.this.newtCanvas);
                TestCloseNewtAWT.this.frame.pack();
                TestCloseNewtAWT.this.frame.setSize(800, 600);
                TestCloseNewtAWT.this.frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(this.frame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(this.newtWindow, true));
        AWTRobotUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(this.frame);
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.closeWindow(this.frame, true, windowClosingListener));
    }

    public static void main(String[] stringArray) {
        String string = TestCloseNewtAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    class MyCanvas
    extends NewtCanvasAWT {
        public MyCanvas(Window window) {
            super(window);
        }

        public void addNotify() {
            System.err.println("MyCanvas START add: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
            super.addNotify();
            System.err.println("MyCanvas END add: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
        }

        public void removeNotify() {
            System.err.println("MyCanvas START remove: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
            TestCloseNewtAWT.this.newtWindow.runOnEDTIfAvail(true, new Runnable(){

                @Override
                public void run() {
                    System.err.println("MyCanvas On NEWT-EDT From AWT-EDT: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(MyCanvas.this.getTreeLock()));
                    NativeWindow nativeWindow = MyCanvas.this.getNativeWindow();
                    if (null != nativeWindow) {
                        Point point = nativeWindow.getLocationOnScreen(null);
                        System.err.println("MyCanvas On NEWT-EDT: position: " + point);
                    } else {
                        System.err.println("MyCanvas On NEWT-EDT: position n/a, null NativeWindow");
                    }
                }
            });
            System.err.println("MyCanvas passed critical: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
            super.removeNotify();
            System.err.println("MyCanvas END remove: " + Thread.currentThread() + ", holds AWTTreeLock: " + Thread.holdsLock(this.getTreeLock()));
        }
    }
}

