/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.opengl.test.junit.util.FocusEventCountAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class AWTFocusAdapter
implements FocusEventCountAdapter,
FocusListener {
    String prefix;
    int focusCount;
    boolean wasTemporary;
    boolean verbose = true;

    public AWTFocusAdapter(String string) {
        this.prefix = string;
        this.reset();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = false;
    }

    @Override
    public boolean focusLost() {
        return this.focusCount < 0;
    }

    @Override
    public boolean focusGained() {
        return this.focusCount > 0;
    }

    @Override
    public void reset() {
        this.focusCount = 0;
        this.wasTemporary = false;
    }

    public boolean getWasTemporary() {
        return this.wasTemporary;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.focusCount < 0) {
            this.focusCount = 0;
        }
        ++this.focusCount;
        this.wasTemporary = focusEvent.isTemporary();
        if (this.verbose) {
            System.err.println("FOCUS AWT  GAINED " + (this.wasTemporary ? "TEMP" : "PERM") + " [fc " + this.focusCount + "]: " + this.prefix + ", " + focusEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.focusCount > 0) {
            this.focusCount = 0;
        }
        --this.focusCount;
        this.wasTemporary = focusEvent.isTemporary();
        if (this.verbose) {
            System.err.println("FOCUS AWT  LOST   " + (this.wasTemporary ? "TEMP" : "PERM") + " [fc " + this.focusCount + "]: " + this.prefix + ", " + focusEvent);
        }
    }

    public String toString() {
        return this.prefix + "[focusCount " + this.focusCount + ", temp " + this.wasTemporary + "]";
    }
}

