/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.opengl.test.junit.util.FocusEventCountAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;

public class AWTWindowFocusAdapter
implements FocusEventCountAdapter,
WindowFocusListener {
    String prefix;
    int focusCount;
    boolean verbose = true;

    public AWTWindowFocusAdapter(String string) {
        this.prefix = string;
        this.reset();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = false;
    }

    @Override
    public boolean focusLost() {
        return this.focusCount < 0;
    }

    @Override
    public boolean focusGained() {
        return this.focusCount > 0;
    }

    @Override
    public void reset() {
        this.focusCount = 0;
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        if (this.focusCount < 0) {
            this.focusCount = 0;
        }
        ++this.focusCount;
        if (this.verbose) {
            System.err.println("FOCUS AWT  GAINED (Window) [fc " + this.focusCount + "]: " + this.prefix + ", " + windowEvent);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (this.focusCount > 0) {
            this.focusCount = 0;
        }
        --this.focusCount;
        if (this.verbose) {
            System.err.println("FOCUS AWT  LOST   (Window) [fc " + this.focusCount + "]: " + this.prefix + ", " + windowEvent);
        }
    }

    public String toString() {
        return this.prefix + "[focusCount " + this.focusCount + "]";
    }
}

