/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.common.util.locks.SingletonInstance;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class UITestCase {
    @Rule
    public TestName _unitTestName = new TestName();
    public static final String SINGLE_INSTANCE_LOCK_FILE = "UITestCase.lock";
    public static final int SINGLE_INSTANCE_LOCK_PORT = 59999;
    public static final long SINGLE_INSTANCE_LOCK_TO = 360000L;
    public static final long SINGLE_INSTANCE_LOCK_POLL = 1000L;
    private static volatile SingletonInstance singletonInstance;
    private static volatile boolean testSupported;
    private static volatile boolean resetXRandRIfX11AfterClass;
    private static volatile int maxMethodNameLen;
    static final String unsupportedTestMsg = "Test not supported on this platform.";

    private static final synchronized void initSingletonInstance() {
        if (null == singletonInstance && !(singletonInstance = SingletonInstance.createServerSocket((long)1000L, (int)59999)).tryLock(360000L)) {
            throw new RuntimeException("Fatal: Could not lock single instance: " + singletonInstance.getName());
        }
    }

    public static boolean isTestSupported() {
        return testSupported;
    }

    public static void setTestSupported(boolean bl) {
        System.err.println("setTestSupported: " + bl);
        testSupported = bl;
    }

    public static void setResetXRandRIfX11AfterClass() {
        resetXRandRIfX11AfterClass = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetXRandRIfX11() {
        if (NativeWindowFactory.isInitialized() && NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType((boolean)true)) {
            try {
                String[] stringArray;
                ProcessBuilder processBuilder;
                CharSequence charSequence;
                Object object;
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object2 = object = new Object();
                synchronized (object2) {
                    charSequence = new StringBuilder();
                    processBuilder = new ProcessBuilder("xrandr", "-q");
                    processBuilder.redirectErrorStream(true);
                    System.err.println("XRandR Query: " + processBuilder.command());
                    stringArray = processBuilder.start();
                    MiscUtils.StreamDump streamDump = new MiscUtils.StreamDump((StringBuilder)charSequence, stringArray.getInputStream(), object);
                    streamDump.start();
                    while (!streamDump.eos()) {
                        object.wait();
                    }
                    stringArray.waitFor();
                    int n = stringArray.exitValue();
                    if (0 == n) {
                        BufferedReader bufferedReader = new BufferedReader(new StringReader(charSequence.toString()));
                        String string = null;
                        while ((string = bufferedReader.readLine()) != null) {
                            String string2;
                            String string3 = string.toLowerCase();
                            if (!string3.contains("connected") || string3.contains("disconnected") || null == (string2 = UITestCase.getFirst(string))) continue;
                            arrayList.add(string2);
                        }
                    } else {
                        System.err.println("XRandR Query Error Code " + n);
                        System.err.println(charSequence.toString());
                    }
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    charSequence = (String)arrayList.get(i);
                    processBuilder = null;
                    stringArray = null != processBuilder ? new String[]{"xrandr", "--output", charSequence, "--mode", processBuilder, "--rotate", "normal"} : new String[]{"xrandr", "--output", charSequence, "--preferred", "--rotate", "normal"};
                    System.err.println("XRandR Reset: " + Arrays.asList(stringArray));
                    int n = UITestCase.processCommand(stringArray, System.err, "xrandr-reset> ");
                    if (0 == n) continue;
                    System.err.println("XRandR Reset Error Code " + n);
                }
            }
            catch (Exception exception) {
                System.err.println("Catched " + exception.getClass().getName() + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private static String getFirst(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken().trim()).length() > 0) {
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int processCommand(String[] stringArray, OutputStream outputStream, String string) {
        int n = 0;
        Object object = new Object();
        try {
            Object object2 = object;
            synchronized (object2) {
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                MiscUtils.StreamDump streamDump = new MiscUtils.StreamDump(outputStream, string, process.getInputStream(), object);
                streamDump.start();
                while (!streamDump.eos()) {
                    object.wait();
                }
                process.waitFor();
                n = process.exitValue();
            }
        }
        catch (Exception exception) {
            System.err.println("Catched " + exception.getClass().getName() + ": " + exception.getMessage());
            exception.printStackTrace();
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    public int getMaxTestNameLen() {
        if (0 == maxMethodNameLen) {
            int n = 0;
            TestClass testClass = new TestClass(this.getClass());
            List list = testClass.getAnnotatedMethods(Test.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n2 = ((FrameworkMethod)iterator.next()).getName().length();
                if (n >= n2) continue;
                n = n2;
            }
            maxMethodNameLen = n;
        }
        return maxMethodNameLen;
    }

    public final String getTestMethodName() {
        return this._unitTestName.getMethodName();
    }

    public final String getSimpleTestName(String string) {
        return this.getClass().getSimpleName() + string + this.getTestMethodName();
    }

    public final String getFullTestName(String string) {
        return this.getClass().getName() + string + this.getTestMethodName();
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        UITestCase.initSingletonInstance();
    }

    @AfterClass
    public static void oneTimeTearDown() {
        if (resetXRandRIfX11AfterClass) {
            UITestCase.resetXRandRIfX11();
        }
        System.gc();
        singletonInstance.unlock();
    }

    @Before
    public void setUp() {
        System.err.print("++++ UITestCase.setUp: " + this.getFullTestName(" - "));
        if (!testSupported) {
            System.err.println(" - Test not supported on this platform.");
            Assume.assumeTrue((boolean)testSupported);
        }
        System.err.println();
    }

    @After
    public void tearDown() {
        System.err.println("++++ UITestCase.tearDown: " + this.getFullTestName(" - "));
    }

    public static void waitForKey(String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.err.println(string + "> Press enter to continue");
        try {
            System.err.println(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSnapshotFilename(int n, String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n2, int n3, boolean bl, String string2, String string3) {
        String string4;
        if (null == string2) {
            string2 = "png";
        }
        int n4 = this.getMaxTestNameLen() + this.getClass().getSimpleName().length() + 1;
        String string5 = this.getSimpleTestName(".");
        String string6 = string4 = gLCapabilitiesImmutable.getHardwareAccelerated() ? "hw" : "sw";
        String string7 = gLCapabilitiesImmutable.isOnscreen() ? "onscreen" : (gLCapabilitiesImmutable.isFBO() ? "fbobject" : (gLCapabilitiesImmutable.isPBuffer() ? "pbuffer_" : (gLCapabilitiesImmutable.isBitmap() ? "bitmap__" : "unknown_")));
        String string8 = gLCapabilitiesImmutable.getDoubleBuffered() ? "dbl" : "one";
        String string9 = bl ? "rgba" : "rgb_";
        String string10 = "rgba" + gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits() + gLCapabilitiesImmutable.getAlphaBits();
        int n5 = gLCapabilitiesImmutable.getDepthBits();
        int n6 = gLCapabilitiesImmutable.getStencilBits();
        int n7 = gLCapabilitiesImmutable.getNumSamples();
        String string11 = gLCapabilitiesImmutable.getSampleExtension();
        string = null != string ? "-" + string : "";
        String string12 = String.format("%-" + n4 + "s-n%04d%s-%-6s-%s-%s-B%s-F%s_I%s-D%02d-St%02d-Sa%02d_%s-%04dx%04d.%s", string5, n, string, gLCapabilitiesImmutable.getGLProfile().getName(), string4, string7, string8, string9, string10, n5, n6, n7, string11, n2, n3, string2).replace(' ', '_');
        return null != string3 ? string3 + File.separator + string12 : string12;
    }

    public void snapshot(int n, String string, GL gL, GLReadBufferUtil gLReadBufferUtil, String string2, String string3) {
        GLDrawable gLDrawable = gL.getContext().getGLReadDrawable();
        String string4 = this.getSnapshotFilename(n, string, gLDrawable.getChosenGLCapabilities(), gLDrawable.getWidth(), gLDrawable.getHeight(), gLReadBufferUtil.hasAlpha(), string2, string3);
        System.err.println(Thread.currentThread().getName() + ": ** screenshot: " + string4);
        gL.glFinish();
        if (gLReadBufferUtil.readPixels(gL, false)) {
            gLReadBufferUtil.write(new File(string4));
        }
    }

    static {
        testSupported = true;
        resetXRandRIfX11AfterClass = false;
        maxMethodNameLen = 0;
    }

    public class SnapshotGLEventListener
    implements GLEventListener {
        private final GLReadBufferUtil screenshot;
        private volatile boolean makeShot = false;
        private volatile boolean makeShotAlways = false;
        private volatile boolean verbose = false;
        private volatile int displayCount = 0;
        private volatile int reshapeCount = 0;
        private volatile String postSNDetail = null;

        public SnapshotGLEventListener(GLReadBufferUtil gLReadBufferUtil) {
            this.screenshot = gLReadBufferUtil;
        }

        public SnapshotGLEventListener() {
            this.screenshot = new GLReadBufferUtil(false, false);
        }

        public int getDisplayCount() {
            return this.displayCount;
        }

        public int getReshapeCount() {
            return this.reshapeCount;
        }

        public GLReadBufferUtil getGLReadBufferUtil() {
            return this.screenshot;
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            boolean bl;
            GL gL = gLAutoDrawable.getGL();
            boolean bl2 = bl = this.makeShot || this.makeShotAlways;
            if (this.verbose) {
                System.err.println(Thread.currentThread().getName() + ": ** display: " + this.displayCount + ": " + gLAutoDrawable.getWidth() + "x" + gLAutoDrawable.getHeight() + ", makeShot " + bl);
            }
            if (bl) {
                this.makeShot = false;
                UITestCase.this.snapshot(this.displayCount, this.postSNDetail, gL, this.screenshot, "png", null);
            }
            ++this.displayCount;
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            if (this.verbose) {
                System.err.println(Thread.currentThread().getName() + ": ** reshape: " + this.reshapeCount + ": " + n3 + "x" + n4 + " - " + gLAutoDrawable.getWidth() + "x" + gLAutoDrawable.getHeight());
            }
            ++this.reshapeCount;
        }

        public void setMakeSnapshot() {
            this.makeShot = true;
        }

        public void setMakeSnapshotAlways(boolean bl) {
            this.makeShotAlways = bl;
        }

        public void setVerbose(boolean bl) {
            this.verbose = bl;
        }

        public void setPostSNDetail(String string) {
            this.postSNDetail = string;
        }
    }
}

