/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.os.MachineDescription;
import com.jogamp.gluegen.CommentEmitter;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;

public class CMethodBindingEmitter
extends FunctionEmitter {
    protected static final Logger LOG = Logger.getLogger(CMethodBindingEmitter.class.getPackage().getName());
    protected static final CommentEmitter defaultCommentEmitter = new DefaultCommentEmitter();
    protected static final String arrayResLength = "_array_res_length";
    protected static final String arrayRes = "_array_res";
    protected static final String arrayIdx = "_array_idx";
    protected MethodBinding binding;
    private String packageName;
    private String className;
    private boolean isOverloadedBinding;
    private boolean isJavaMethodStatic;
    protected boolean forImplementingMethodCall;
    protected boolean forIndirectBufferAndArrayImplementation;
    private List<String> temporaryCVariableDeclarations;
    private List<String> temporaryCVariableAssignments;
    private MessageFormat returnValueCapacityExpression = null;
    private MessageFormat returnValueLengthExpression = null;
    protected static final String STRING_CHARS_PREFIX = "_strchars_";
    protected MachineDescription machDesc;

    public CMethodBindingEmitter(MethodBinding methodBinding, PrintWriter printWriter, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, MachineDescription machineDescription) {
        super(printWriter, false);
        assert (methodBinding != null);
        assert (string2 != null);
        assert (string != null);
        this.binding = methodBinding;
        this.packageName = string;
        this.className = string2;
        this.isOverloadedBinding = bl;
        this.isJavaMethodStatic = bl2;
        this.forImplementingMethodCall = bl3;
        this.forIndirectBufferAndArrayImplementation = bl4;
        this.machDesc = machineDescription;
        this.setCommentEmitter(defaultCommentEmitter);
    }

    public final MethodBinding getBinding() {
        return this.binding;
    }

    @Override
    public String getName() {
        return this.binding.getName();
    }

    public final MessageFormat getReturnValueCapacityExpression() {
        return this.returnValueCapacityExpression;
    }

    public final void setReturnValueCapacityExpression(MessageFormat messageFormat) {
        this.returnValueCapacityExpression = messageFormat;
        if (!this.binding.getJavaReturnType().isNIOBuffer() && !this.binding.getJavaReturnType().isCompoundTypeWrapper()) {
            throw new IllegalArgumentException("Cannot specify return value capacity for a method that does not return java.nio.Buffer or a compound type wrapper: \"" + this.binding + "\"");
        }
    }

    public final MessageFormat getReturnValueLengthExpression() {
        return this.returnValueLengthExpression;
    }

    public final void setReturnValueLengthExpression(MessageFormat messageFormat) {
        this.returnValueLengthExpression = messageFormat;
        if (!this.binding.getJavaReturnType().isArray() && !this.binding.getJavaReturnType().isArrayOfCompoundTypeWrappers()) {
            throw new IllegalArgumentException("Cannot specify return value length for a method that does not return an array: \"" + this.binding + "\"");
        }
    }

    public final List<String> getTemporaryCVariableDeclarations() {
        return this.temporaryCVariableDeclarations;
    }

    public final void setTemporaryCVariableDeclarations(List<String> list) {
        this.temporaryCVariableDeclarations = list;
    }

    public final List<String> getTemporaryCVariableAssignments() {
        return this.temporaryCVariableAssignments;
    }

    public final void setTemporaryCVariableAssignments(List<String> list) {
        this.temporaryCVariableAssignments = list;
    }

    public String getJavaPackageName() {
        return this.packageName;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public final boolean getIsOverloadedBinding() {
        return this.isOverloadedBinding;
    }

    public final boolean getIsJavaMethodStatic() {
        return this.isJavaMethodStatic;
    }

    public final boolean forIndirectBufferAndArrayImplementation() {
        return this.forIndirectBufferAndArrayImplementation;
    }

    public final MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    @Override
    protected void emitReturnType(PrintWriter printWriter) {
        printWriter.print("JNIEXPORT ");
        printWriter.print(this.binding.getJavaReturnType().jniTypeName());
        printWriter.print(" JNICALL");
    }

    @Override
    protected void emitName(PrintWriter printWriter) {
        printWriter.println();
        printWriter.print("Java_");
        printWriter.print(this.jniMangle(this.getJavaPackageName()));
        printWriter.print("_");
        printWriter.print(this.jniMangle(this.getJavaClassName()));
        printWriter.print("_");
        if (this.isOverloadedBinding) {
            printWriter.print(this.jniMangle(this.binding));
        } else {
            printWriter.print(this.jniMangle(this.getName()));
        }
    }

    protected String getImplSuffix() {
        if (this.forImplementingMethodCall) {
            if (this.forIndirectBufferAndArrayImplementation) {
                return "1";
            }
            return "0";
        }
        return "";
    }

    @Override
    protected int emitArguments(PrintWriter printWriter) {
        printWriter.print("JNIEnv *env, ");
        int n = 1;
        if (this.isJavaMethodStatic && !this.binding.hasContainingType()) {
            printWriter.print("jclass");
        } else {
            printWriter.print("jobject");
        }
        printWriter.print(" _unused");
        ++n;
        if (this.binding.hasContainingType()) {
            printWriter.print(", jobject " + JavaMethodBindingEmitter.javaThisArgumentName());
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            printWriter.print(", ");
            printWriter.print(javaType.jniTypeName());
            printWriter.print(" ");
            printWriter.print(this.binding.getArgumentName(i));
            ++n;
            if (javaType.isPrimitiveArray() || javaType.isNIOBuffer()) {
                printWriter.print(", jint " + this.byteOffsetArgName(i));
                if (!this.forIndirectBufferAndArrayImplementation) continue;
                printWriter.print(", jboolean " + this.isNIOArgName(i));
                continue;
            }
            if (!javaType.isNIOBufferArray()) continue;
            printWriter.print(", jintArray " + this.byteOffsetArrayArgName(i));
        }
        return n;
    }

    @Override
    protected void emitBody(PrintWriter printWriter) {
        printWriter.println(" {");
        this.emitBodyVariableDeclarations(printWriter);
        this.emitBodyUserVariableDeclarations(printWriter);
        this.emitBodyVariablePreCallSetup(printWriter);
        this.emitBodyCallCFunction(printWriter);
        this.emitBodyUserVariableAssignments(printWriter);
        this.emitBodyVariablePostCallCleanup(printWriter);
        this.emitBodyReturnResult(printWriter);
        printWriter.println("}");
        printWriter.println();
    }

    protected void emitBodyVariableDeclarations(PrintWriter printWriter) {
        String string;
        Object object;
        JavaType javaType;
        if (this.binding.hasContainingType()) {
            this.emitPointerDeclaration(printWriter, this.binding.getContainingType(), this.binding.getContainingCType(), CMethodBindingEmitter.cThisArgumentName(), null);
        }
        boolean bl = false;
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (javaType.isArray() || javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper() || javaType.isArrayOfCompoundTypeWrappers()) {
                object = this.binding.getArgumentName(i);
                string = this.pointerConversionArgumentName((String)object);
                boolean bl2 = this.emitPointerDeclaration(printWriter, javaType, this.binding.getCArgumentType(i), string, (String)object);
                if (!bl2 || bl) continue;
                printWriter.println("  jobject _tmpObj;");
                printWriter.println("  int _copyIndex;");
                printWriter.println("  jsize _tmpArrayLen;");
                printWriter.println("  int * _offsetHandle = NULL;");
                bl = true;
                continue;
            }
            if (!javaType.isString()) continue;
            object = this.binding.getCArgumentType(i);
            if (this.isUTF8Type((Type)object)) {
                printWriter.print("  const char* ");
            } else {
                printWriter.print("  jchar* ");
            }
            printWriter.print(STRING_CHARS_PREFIX);
            printWriter.print(this.binding.getArgumentName(i));
            printWriter.println(" = NULL;");
        }
        Type type = this.binding.getCReturnType();
        javaType = this.binding.getJavaReturnType();
        if (!type.isVoid()) {
            printWriter.print("  ");
            printWriter.print(this.binding.getCSymbol().getReturnType().getName(true));
            printWriter.println(" _res;");
            if (javaType.isNIOByteBufferArray() || javaType.isArrayOfCompoundTypeWrappers()) {
                printWriter.print("  int ");
                printWriter.print(arrayResLength);
                printWriter.println(";");
                printWriter.print("  int ");
                printWriter.print(arrayIdx);
                printWriter.println(";");
                printWriter.print("  jobjectArray ");
                printWriter.print(arrayRes);
                printWriter.println(";");
            } else if (javaType.isArray()) {
                printWriter.print("  int ");
                printWriter.print(arrayResLength);
                printWriter.println(";");
                object = javaType.getJavaClass().getComponentType();
                if (((Class)object).isArray()) {
                    throw new RuntimeException("Multi-dimensional arrays not supported yet");
                }
                string = ((Class)object).getName();
                String string2 = "j" + string + "Array";
                printWriter.print("  ");
                printWriter.print(string2);
                printWriter.print(" ");
                printWriter.print(arrayRes);
                printWriter.println(";");
            }
        }
    }

    protected void emitBodyUserVariableDeclarations(PrintWriter printWriter) {
        if (this.temporaryCVariableDeclarations != null) {
            for (String string : this.temporaryCVariableDeclarations) {
                printWriter.print("  ");
                printWriter.println(string);
            }
        }
    }

    protected boolean isUTF8Type(Type type) {
        int n = 0;
        while (!type.isInt() && !type.isVoid() && n < 2) {
            PointerType pointerType = type.asPointer();
            if (pointerType != null) {
                type = pointerType.getTargetType();
                continue;
            }
            ArrayType arrayType = type.asArray();
            if (arrayType == null) {
                throw new IllegalArgumentException("Type " + type + " should have been a pointer or array type");
            }
            type = arrayType.getElementType();
        }
        if (type.isVoid()) {
            return true;
        }
        if (!type.isInt()) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional integer pointer or array type");
        }
        if (type.getSize(this.machDesc) != 1L && type.getSize(this.machDesc) != 2L) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional pointer to char or short");
        }
        return type.getSize(this.machDesc) == 1L;
    }

    protected boolean isConstPtr(Type type) {
        if (type.pointerDepth() != 1) {
            return false;
        }
        return type.asPointer().getTargetType().isConst();
    }

    protected boolean isConstPtrPtr(Type type) {
        if (type.pointerDepth() != 2) {
            return false;
        }
        return type.asPointer().getTargetType().asPointer().getTargetType().isConst();
    }

    protected void emitBodyVariablePreCallSetup(PrintWriter printWriter) {
        if (this.binding.hasContainingType()) {
            this.emitPointerConversion(printWriter, this.binding, this.binding.getContainingType(), this.binding.getContainingCType(), JavaMethodBindingEmitter.javaThisArgumentName(), CMethodBindingEmitter.cThisArgumentName(), null);
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            String string = this.binding.getArgumentName(i);
            if (javaType.isCompoundTypeWrapper() || javaType.isNIOBuffer() && !this.forIndirectBufferAndArrayImplementation) {
                this.emitPointerConversion(printWriter, this.binding, javaType, this.binding.getCArgumentType(i), string, this.pointerConversionArgumentName(string), this.byteOffsetArgName(i));
                continue;
            }
            if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation) {
                boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
                printWriter.println("  if ( NULL != " + string + " ) {");
                Type type = this.binding.getCArgumentType(i);
                String string2 = type.getName();
                String string3 = this.pointerConversionArgumentName(string);
                if (!bl) {
                    printWriter.print("    ");
                    printWriter.print(string3);
                    printWriter.print(" = (");
                    if (javaType.isStringArray()) {
                        string2 = "jstring *";
                    }
                    printWriter.print(string2);
                    printWriter.print(") ( JNI_TRUE == " + this.isNIOArgName(i) + " ? ");
                    printWriter.print(" (*env)->GetDirectBufferAddress(env, " + string + ") : ");
                    printWriter.print(" (*env)->GetPrimitiveArrayCritical(env, " + string + ", NULL) );");
                } else {
                    if (!this.isConstPtrPtr(type) && !javaType.isArrayOfCompoundTypeWrappers()) {
                        throw new RuntimeException("Cannot copy data for ptr-to-ptr arg type \"" + type + "\": support for non-const ptr-to-ptr types not implemented.");
                    }
                    printWriter.println();
                    printWriter.println("    /* Copy contents of " + string + " into " + string3 + "_copy */");
                    String string4 = "_tmpArrayLen";
                    printWriter.print("    ");
                    printWriter.print(string4);
                    printWriter.print(" = (*env)->GetArrayLength(env, ");
                    printWriter.print(string);
                    printWriter.println(");");
                    if (type.pointerDepth() != 2) {
                        throw new RuntimeException("Could not copy data for type \"" + type + "\"; copying only supported for types of the form " + "ptr-to-ptr-to-type.");
                    }
                    PointerType pointerType = type.asPointer();
                    if (pointerType == null) {
                        throw new RuntimeException("Could not copy data for type \"" + type + "\"; currently only pointer types supported.");
                    }
                    PointerType pointerType2 = pointerType.getTargetType().asPointer();
                    this.emitMalloc(printWriter, string3 + "_copy", pointerType2.getName(), this.isConstPtrPtr(pointerType), string4, "Could not allocate buffer for copying data in argument \\\"" + string + "\\\"");
                    if (javaType.isNIOBufferArray()) {
                        printWriter.println("    _offsetHandle = (int *) (*env)->GetPrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", NULL);");
                    }
                    printWriter.println("    for (_copyIndex = 0; _copyIndex < " + string4 + "; ++_copyIndex) {");
                    printWriter.println("      /* get each element of the array argument \"" + string + "\" */");
                    printWriter.print("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                    printWriter.print(string);
                    printWriter.println(", _copyIndex);");
                    if (javaType.isStringArray()) {
                        printWriter.print("  ");
                        this.emitGetStringChars(printWriter, "(jstring) _tmpObj", string3 + "_copy[_copyIndex]", this.isUTF8Type(type), true);
                    } else if (javaType.isNIOBufferArray()) {
                        this.emitGetDirectBufferAddress(printWriter, "_tmpObj", pointerType2.getName(), string3 + "_copy[_copyIndex]", "_offsetHandle[_copyIndex]", true);
                    } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                        this.emitGetDirectBufferAddress(printWriter, "_tmpObj", pointerType2.getName(), string3 + "_copy[_copyIndex]", null, true);
                    } else {
                        printWriter.print("      ");
                        this.emitMalloc(printWriter, string3 + "_copy[_copyIndex]", pointerType2.getTargetType().getName(), this.isConstPtrPtr(pointerType), "(*env)->GetArrayLength(env, _tmpObj)", "Could not allocate buffer during copying of data in argument \\\"" + string + "\\\"");
                        throw new RuntimeException("Cannot yet handle type \"" + type.getName() + "\"; need to add support for copying ptr-to-ptr-to-primitiveType subarrays");
                    }
                    printWriter.println("    }");
                    if (javaType.isNIOBufferArray()) {
                        printWriter.println("    (*env)->ReleasePrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", _offsetHandle, JNI_ABORT);");
                    }
                    printWriter.println();
                }
                printWriter.println("  }");
                continue;
            }
            if (!javaType.isString()) continue;
            this.emitGetStringChars(printWriter, string, STRING_CHARS_PREFIX + string, this.isUTF8Type(this.binding.getCArgumentType(i)), false);
        }
    }

    protected void emitBodyVariablePostCallCleanup(PrintWriter printWriter) {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            Type type = this.binding.getCArgumentType(i);
            String string = this.binding.getArgumentName(i);
            if (javaType.isArray() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation || javaType.isArrayOfCompoundTypeWrappers()) {
                String string2;
                boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
                String string3 = this.pointerConversionArgumentName(string);
                if (!bl) {
                    printWriter.println("  if ( JNI_FALSE == " + this.isNIOArgName(i) + " && NULL != " + string + " ) {");
                    string2 = this.isConstPtr(type) || this.isConstPtrPtr(type) ? "JNI_ABORT" : "0";
                    printWriter.print("    (*env)->ReleasePrimitiveArrayCritical(env, " + string + ", " + string3 + ", " + string2 + ");");
                } else {
                    printWriter.println("  if ( NULL != " + string + " ) {");
                    if (!this.isConstPtrPtr(type)) {
                        if (javaType.isArrayOfCompoundTypeWrappers()) {
                            printWriter.println("    _tmpArrayLen = (*env)->GetArrayLength(env, " + string + ");");
                            printWriter.println("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                            printWriter.println("      _tmpObj = (*env)->GetObjectArrayElement(env, " + string + ", _copyIndex);");
                            string2 = this.pointerConversionArgumentName(string) + "_copy";
                            printWriter.println("      if ((" + string2 + "[_copyIndex] == NULL && _tmpObj == NULL) ||");
                            printWriter.println("          (" + string2 + "[_copyIndex] != NULL && _tmpObj != NULL &&");
                            printWriter.println("           (*env)->GetDirectBufferAddress(env, _tmpObj) == " + string2 + "[_copyIndex])) {");
                            printWriter.println("        /* No copy back needed */");
                            printWriter.println("      } else {");
                            printWriter.println("        if (" + string2 + "[_copyIndex] == NULL) {");
                            printWriter.println("          (*env)->SetObjectArrayElement(env, " + string + ", _copyIndex, NULL);");
                            printWriter.println("        } else {");
                            printWriter.println("          _tmpObj = (*env)->NewDirectByteBuffer(env, " + string2 + "[_copyIndex], sizeof(" + type.getName() + "));");
                            printWriter.println("          (*env)->SetObjectArrayElement(env, " + string + ", _copyIndex, _tmpObj);");
                            printWriter.println("        }");
                            printWriter.println("      }");
                            printWriter.println("    }");
                        } else {
                            throw new RuntimeException("Cannot clean up copied data for ptr-to-ptr arg type \"" + type + "\": support for cleaning up most non-const ptr-to-ptr types not implemented.");
                        }
                    }
                    printWriter.println("    /* Clean up " + string3 + "_copy */");
                    if (!javaType.isNIOBufferArray() && !javaType.isArrayOfCompoundTypeWrappers()) {
                        string2 = "_tmpArrayLen";
                        printWriter.print("    ");
                        printWriter.print(string2);
                        printWriter.print(" = (*env)->GetArrayLength(env, ");
                        printWriter.print(string);
                        printWriter.println(");");
                        PointerType pointerType = type.asPointer();
                        if (pointerType == null) {
                            throw new RuntimeException("Could not copy data for type \"" + type + "\"; currently only pointer types supported.");
                        }
                        printWriter.println("    for (_copyIndex = 0; _copyIndex < " + string2 + "; ++_copyIndex) {");
                        printWriter.println("      /* free each element of " + string3 + "_copy */");
                        printWriter.print("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                        printWriter.print(string);
                        printWriter.println(", _copyIndex);");
                        if (!javaType.isStringArray()) {
                            throw new RuntimeException("Cannot yet handle type \"" + type.getName() + "\"; need to add support for cleaning up copied ptr-to-ptr-to-primitiveType subarrays");
                        }
                        printWriter.print("     (*env)->ReleaseStringUTFChars(env, ");
                        printWriter.print("(jstring) _tmpObj");
                        printWriter.print(", ");
                        printWriter.print(string3 + "_copy[_copyIndex]");
                        printWriter.println(");");
                        printWriter.println("    }");
                    }
                    printWriter.print("    free((void*) ");
                    printWriter.print(string3 + "_copy");
                    printWriter.println(");");
                }
                printWriter.println("  }");
                continue;
            }
            if (!javaType.isString()) continue;
            printWriter.println("  if ( NULL != " + string + " ) {");
            if (this.isUTF8Type(type)) {
                printWriter.print("    (*env)->ReleaseStringUTFChars(env, ");
                printWriter.print(string);
                printWriter.print(", _strchars_");
                printWriter.print(string);
                printWriter.println(");");
            } else {
                printWriter.println("    free((void*) _strchars_" + string + ");");
            }
            printWriter.println("  }");
        }
    }

    protected int emitBodyPassCArguments(PrintWriter printWriter) {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            boolean bl;
            JavaType javaType;
            if (i != 0) {
                printWriter.print(", ");
            }
            if ((javaType = this.binding.getJavaArgumentType(i)).isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv()) {
                printWriter.print("env");
                continue;
            }
            if (this.binding.isArgumentThisPointer(i)) {
                printWriter.print(CMethodBindingEmitter.cThisArgumentName());
                continue;
            }
            printWriter.print("(");
            Type type = this.binding.getCArgumentType(i);
            boolean bl2 = this.javaArgTypeNeedsDataCopy(javaType);
            boolean bl3 = bl = !bl2 && (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation);
            if (this.isConstPtrPtr(type)) {
                printWriter.print("const ");
            }
            printWriter.print(type.getName());
            printWriter.print(") ");
            if (this.binding.getCArgumentType(i).isPointer() && javaType.isPrimitive()) {
                printWriter.print("(intptr_t) ");
            }
            if (javaType.isArray() || javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper() || javaType.isArrayOfCompoundTypeWrappers()) {
                if (bl) {
                    printWriter.print("(((char *) ");
                }
                printWriter.print(this.pointerConversionArgumentName(this.binding.getArgumentName(i)));
                if (bl2) {
                    printWriter.print("_copy");
                }
                if (!bl) continue;
                printWriter.print(") + " + this.byteOffsetArgName(i) + ")");
                continue;
            }
            if (javaType.isString()) {
                printWriter.print(STRING_CHARS_PREFIX);
            }
            printWriter.print(this.binding.getArgumentName(i));
        }
        return this.binding.getNumArguments();
    }

    protected void emitBodyCallCFunction(PrintWriter printWriter) {
        printWriter.print("  ");
        Type type = this.binding.getCReturnType();
        if (!type.isVoid()) {
            printWriter.print("_res = ");
        }
        if (this.binding.hasContainingType()) {
            printWriter.print(CMethodBindingEmitter.cThisArgumentName() + "->");
        }
        printWriter.print(this.binding.getCSymbol().getName());
        printWriter.print("(");
        this.emitBodyPassCArguments(printWriter);
        printWriter.println(");");
    }

    protected void emitBodyUserVariableAssignments(PrintWriter printWriter) {
        if (this.temporaryCVariableAssignments != null) {
            for (String string : this.temporaryCVariableAssignments) {
                printWriter.print("  ");
                printWriter.println(string);
            }
        }
    }

    protected void emitBodyReturnResult(PrintWriter printWriter) {
        Type type = this.binding.getCReturnType();
        if (!type.isVoid()) {
            JavaType javaType = this.binding.getJavaReturnType();
            if (javaType.isPrimitive()) {
                printWriter.print("  return ");
                if (type.isPointer()) {
                    printWriter.print("(" + javaType.jniTypeName() + ") (intptr_t) ");
                }
                printWriter.println("_res;");
            } else if (javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper()) {
                printWriter.println("  if (NULL == _res) return NULL;");
                printWriter.print("  return (*env)->NewDirectByteBuffer(env, _res, ");
                if (this.returnValueCapacityExpression != null) {
                    printWriter.print(this.returnValueCapacityExpression.format(this.argumentNameArray()));
                } else {
                    if (type.isPointer() && type.asPointer().getTargetType().isCompound() && type.asPointer().getTargetType().getSize() == null) {
                        throw new RuntimeException("Error emitting code for compound return type for function \"" + this.binding + "\": " + "Structs to be emitted should have been laid out by this point " + "(type " + type.asPointer().getTargetType().getName() + " / " + type.asPointer().getTargetType() + " was not)");
                    }
                    printWriter.print("sizeof(" + type.getName() + ")");
                    LOG.warning("No capacity specified for java.nio.Buffer return value for function \"" + this.binding.getName() + "\"" + " assuming size of equivalent C return type (sizeof(" + type.getName() + ")): " + this.binding);
                }
                printWriter.println(");");
            } else if (javaType.isString()) {
                printWriter.println("  if (NULL == _res) return NULL;");
                printWriter.println("  return (*env)->NewStringUTF(env, _res);");
            } else if (javaType.isArrayOfCompoundTypeWrappers() || javaType.isArray() && javaType.isNIOByteBufferArray()) {
                printWriter.println("  if (NULL == _res) return NULL;");
                if (this.returnValueLengthExpression == null) {
                    throw new RuntimeException("Error while generating C code: no length specified for array returned from function " + this.binding);
                }
                printWriter.println("  _array_res_length = " + this.returnValueLengthExpression.format(this.argumentNameArray()) + ";");
                printWriter.println("  _array_res = (*env)->NewObjectArray(env, _array_res_length, (*env)->FindClass(env, \"java/nio/ByteBuffer\"), NULL);");
                printWriter.println("  for (_array_idx = 0; _array_idx < _array_res_length; _array_idx++) {");
                Type type2 = this.binding.getCSymbol().getReturnType();
                Type type3 = type2.isPointer() ? type2.asPointer().getTargetType() : type2.asArray().getElementType();
                printWriter.println("    (*env)->SetObjectArrayElement(env, _array_res, _array_idx, (*env)->NewDirectByteBuffer(env, _res[_array_idx], sizeof(" + type3.getName() + ")));");
                printWriter.println("  }");
                printWriter.println("  return _array_res;");
            } else {
                if (javaType.isArray()) {
                    throw new RuntimeException("Could not emit native code for function \"" + this.binding + "\": array return values for non-char types not implemented yet");
                }
                System.err.print("Unhandled return type: ");
                javaType.dump();
                throw new RuntimeException("Unhandled return type");
            }
        }
    }

    protected static String cThisArgumentName() {
        return "this0";
    }

    protected String jniMangle(String string) {
        return string.replaceAll("_", "_1").replace('.', '_');
    }

    protected String jniMangle(MethodBinding methodBinding) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.jniMangle(this.getName()));
        stringBuilder.append(this.getImplSuffix());
        stringBuilder.append("__");
        if (methodBinding.hasContainingType()) {
            this.jniMangle(ByteBuffer.class, stringBuilder, true);
        }
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            Object[] objectArray;
            if (methodBinding.isArgumentThisPointer(i)) continue;
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (i == 0 && methodBinding.getNumArguments() <= 1) continue;
                throw new RuntimeException("Saw illegal \"void\" argument while emitting \"" + this.getName() + "\"");
            }
            Class<?> clazz = javaType.getJavaClass();
            if (clazz != null) {
                this.jniMangle(clazz, stringBuilder, false);
                if (javaType.isNIOBuffer()) {
                    this.jniMangle(Integer.TYPE, stringBuilder, false);
                    if (this.forIndirectBufferAndArrayImplementation) {
                        this.jniMangle(Boolean.TYPE, stringBuilder, false);
                    }
                } else if (javaType.isNIOBufferArray()) {
                    objectArray = new int[0];
                    clazz = objectArray.getClass();
                    this.jniMangle(clazz, stringBuilder, true);
                }
                if (!javaType.isPrimitiveArray()) continue;
                this.jniMangle(Integer.TYPE, stringBuilder, false);
                continue;
            }
            if (javaType.isCompoundTypeWrapper()) {
                this.jniMangle(ByteBuffer.class, stringBuilder, true);
                continue;
            }
            if (javaType.isArrayOfCompoundTypeWrappers()) {
                objectArray = new ByteBuffer[]{};
                this.jniMangle(objectArray.getClass(), stringBuilder, true);
                continue;
            }
            if (javaType.isJNIEnv()) continue;
            throw new RuntimeException("Unknown kind of JavaType: name=" + javaType.getName());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void jniMangle(Class<?> clazz, StringBuilder stringBuilder, boolean bl) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                stringBuilder.append("Z");
                return;
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append("B");
                return;
            } else if (clazz == Character.TYPE) {
                stringBuilder.append("C");
                return;
            } else if (clazz == Short.TYPE) {
                stringBuilder.append("S");
                return;
            } else if (clazz == Integer.TYPE) {
                stringBuilder.append("I");
                return;
            } else if (clazz == Long.TYPE) {
                stringBuilder.append("J");
                return;
            } else if (clazz == Float.TYPE) {
                stringBuilder.append("F");
                return;
            } else {
                if (clazz != Double.TYPE) throw new RuntimeException("Illegal primitive type \"" + clazz.getName() + "\"");
                stringBuilder.append("D");
            }
            return;
        } else if (bl) {
            if (clazz.isArray()) {
                stringBuilder.append("_3");
                Class<?> clazz2 = clazz.getComponentType();
                this.jniMangle(clazz2, stringBuilder, clazz2 == ByteBuffer.class);
                return;
            } else {
                stringBuilder.append("L");
                stringBuilder.append(clazz.getName().replace('.', '_'));
                stringBuilder.append("_2");
            }
            return;
        } else if (clazz.isArray()) {
            stringBuilder.append("_3");
            this.jniMangle(clazz.getComponentType(), stringBuilder, false);
            return;
        } else if (clazz == String.class) {
            stringBuilder.append("L");
            stringBuilder.append(clazz.getName().replace('.', '_'));
            stringBuilder.append("_2");
            return;
        } else {
            stringBuilder.append("L");
            stringBuilder.append("java_lang_Object");
            stringBuilder.append("_2");
        }
    }

    private void emitOutOfMemoryCheck(PrintWriter printWriter, String string, String string2) {
        printWriter.println("  if ( NULL == " + string + " ) {");
        printWriter.println("      (*env)->ThrowNew(env, (*env)->FindClass(env, \"java/lang/OutOfMemoryError\"),");
        printWriter.print("                       \"" + string2);
        printWriter.print(" in native dispatcher for \\\"");
        printWriter.print(this.getName());
        printWriter.println("\\\"\");");
        printWriter.print("      return");
        if (!this.binding.getJavaReturnType().isVoid()) {
            printWriter.print(" 0");
        }
        printWriter.println(";");
        printWriter.println("    }");
    }

    private void emitMalloc(PrintWriter printWriter, String string, String string2, boolean bl, String string3, String string4) {
        printWriter.print("    ");
        printWriter.print(string);
        printWriter.print(" = (");
        if (bl) {
            printWriter.print("const ");
        }
        printWriter.print(string2);
        printWriter.print(" *) malloc(");
        printWriter.print(string3);
        printWriter.print(" * sizeof(");
        printWriter.print(string2);
        printWriter.println("));");
        this.emitOutOfMemoryCheck(printWriter, string, string4);
    }

    private void emitCalloc(PrintWriter printWriter, String string, String string2, String string3, String string4) {
        printWriter.print("    ");
        printWriter.print(string);
        printWriter.print(" = (");
        printWriter.print(string2);
        printWriter.print(" *) calloc(");
        printWriter.print(string3);
        printWriter.print(", sizeof(");
        printWriter.print(string2);
        printWriter.println("));");
        this.emitOutOfMemoryCheck(printWriter, string, string4);
    }

    private void emitGetStringChars(PrintWriter printWriter, String string, String string2, boolean bl, boolean bl2) {
        printWriter.println("  if ( NULL != " + string + " ) {");
        if (bl) {
            printWriter.print("    ");
            printWriter.print(string2);
            printWriter.print(" = (*env)->GetStringUTFChars(env, ");
            printWriter.print(string);
            printWriter.println(", (jboolean*)NULL);");
            this.emitOutOfMemoryCheck(printWriter, string2, "Failed to get UTF-8 chars for argument \\\"" + string + "\\\"");
        } else {
            this.emitCalloc(printWriter, string2, "jchar", "(*env)->GetStringLength(env, " + string + ") + 1", "Could not allocate temporary buffer for copying string argument \\\"" + string + "\\\"");
            printWriter.println("    (*env)->GetStringRegion(env, " + string + ", 0, (*env)->GetStringLength(env, " + string + "), " + string2 + ");");
        }
        printWriter.print("  }");
        if (bl2) {
            printWriter.print(" else {");
            printWriter.print("      ");
            printWriter.print(string2);
            printWriter.println(" = NULL;");
            printWriter.println("  }");
        } else {
            printWriter.println();
        }
    }

    private void emitGetDirectBufferAddress(PrintWriter printWriter, String string, String string2, String string3, String string4, boolean bl) {
        printWriter.println("    if ( NULL != " + string + " ) {");
        printWriter.print("    ");
        printWriter.print("    ");
        printWriter.print(string3);
        printWriter.print(" = (");
        printWriter.print(string2);
        printWriter.print(") (((char*) (*env)->GetDirectBufferAddress(env, ");
        printWriter.print(string);
        printWriter.println(")) + " + (string4 != null ? string4 : "0") + ");");
        printWriter.print("    }");
        if (bl) {
            printWriter.println(" else {");
            printWriter.print("      ");
            printWriter.print(string3);
            printWriter.println(" = NULL;");
            printWriter.println("    }");
        } else {
            printWriter.println();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean emitPointerDeclaration(PrintWriter printWriter, JavaType javaType, Type type, String string, String string2) {
        Object object;
        Class<?> clazz;
        String string3 = null;
        boolean bl = false;
        if (javaType.isNIOBuffer()) {
            string3 = type.getName();
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            bl = this.javaArgTypeNeedsDataCopy(javaType);
            if (javaType.isPrimitiveArray() || javaType.isNIOBufferArray() || javaType.isArrayOfCompoundTypeWrappers()) {
                string3 = type.getName();
            } else if (!javaType.isStringArray()) {
                clazz = javaType.getJavaClass().getComponentType();
                if (!clazz.isArray()) throw new RuntimeException("Unsupported pointer type: \"" + type.getName() + "\"");
                object = clazz.getComponentType();
                if (!((Class)object).isPrimitive()) throw new RuntimeException("Unsupported pointer type: \"" + type.getName() + "\"");
                string3 = type.getName();
            }
        } else {
            string3 = type.getName();
        }
        printWriter.print("  ");
        if (!bl) {
            printWriter.print(string3);
            printWriter.print(" ");
            printWriter.print(string);
            printWriter.println(" = NULL;");
            return bl;
        } else {
            if (javaType.isStringArray()) {
                clazz = "char *";
                object = type.asPointer();
                if (object != null) {
                    clazz = ((PointerType)object).getTargetType().asPointer().getName();
                }
                if (this.isConstPtrPtr(type)) {
                    printWriter.print("const ");
                }
                printWriter.print((String)((Object)clazz) + " *");
            } else {
                if (this.isConstPtrPtr(type)) {
                    printWriter.print("const ");
                }
                printWriter.print(string3);
            }
            printWriter.print(" ");
            printWriter.print(string);
            printWriter.print("_copy = NULL; /* copy of data in ");
            printWriter.print(string2);
            printWriter.println(", laid out according to C memory model */");
        }
        return bl;
    }

    private void emitPointerConversion(PrintWriter printWriter, MethodBinding methodBinding, JavaType javaType, Type type, String string, String string2, String string3) {
        if (javaType.isCompoundTypeWrapper()) {
            string3 = null;
        }
        this.emitGetDirectBufferAddress(printWriter, string, type.getName(), string2, string3, false);
    }

    protected String byteOffsetArgName(int n) {
        return this.byteOffsetArgName(this.binding.getArgumentName(n));
    }

    protected String byteOffsetArgName(String string) {
        return string + "_byte_offset";
    }

    protected String isNIOArgName(int n) {
        return this.isNIOArgName(this.binding.getArgumentName(n));
    }

    protected String isNIOArgName(String string) {
        return string + "_is_nio";
    }

    protected String byteOffsetArrayArgName(int n) {
        return this.binding.getArgumentName(n) + "_byte_offset_array";
    }

    protected String[] argumentNameArray() {
        String[] stringArray = new String[this.binding.getNumArguments()];
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            stringArray[i] = this.binding.getArgumentName(i);
            if (!this.binding.getJavaArgumentType(i).isPrimitiveArray()) continue;
            stringArray[i] = stringArray[i] + ", " + this.byteOffsetArgName(i);
        }
        return stringArray;
    }

    protected String pointerConversionArgumentName(String string) {
        return "_" + string + "_ptr";
    }

    protected boolean javaArgTypeNeedsDataCopy(JavaType javaType) {
        if (javaType.isArray()) {
            return javaType.isNIOBufferArray() || javaType.isStringArray() || javaType.getJavaClass().getComponentType().isArray();
        }
        return javaType.isArrayOfCompoundTypeWrappers();
    }

    protected static class DefaultCommentEmitter
    implements CommentEmitter {
        protected DefaultCommentEmitter() {
        }

        @Override
        public void emit(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            this.emitBeginning((CMethodBindingEmitter)functionEmitter, printWriter);
            this.emitEnding((CMethodBindingEmitter)functionEmitter, printWriter);
        }

        protected void emitBeginning(CMethodBindingEmitter cMethodBindingEmitter, PrintWriter printWriter) {
            printWriter.println("  Java->C glue code:");
            printWriter.print(" *   Java package: ");
            printWriter.print(cMethodBindingEmitter.getJavaPackageName());
            printWriter.print(".");
            printWriter.println(cMethodBindingEmitter.getJavaClassName());
            printWriter.print(" *    Java method: ");
            MethodBinding methodBinding = cMethodBindingEmitter.getBinding();
            printWriter.println(methodBinding);
            printWriter.println(" *     C function: " + methodBinding.getCSymbol());
        }

        protected void emitEnding(CMethodBindingEmitter cMethodBindingEmitter, PrintWriter printWriter) {
        }
    }
}

