/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.ant;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class GlueGenTask
extends Task {
    private static final String GLUE_GEN = "com.jogamp.gluegen.GlueGen";
    private CommandlineJava gluegenCommandline;
    private boolean debug = false;
    private boolean dumpCPP = false;
    private String outputRootDir;
    private String emitter;
    private String configuration;
    private String sourceFile;
    private FileSet includeSet = new FileSet();
    private boolean usedIncludeSet = false;
    private List<AbstractFileSet> setOfIncludeSets = new LinkedList<AbstractFileSet>();
    private String literalIncludes;

    public GlueGenTask() {
        this.gluegenCommandline = new CommandlineJava();
        this.gluegenCommandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.gluegenCommandline.setClassname(GLUE_GEN);
    }

    public void setDebug(boolean bl) {
        this.log("Setting debug flag: " + bl, 3);
        this.debug = bl;
    }

    public void setDumpCPP(boolean bl) {
        this.log("Setting dumpCPP flag: " + bl, 3);
        this.dumpCPP = bl;
    }

    public void setOutputRootDir(String string) {
        this.log("Setting output root dir: " + string, 3);
        this.outputRootDir = string;
    }

    public void setEmitter(String string) {
        this.log("Setting emitter class name to: " + string, 3);
        this.emitter = string;
    }

    public void setConfig(String string) {
        this.log("Setting configuration file name to: " + string, 3);
        this.configuration = string;
    }

    public void setSrc(String string) {
        this.log("Setting source file name to: " + string, 3);
        this.sourceFile = string;
    }

    public void setLiteralInclude(String string) {
        this.literalIncludes = string.trim();
    }

    public PatternSet.NameEntry createInclude() {
        this.usedIncludeSet = true;
        return this.includeSet.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        this.usedIncludeSet = true;
        return this.includeSet.createIncludesFile();
    }

    public void setIncludes(String string) {
        this.usedIncludeSet = true;
        this.includeSet.setIncludes(string);
    }

    public PatternSet.NameEntry createExclude() {
        this.usedIncludeSet = true;
        return this.includeSet.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        this.usedIncludeSet = true;
        return this.includeSet.createExcludesFile();
    }

    public void setExcludes(String string) {
        this.usedIncludeSet = true;
        this.includeSet.setExcludes(string);
    }

    public void setIncludeRefid(Reference reference) {
        Object object = reference.getReferencedObject(this.getProject());
        if (object instanceof FileSet) {
            this.setOfIncludeSets.add((AbstractFileSet)((FileSet)object));
            return;
        }
        if (object instanceof DirSet) {
            this.setOfIncludeSets.add((AbstractFileSet)((DirSet)object));
            return;
        }
        throw new BuildException("Only FileSets or DirSets are allowed as an include refid.");
    }

    public void addDirset(DirSet dirSet) {
        this.setOfIncludeSets.add((AbstractFileSet)dirSet);
    }

    public Path createClasspath() {
        return this.gluegenCommandline.createClasspath(this.project).createPath();
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.addAttributes();
        this.log(this.gluegenCommandline.describeCommand(), 3);
        int n = this.execute(this.gluegenCommandline.getCommandline());
        if (n == 1) {
            throw new BuildException("GlueGen returned: " + n, this.location);
        }
    }

    private void validateAttributes() throws BuildException {
        if (!this.isValid(this.emitter)) {
            throw new BuildException("Invalid emitter class name: " + this.emitter);
        }
        if (!this.isValid(this.configuration)) {
            throw new BuildException("Invalid configuration file name: " + this.configuration);
        }
        if (!this.isValid(this.sourceFile)) {
            throw new BuildException("Invalid source file name: " + this.sourceFile);
        }
    }

    private boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        return string.trim().length() >= 1;
    }

    /*
     * WARNING - void declaration
     */
    private void addAttributes() throws BuildException {
        Object object;
        if (this.debug) {
            this.gluegenCommandline.createArgument().setValue("--debug");
        }
        if (this.dumpCPP) {
            this.gluegenCommandline.createArgument().setValue("--dumpCPP");
        }
        if (null != this.outputRootDir && this.outputRootDir.trim().length() > 0) {
            this.gluegenCommandline.createArgument().setValue("-O" + this.outputRootDir);
        }
        this.gluegenCommandline.createArgument().setValue("-E" + this.emitter);
        this.gluegenCommandline.createArgument().setValue("-C" + this.configuration);
        if (this.usedIncludeSet) {
            this.includeSet.setDir(this.getProject().getBaseDir());
            this.setOfIncludeSets.add((AbstractFileSet)this.includeSet);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (AbstractFileSet abstractFileSet : this.setOfIncludeSets) {
            object = abstractFileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = object.getIncludedDirectories();
            for (int i = 0; i < stringArray.length; ++i) {
                linkedList.add(stringArray[i]);
            }
        }
        if (this.isValid(this.literalIncludes)) {
            void string;
            String[] stringArray = this.literalIncludes.split(",");
            boolean i = false;
            while (string < stringArray.length) {
                object = stringArray[string].trim();
                if (((String)object).length() > 0) {
                    linkedList.add(object);
                }
                ++string;
            }
        }
        for (String string : linkedList) {
            this.gluegenCommandline.createArgument().setValue("-I" + string);
        }
        this.gluegenCommandline.createArgument().setValue(this.sourceFile);
    }

    private int execute(String[] stringArray) throws BuildException {
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null);
        execute.setAntRun(this.project);
        execute.setCommandline(stringArray);
        execute.setWorkingDirectory(this.project.getBaseDir());
        try {
            return execute.execute();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.location);
        }
    }
}

