/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.structgen;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.structgen.CStruct;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jogamp.common.Debug;

@SupportedAnnotationTypes(value={"com.jogamp.gluegen.structgen.CStruct"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CStructAnnotationProcessor
extends AbstractProcessor {
    private static final String DEFAULT = "_default_";
    private static final boolean DEBUG;
    private static final String STRUCTGENOUTPUT_OPTION = "structgen.output";
    private static final String STRUCTGENOUTPUT;
    private Filer filer;
    private Messager messager;
    private Elements eltUtils;
    private String outputPath;
    private static final Set<String> generatedStructs;

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.messager = processingEnvironment.getMessager();
        this.eltUtils = processingEnvironment.getElementUtils();
        this.outputPath = processingEnvironment.getOptions().get(STRUCTGENOUTPUT_OPTION);
        this.outputPath = this.outputPath == null ? STRUCTGENOUTPUT : this.outputPath;
    }

    private File locateSource(String string, String string2) {
        block5: {
            try {
                File file;
                if (DEBUG) {
                    System.err.println("CStruct.locateSource.0: p " + string + ", r " + string2);
                }
                FileObject fileObject = this.filer.getResource(StandardLocation.SOURCE_PATH, string, string2);
                if (DEBUG) {
                    System.err.println("CStruct.locateSource.1: h " + fileObject.toUri());
                }
                if ((file = new File(fileObject.toUri().getPath())).exists()) {
                    return file;
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block5;
                System.err.println("Catched " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        String string = System.getProperty("user.dir");
        Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(CStruct.class);
        for (Element element : set2) {
            String string2 = this.eltUtils.getPackageOf(element).toString();
            try {
                Object object;
                CStruct cStruct = element.getAnnotation(CStruct.class);
                String string3 = cStruct.header();
                Element element2 = element.getEnclosingElement();
                System.err.println("CStruct: " + cStruct + ", package " + string2 + ", header " + string3);
                if (DEBUG) {
                    System.err.println("CStruct.0: user.dir: " + string);
                    System.err.println("CStruct.0: element: " + element + ", .simpleName " + element.getSimpleName());
                    System.err.println("CStruct.0: enclElement: " + element2 + ", .simpleName " + element2.getSimpleName() + ", .package " + this.eltUtils.getPackageOf(element2).toString());
                }
                if (null == (object = this.locateSource(string2, string3)) && null == (object = this.locateSource("", string3))) {
                    throw new RuntimeException("Could not locate header " + string3 + ", package " + string2);
                }
                File file = object;
                String string4 = file.getAbsolutePath();
                string4 = string4.substring(0, string4.length() - file.getName().length() - 1);
                object = string4.substring(0, string4.length() - string2.length()) + "..";
                System.err.println("CStruct: " + file + ", abs: " + file.isAbsolute() + ", root " + (String)object);
                this.generateStructBinding(element, cStruct, (String)object, string2, file);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException while processing!", iOException);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStructBinding(Element element, CStruct cStruct, String string, String string2, File file) throws IOException {
        String string3;
        String string4 = element.asType().toString();
        String string5 = string3 = cStruct.name().equals(DEFAULT) ? string4 : cStruct.name();
        if (generatedStructs.contains(string3)) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "struct " + string3 + " already defined elsewhere.", element);
            return;
        }
        System.out.println("generating struct accessor for struct: " + string3);
        generatedStructs.add(string3);
        Object object = new File(this.outputPath);
        boolean bl = ((File)object).isAbsolute();
        object = bl ? this.outputPath : string + File.separator + this.outputPath;
        String string6 = (String)object + File.separator + file.getName() + ".cfg";
        File file2 = new File(string6);
        if (DEBUG) {
            System.err.println("CStruct: OutputDir: " + this.outputPath + ", is-abs " + bl);
            System.err.println("CStruct: OutputPath: " + (String)object);
            System.err.println("CStruct: ConfigFile: " + file2);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file2);
            fileWriter.write("Package " + string2 + "\n");
            fileWriter.write("EmitStruct " + string3 + "\n");
            if (!cStruct.name().equals(DEFAULT)) {
                fileWriter.write("RenameJavaType " + cStruct.name() + " " + string4 + "\n");
            }
        }
        finally {
            if (null != fileWriter) {
                fileWriter.close();
            }
        }
        GlueGen.main("-O" + (String)object, "-E" + AnnotationProcessorJavaStructEmitter.class.getName(), "-C" + string6, file.getPath());
        file2.delete();
    }

    static {
        Debug.initSingleton();
        DEBUG = Debug.isPropertyDefined("jogamp.gluegen.structgen.debug", true);
        STRUCTGENOUTPUT = PropertyAccess.getProperty("jogamp.gluegen.structgen.output", true, "gensrc");
        generatedStructs = new HashSet<String>();
    }

    public static class AnnotationProcessorJavaStructEmitter
    extends JavaEmitter {
        @Override
        protected PrintWriter openFile(String string, String string2) throws IOException {
            if (!string2.endsWith("32") && !string2.endsWith("64")) {
                System.out.println("generating -> " + string2);
                generatedStructs.add(string2);
            }
            return super.openFile(string, string2);
        }
    }
}

