varying vec3 v_color;

uniform float u_br;
uniform vec3 u_invert;
uniform float u_hue, u_saturation;


vec3 RGBtoHSL(vec3 color)
{
	vec3 hsl = vec3(0.0, 0.0, 0.0);

	float fmin = min(min(color.r, color.g), color.b);
	float fmax = max(max(color.r, color.g), color.b);
	float delta = fmax - fmin;

	hsl.z = (fmax + fmin) / 2.0; // Luminance

	if (delta == 0.0)		//This is a gray, no chroma...
	{
		hsl.x = 0.0;	// Hue
		hsl.y = 0.0;	// Saturation
	}
	else   //Chromatic data...
	{
		if (hsl.z < 0.5)
			hsl.y = delta / (fmax + fmin); // Saturation
		else
			hsl.y = delta / (2.0 - fmax - fmin); // Saturation

		float deltaR = (((fmax - color.r) / 6.0) + (delta / 2.0)) / delta;
		float deltaG = (((fmax - color.g) / 6.0) + (delta / 2.0)) / delta;
		float deltaB = (((fmax - color.b) / 6.0) + (delta / 2.0)) / delta;

		if (color.r == fmax )
			hsl.x = deltaB - deltaG; // Hue
		else if (color.g == fmax)
			hsl.x = (1.0 / 3.0) + deltaR - deltaB; // Hue
		else if (color.b == fmax)
			hsl.x = (2.0 / 3.0) + deltaG - deltaR; // Hue

		if (hsl.x < 0.0)
			hsl.x += 1.0; // Hue
		else if (hsl.x > 1.0)
			hsl.x -= 1.0; // Hue
	}

	return hsl;
}

float HUEtoRGB(float f1, float f2, float hue)
{
	if (hue < 0.0)
		hue += 1.0;
	else if (hue > 1.0)
		hue -= 1.0;
	float res;
	if ((6.0 * hue) < 1.0)
		res = f1 + (f2 - f1) * 6.0 * hue;
	else if ((2.0 * hue) < 1.0)
		res = f2;
	else if ((3.0 * hue) < 2.0)
		res = f1 + (f2 - f1) * ((2.0 / 3.0) - hue) * 6.0;
	else
		res = f1;
	return res;
}

vec3 HSLtoRGB(vec3 hsl)
{
	vec3 rgb;

	if (hsl.y == 0.0)
		rgb = vec3(hsl.z); // Luminance
	else
	{
		float f2;

		if (hsl.z < 0.5)
			f2 = hsl.z * (1.0 + hsl.y);
		else
			f2 = (hsl.z + hsl.y) - (hsl.y * hsl.z);

		float f1 = 2.0 * hsl.z - f2;

		rgb.r = HUEtoRGB(f1, f2, hsl.x + (1.0/3.0));
		rgb.g = HUEtoRGB(f1, f2, hsl.x);
		rgb.b = HUEtoRGB(f1, f2, hsl.x - (1.0/3.0));
	}

	return rgb;
}

float inv(float a)
{
	return 1.0-(cos(a*7.0)*0.5+0.5);
}

void main(void)
{
	vec3 col = mix(gl_Color.rgb, vec3(inv(gl_Color.r), inv(gl_Color.g), inv(gl_Color.b)), u_invert);
	vec3 hsl = RGBtoHSL(col.rgb);

	hsl.r += u_hue;
	if (hsl.r >= 1.0) hsl.r -= 1.0;
	if (hsl.r < 0.0) hsl.r += 1.0;

	hsl.g *= u_saturation;
//	hsl.b *= u_br;

	col.rgb = HSLtoRGB(hsl);
	
	v_color = col * u_br;
	
	gl_Position = ftransform();
}
