
var Tree = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Tree.prototype = PartBase.prototype.inheritance();


Tree.prototype.clip = function(num) {
  if (num > 255) return 255;
  if (num < 0)   return 0;
  return num;
}

Tree.prototype.uusipuu = function() {
  this.runko = new this.oksa();
  this.puugroup = new THREE.Object3D();
  this.puutasot = [[this.runko]];
  this.scene.add(this.puugroup);
  this.oksalaskuri=0;
  this.oksainit(this.runko);
  this.runko.alku.setX(0);
  this.runko.alku.setY(-400);
  this.runko.alku.setZ(0);
  this.runko.loppu.setY(-300);
  this.runko.loppu.setX(0);
  this.runko.loppu.setZ(0);
  this.runko.red   = 128;
  this.runko.green = 20;
  this.runko.blue  = 20;
}

Tree.prototype.vuosikasvu = function() {
  alin = this.puutasot.length-1;
  //console.log("kasvu");
  this.puutasot[alin+1] = [];
  for (i=0;i<this.puutasot[alin].length;i++) {

    var parent = this.puutasot[alin][i];

    suunta = Math.random() * 2 * 3.14159265;

    parent.childA = new this.oksa();
    parent.childB = new this.oksa();

    var A = parent.childA;
    var B = parent.childB;

    this.oksainit(A);
    this.oksainit(B);

    this.puutasot[alin+1].push(A);
    this.puutasot[alin+1].push(B);

    this.kaikkioksat.push(A);
    this.kaikkioksat.push(B);

    A.alku.copy(parent.loppu);
    B.alku.copy(parent.loppu);

    A.loppu.setY(parent.loppu.y + A.len - this.oksalaskuri/2);
    B.loppu.setY(parent.loppu.y + B.len - this.oksalaskuri/2);

    A.loppu.setX(A.alku.x+Math.sin(suunta)*A.len-40);
    B.loppu.setX(B.alku.x+Math.sin(suunta)*B.len+40);

    A.loppu.setZ(A.alku.z+Math.cos(suunta)*A.len-40);
    B.loppu.setZ(B.alku.z+Math.cos(suunta)*B.len+40);

    A.red   = this.clip(Math.round(parent.red   + Math.random()*this.colorvar-this.colorvar/2));
    B.red   = this.clip(Math.round(parent.red   + Math.random()*this.colorvar-this.colorvar/2));
    A.green = this.clip(Math.round(parent.green + Math.random()*this.colorvar-this.colorvar/2));
    B.green = this.clip(Math.round(parent.green + Math.random()*this.colorvar-this.colorvar/2));
    A.blue  = this.clip(Math.round(parent.blue  + Math.random()*this.colorvar-this.colorvar/2));
    B.blue  = this.clip(Math.round(parent.blue  + Math.random()*this.colorvar-this.colorvar/2));

  }
}

Tree.prototype.oksa = function() {

}

Tree.prototype.oksainit = function(oxa) {
  //console.log("oksa");
  oxa.alku = new THREE.Vector3();
  oxa.loppu = new THREE.Vector3();
  oxa.len = 100;
  oxa.monesko = this.oksalaskuri;

  this.oksalaskuri ++;
}

Tree.prototype.piirraoksa = function(oxa) {
  //console.log("piirra");
  //console.log(oxa);
  var material = new THREE.LineBasicMaterial( { opacity: 0.9, color: (oxa.red << 16) + (oxa.green << 8) + (oxa.blue),
  transparent: true, linewidth: 8+10/(0.2*oxa.monesko) } );

  oxa.linegeo = new THREE.Geometry();
  oxa.linegeo.vertices.push(oxa.alku);
  oxa.linegeo.vertices.push(oxa.loppu);
  oxa.line = new THREE.Line( oxa.linegeo, material );
  oxa.line.updateMatrix();
  this.puugroup.add(oxa.line);
}

Tree.prototype.initScene = function () {

  this.colorvar=32;
  this.tamaOksa=0;
  this.kaikkioksat = [];
  
  this.scene = new THREE.Scene();
  
  var ambient = new THREE.AmbientLight(0x559955);
  this.scene.add(ambient);
  
  var pointLight = new THREE.PointLight(0x995599/*0xC65D57 0xAACCDD*/);
  pointLight.position.y = 500;
  pointLight.position.z = 500;
  pointLight.position.x = -100;
  this.scene.add(pointLight);
  
  this.scene.fog = new THREE.FogExp2( 0xDBE6E0 /*0x559955 0xFCE6C9 0x8888dd*/, 0.001, 600 );

  this.camera = new THREE.PerspectiveCamera( 80, TDEMO.width / TDEMO.height, 1, 3000 );
  this.camera.position.z = 1000;
  this.camera.position.y = 0;
  this.camera.position.x = 0;
  
  var roofMaterial = new THREE.MeshPhongMaterial({
    color : 0x8B7355,//0x5959AB,//0x5D478B,
    ambient : 0x3B7325,//0x304132,
    emissive : 0x8B7355,//0x302B54,//0x1C1C1C,
    specular : 0x8B7355,//0x302B54,//0x483D8B,
    side : THREE.BackSide
  });
  
  this.roof = new THREE.Mesh(new THREE.SphereGeometry(1024, 16, 16), roofMaterial);
  this.scene.add(this.roof);


  this.uusipuu();

  while (this.oksalaskuri < 256)
    this.vuosikasvu();

  this.piirraoksa(this.runko);
}

Snowflake.prototype.prepare = function(elapsedTime){
  this.seuraavapiirto = elapsedTime;
}

Tree.prototype.animate = function(elapsedTime) {

  this.camera.position.z -= .7;
  //console.log(elapsedTime);
  
  //console.log(this.tamaOksa);
  //console.log(this.oksalaskuri);
  if (this.tamaOksa < this.oksalaskuri-1) {
    this.piirraoksa(this.kaikkioksat[this.tamaOksa]);
    this.tamaOksa ++;
    this.seuraavapiirto += 1/20;
  }

}

Tree.prototype.render = function(elapsedTime) {
  TDEMO.renderer.render( this.scene, this.camera );
}