
float4x4 g_mWorldViewProjection;    


float g_windowWidth;
float g_windowHeight;

float g_blur_strength;
float g_current_pixel_weight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_godray( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDiffDef;
sampler smDiffDef =
sampler_state {
  Texture = <g_tDiffDef>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};




float g_focus;
float g_sharpDepth;
float g_frontAmp;
float g_backAmp;

float g_haloCorrectAmp;


const float zFar = 10000.0;
const float zNear = 1.0;


float getPointDist(float z) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return clipB/(z-clipA);  
}

float getPointZ(float d) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return (clipB + d*clipA)/d;
}

float g_rayPos_x;
float g_rayPos_y;
float g_rayPos_z;

float g_mixmul;

float g_amountFromGlowBuf=0.0f; // 0.0 -> take all pixels, 1.0 -> take amount described by the glow buffer

// d = cb/(z-ca); -> d*(z-ca) = cb; -> d*z -d*ca = cb -> z = (cb + d*ca)/d

PS_OUT ps_godray( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  float4 od = tex2D(smDepth, In.vTexcoord);
  float4 result = 0;
  result = colorIn;
  
  float mid = 0.50;
  float skalefak = (g_windowWidth-g_blur_strength)/g_windowWidth;
//  float2 cent = 1.0/skalefak*float2(+g_rayPos_x, -g_rayPos_y);
  float2 po = In.vTexcoord-float2(0.5, 0.5);
  po *= skalefak;
  po += float2(0.5, 0.5);
  po += (1.0-skalefak)*0.5*float2(g_rayPos_x, g_rayPos_y);
  //    float4 ood = tex2D(smDepth, po);
      //float rx = (g_rayPos_x*7.0);
	  //float ry = -(g_rayPos_y*7.0);
      //po += float2(rx/g_windowWidth*1.0, ry/g_windowHeight*1.0);
      result = colorIn;
  //    if (ood.x > od.x-0.001) {
        result += tex2D(smDiffuse, po);
        result = result/2.0;
 //     } 
 /*
 float2 tc2 = In.vTexcoord*2.0-1.0;
// float2 pers = (tc2.x-g_rayPos_x, tc2.y-g_rayPos_y); 
 float2 pers = float2(tc2.x-g_rayPos_x, tc2.y-g_rayPos_y); 
 result.xy = saturate(1.0-sqrt(dot(pers,pers))*16);
 result.zw = 1.0;//saturate((1.0-dot(pers,pers)*16.0));
// result.a = 1.0;
 */
  o.rt0 = result;
  return o;
}

float g_distMul;

PS_OUT ps_godray_back( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  float4 od = tex2D(smDepth, In.vTexcoord);
  float4 result = 0;
  float4 diffDef = tex2D(smDiffDef, In.vTexcoord);
  
  float gdAm = (diffDef.a-frac(diffDef.a))/100.0f;
  float godRayAmount = 1.0*saturate(1.0-g_amountFromGlowBuf)+gdAm*g_amountFromGlowBuf;

//  float4 ood = tex2D(smDepth, In.vTexcoord);
  //if (od.r > g_rayPos_z) {
    float2 po = (In.vTexcoord-float2(0.5, 0.5))*2.0;
    float2 distO = po-float2(g_rayPos_x, g_rayPos_y);
    float koko = saturate(1.0-distO*g_distMul);
   // colorIn *= koko;
    result = colorIn*godRayAmount;
  //}
    
  o.rt0 = result;
  return o;
}


PS_OUT ps_godray_mix( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord)*g_mixmul;
  o.rt0 = colorIn;
  return o;
}

technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_godray( );
        PixelShader  = compile ps_3_0 ps_godray( );
    }
}

technique RenderBack {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_godray( );
        PixelShader  = compile ps_3_0 ps_godray_back( );
    }
}


technique RenderMix {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_godray( );
        PixelShader  = compile ps_3_0 ps_godray_mix( );
    }
}

