float g_time;
 
float4x4 g_mWorld;                  // World matrix for object
float4x4 g_mView;
float4x4 g_mInvView;
float4x4 g_mProj;
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix

float4 g_texCoordScale;
float4 g_texCoordOfs;

float4 g_materialDiffuse;

float g_materialAmbient;

float g_diffuseIntensity;
float g_heightIntensity;
float g_specularIntensity;
float g_specularExponent;

float4 g_diffuseTexCoordScale;
float4 g_diffuseTexCoordOfs;

float4 g_heightTexCoordScale;
float4 g_heightTexCoordOfs;

float4 g_specularTexCoordScale;
float4 g_specularTexCoordOfs;

float g_windowWidth;
float g_windowHeight;

float g_refl = 0.0;
float g_uv = 0.0;
float g_glassiness = 0.0;
float g_emitPart = 0.0;

texture tex0;
texture tex1;
texture tex2;

sampler smDiffuse =
sampler_state {
  Texture = <tex0>;
  MipFilter = NONE; // ANISOTROPIC
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};


sampler smHeight =
sampler_state {
  Texture = <tex1>;
  MipFilter = NONE;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smSpecular =
sampler_state {
  Texture = <tex2>;
  MipFilter = NONE;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};


texture g_tSpectrum;
sampler smSpectrum =
sampler_state {
  Texture = <g_tSpectrum>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR; 
  AddressU = WRAP;
  AddressV = WRAP;
};



struct VS_INPUT {
    float4 vPosition : POSITION;
    float3 vNormal : NORMAL;
    float2 vTexcoord : TEXCOORD0;
    float4 vWHI : TEXCOORD1;
    float3 vTangent : TANGENT;
    float3 vBiNormal : BINORMAL;
	float  Depth  : DEPTH;
};


struct VS_OUTPUT_BASIC {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
};


struct VS_OUTPUT_BASIC_KO {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
    float4  vPosSO : TEXCOORD6;
};

struct MRT_OUT {
  float4 rt0 : COLOR0; // depth
  float4 rt1 : COLOR1; // normal
  float4 rt2 : COLOR2; // diffuse
  float4 rt3 : COLOR3; // ambspec
};


VS_OUTPUT_BASIC vs_deferred_draw( const VS_INPUT v ) {
  VS_OUTPUT_BASIC o;

  float4 vPosTrans = v.vPosition;

  
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vTangent = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vBiNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}


VS_OUTPUT_BASIC_KO vs_deferred_draw_march( const VS_INPUT v ) {
  VS_OUTPUT_BASIC_KO o;
  
  float4 vPosTrans = v.vPosition*1.0;
  //vPosTrans.w = 1.0;
  
 // vPosTrans = rotateXZ(vPosTrans, 5.0*clamp(sin(vPosTrans.y*0.150+g_time*0.4),0.0,1.0));
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float4 possex = mul(vPosTrans, g_mWorld);
  o.vPosSO = mul(possex, g_mView);
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
 // o.vNormal = float4(normalize(normalResult)*1.0, 0.0);

  float3 tan = v.vTangent;
  float3 bin = v.vBiNormal;
  float2 tc = v.vTexcoord;
  /*
 // float3 nra = abs(v.vNormal);
  float3 nra = abs(normalResult);
   
  if (nra.x > nra.y && nra.x > nra.z) {
   // maxX = 1;
    tan = float3(0.0, 1.0, 0.0);
   // tc = v.vPosition.yz*0.1;
  //  tc = possex.yz*0.1;
  } else if (nra.y > nra.x && nra.y > nra.z) {
   // maxY = 1;
    tan = float3(1.0, 0.0, 0.0);
    // tc = v.vPosition.xz*0.1;
 //   tc = possex.xz*0.1;
  } else {
    // maxZ = 1;
    tan = float3(1.0, 0.0, 0.0);
    // tc = v.vPosition.xy*0.1;
 //   tc = possex.xy*0.1;
  }
  float dp = dot(tan, nra);
  tan = tan-nra*dp;
  bin = cross(tan, normalResult);
  */
  
  normalResult = mul(tan, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
 //o.vTangent = float4(normalize(normalResult)*1.0, 0.0);
  normalResult = mul(bin, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
 //o.vBiNormal = float4(normalize(normalResult)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
      
  o.vTexcoord = tc*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = tc*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = tc*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}

#include "mrt_deferred_instance.h"
VS_OUTPUT_BASIC vs_deferred_draw_instanced( const VS_INPUT v ) {
  VS_OUTPUT_BASIC o;

  float4 vPosTrans = v.vPosition*(float4(1.0, 1.0, 1.0, 0.0)*1.0+float4(0.0, 0.0, 0.0, 1.0));
   
  float4 mSS = mul(vPosTrans, g_mWorldViewProjection);
  float2 tcs = g_texCoordScale;
  float4 pulkka = (tex2Dlod(DisplaceSampler, float4(v.vWHI.x+0.5/g_windowWidth, v.vWHI.y+0.5/g_windowHeight, 0, 0)));
  pulkka.w = 0.0;

  pulkka.x /= g_meshSize.x;
  pulkka.y /= g_meshSize.y;
  pulkka.z /= g_meshSize.z;
  vPosTrans += pulkka;
  
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
    
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  float3 tan = v.vTangent;
  float3 bin = v.vBiNormal;
  float2 tc = v.vTexcoord;
  
  normalResult = mul(tan, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  normalResult = mul(bin, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
        
  o.vTexcoord = tc*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = tc*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = tc*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;  
    
  return o;
}

const float zFar = 10000.0;
const float zNear = 0.10;

/*
float getPointDist(float z) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return clipB/(z-clipA);  
}

float getPointZ(float d) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return (clipB + d*clipA)/d;
}
*/

float getPointDist(float z) {
 // float clipA = zFar / (zFar - zNear); // 1.000010000100001000010000100001
 // float clipB = zFar*zNear / (zNear - zFar); // -0.1000010000100001000010000100001
 // return clipB/(z-clipA);  
 
 // (-zFar*zNear) = -1000.0
 // (zFar-zNear) = 9999.9
 // float s = 16777216.0;
 // return (-s*zFar*zNear)/(z*(zFar-zNear)-zFar*s);
 
 float clipA = (zFar+zNear)/(2.0*(zFar-zNear))+0.5;
 float clipB = (-zFar*zNear)/(zFar-zNear);
 // z = clipA+clipB*(1/d);
 // clipB*(1/d) = z-clipA;
 // d = (z-clipA)/clipB;
 //return z;
 return clipB/(z-clipA);
 
}

float getPointZ(float d) {
//  float clipA = zFar / (zFar - zNear);
//  float clipB = zFar*zNear / (zNear - zFar);
//  return (clipB + d*clipA)/d;
 float clipA = (zFar+zNear)/(2.0*(zFar-zNear))+0.5;
 float clipB = (-zFar*zNear)/(zFar-zNear);
 return clipA+clipB/d;
}

#include "mrt_deferred_bump.h"
#include "mrt_deferred_background.h"
#include "mrt_deferred_depth.h"
#include "mrt_deferred_march.h"
// #include "mrt_deferred_march_diffuse.h"
