
float4x4 g_mWorldViewProjection;
float4x4 g_mView;
float4x4 g_mViewBill;
float4x4 g_mProj;
float4x4 g_mWorld;

float g_windowWidth;
float g_windowHeight;

float2 g_texCoordScale;
float2 g_texCoordOfs;

float4 g_color;
float g_diffuse;
float g_specular;
float g_ambience;

float g_time;

float g_size;
float4 g_aspect;

float g_defHeight;
float g_defBumpness;
float g_depthClipMul;



struct VS_INPUT_PIX_PARTICLE {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
    float  Depth  : DEPTH;
};


texture g_texPartPos;
sampler smPartPos = sampler_state {
  Texture = <g_texPartPos>;
  MinFilter = POINT;
  MagFilter = POINT;
  MipFilter = NONE;
  AddressU = CLAMP;
  AddressV = CLAMP;
};


texture g_texPartVel;
sampler smPartVel = sampler_state {
  Texture = <g_texPartVel>;
  MinFilter = POINT;
  MagFilter = POINT;
  MipFilter = NONE;
  AddressU = CLAMP;
  AddressV = CLAMP;
};

texture g_texPartCol;
sampler smPartCol = sampler_state {
  Texture = <g_texPartCol>;
  MinFilter = POINT;
  MagFilter = POINT;
  MipFilter = NONE;
  AddressU = CLAMP; 
  AddressV = CLAMP;
};



float g_particleIndexOffset;

float4 rotateXZ(float4 p, float a) {
  float4 r = p;
  
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  
  return r;
}

float4 rotateXY(float4 p, float a) {
  float4 r = p;
  
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  
  return r;
}


struct VS_OUTPUT_PIX_PARTICLE {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float4  vTangent : TEXCOORD2;
    float4  vBiTangent : TEXCOORD3;
    float  Depth  : TEXCOORD4;
    float4  vColor : TEXCOORD5;
};


struct VS_OUTPUT_PIX_PARTICLE_SIMPLE {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vColor : TEXCOORD1;
	float  Depth  : TEXCOORD2;
};


VS_OUTPUT_PIX_PARTICLE vs_float_to_onezero( const VS_INPUT_PIX_PARTICLE v ) {
  VS_OUTPUT_PIX_PARTICLE o = (VS_OUTPUT_PIX_PARTICLE)o;
  
  float4 vp = v.vPosition;
  float4 vpT;
  
  vpT.y = ((float)((int)((vp.z+g_particleIndexOffset)/g_windowWidth)));
  vpT.x = ((vp.z+g_particleIndexOffset)-vpT.y*g_windowWidth);
  
  vpT.x *= 1.0/g_windowWidth;
  vpT.y *= 1.0/g_windowHeight;
  vpT.z = 0.0;
  vpT.w = 0.0;
  
  vpT.x += 0.5/g_windowWidth;
  vpT.y += 0.5/g_windowHeight;
  
  vp = tex2Dlod(smPartPos, vpT);
 // float4 vpVel = tex2Dlod(smPartVel, vpT);

  float ageLeft = clamp(vp.w, 0.0, 100000.0);
  
  vp.w = 1.0;   
  vp = mul(vp, g_mView);
  
  float ageSize = smoothstep(0.0, 1.0, ageLeft);
  
  float4 bill = float4(v.vPosition.x*g_size*g_aspect.x*ageSize, v.vPosition.y*g_size*g_aspect.y*ageSize, 0.0, 1.0);
  
 // float angle = vpVel.w;
 // bill = rotateXY(bill, angle);
 
 // bill = mul(bill, g_mViewBill);

  vp.x += bill.x;
  vp.y += bill.y;
  
  vp.w = 1.0;
  
  o.vPosition = mul(vp, g_mProj);
  o.vPosSS = o.vPosition;
  
  float2 tc = float2(v.vPosition.x+1.0, -v.vPosition.y+1.0)*0.5;
    
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = ((tc)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight))*g_texCoordScale+g_texCoordOfs; 
  
  float2 res = float2(512.0, 512.0);
  
  float3 normalResult;
  o.vTangent = float4(1.0, 0.0, 0.0, 1.0);
 // o.vTangent = rotateXY(o.vTangent, angle);
  o.vTangent *= 1.0/res.x;
  
  o.vBiTangent = float4(0.0, 1.0, 0.0, 1.0);
 // o.vBiTangent = rotateXY(o.vBiTangent, angle);
  o.vBiTangent *= 1.0/res.y;

  o.vColor = float4(1.0, 1.0, 1.0, ageLeft);
  //o.vColor = float4((0.5+sin(g_particleIndexOffset*32.0))*1.0, 1.0, (0.5+cos(g_particleIndexOffset*22.30))*1.0, ageLeft); 
  
  
  o.Depth = v.Depth;
  
  return o;
}

struct VS_OUTPUT_PIX_PARTICLE_SS {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float4  vPixCoordSS : TEXCOORD2;
    float  Depth  : TEXCOORD3;
};

VS_OUTPUT_PIX_PARTICLE_SS vs_float_to_onezero_ss( const VS_INPUT_PIX_PARTICLE v ) {
  VS_OUTPUT_PIX_PARTICLE_SS o = (VS_OUTPUT_PIX_PARTICLE_SS)o;
  
  float4 vp = v.vPosition;
  float4 vpT;
  
  vpT.y = ((float)((int)((vp.z+g_particleIndexOffset)/g_windowWidth)));
  vpT.x = ((vp.z+g_particleIndexOffset)-vpT.y*g_windowWidth);
  
  vpT.x *= 1.0/g_windowWidth;
  vpT.y *= 1.0/g_windowHeight;
  vpT.z = 0.0;
  vpT.w = 0.0;
  
  vpT.x += 0.5/g_windowWidth;
  vpT.y += 0.5/g_windowHeight;
  
  vp = tex2Dlod(smPartPos, vpT);
 // float4 vpVel = tex2Dlod(smPartVel, vpT);

  float ageLeft = clamp(vp.w, 0.0, 100000.0);
  
  vp.w = 1.0;   
  vp = mul(vp, g_mView);
  
  float4 norm = tex2Dlod(smPartVel, vpT);
  
  float ageSize = smoothstep(0.0, 1.0, ageLeft)*norm.w;
  
  float4 bill = float4(v.vPosition.x*g_size*g_aspect.x*ageSize, v.vPosition.y*g_size*g_aspect.y*ageSize, 0.0, 1.0);
  
 // float angle = vpVel.w;
 // bill = rotateXY(bill, angle);
 
 // bill = mul(bill, g_mViewBill);

  vp.w = 1.0;
 // float4 posCenter = mul(vp, g_mProj);
  vp.x += bill.x;
  vp.y += bill.y;
  o.vPosition = mul(vp, g_mProj);
  o.vPosSS = o.vPosition;
  
  float2 tc = float2(v.vPosition.x+1.0, -v.vPosition.y+1.0)*0.5;
    
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = ((tc)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight))*g_texCoordScale+g_texCoordOfs; 
  
  
  /*
  float2 res = float2(512.0, 512.0);
  float4 tangent = float4(1.0, 0.0, 0.0, 1.0);
  tangent *= 1.0/res.x;  
  float4 biTangent = float4(0.0, 1.0, 0.0, 1.0);
  biTangent *= 1.0/res.y;
*/
//  o.vColor = float4(1.0, 1.0, 1.0, ageLeft);

  o.vPixCoordSS = vpT;
  o.vPixCoordSS.z = 1.0/(abs(vp.z/norm.w)+0.001);
  
  o.Depth = v.Depth;
  
  return o;
}




const float zFar = 10000.0;
const float zNear = 0.10;

float getPointDist(float z) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return clipB/(z-clipA);  
}
float getPointZ(float d) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return (clipB + d*clipA)/d;
}


float g_focus = 0.0;
float g_backAmp = 72.0;
float g_frontAmp = 60.0;
float g_sharpDepth = 0.0;

float g_bokehLimit = 1.0;
float g_bokehAttack = 32.0;

VS_OUTPUT_PIX_PARTICLE_SIMPLE vs_particle_bokeh( const VS_INPUT_PIX_PARTICLE v ) {
  VS_OUTPUT_PIX_PARTICLE_SIMPLE o = (VS_OUTPUT_PIX_PARTICLE_SIMPLE)o;
  
  float4 vp = v.vPosition;
  float4 vpT;
  
  vpT.y = ((float)((int)((vp.z+g_particleIndexOffset)/g_windowWidth)));
  vpT.x = ((vp.z+g_particleIndexOffset)-vpT.y*g_windowWidth);
  
  vpT.x *= 1.0/g_windowWidth;
  vpT.y *= 1.0/g_windowHeight;
  vpT.z = 0.0;
  vpT.w = 0.0;
  
  vpT.x += 0.5/g_windowWidth;
  vpT.y += 0.5/g_windowHeight;
  
  vp = tex2Dlod(smPartPos, vpT);
  float4 vDepth = tex2Dlod(smPartVel, vpT); 
  float4 vBlur = 1.0*tex2Dlod(smPartCol, vpT); 
  
  
  float backStart = (clamp(g_focus+g_sharpDepth, 0.0, 100000.0)); 
  float frontStart = (clamp(g_focus-g_sharpDepth, 0.0, 100000.0)); 
  float origDist = getPointDist(vDepth.r);
  float ampBase = clamp((origDist-backStart-0.250)*g_backAmp*0.005, 0.0, 1.0);  
  ampBase += clamp((frontStart-origDist-0.250)*g_frontAmp*0.05, 0.0, 1.0);  
  
 // float3 col = (vp.rgb-0.75)*4.0;
  float3 col = vp.rgb;
  col = (col-0.5)*2.0;
  
  vp.x = vpT.x*2.0-1.0;
  vp.y = -(vpT.y*2.0-1.0);
  
 // float ageLeft = clamp(vp.w, 0.0, 1.0);
  float ageLeft = ampBase*clamp((((col.r+col.g+col.b-vBlur.r-vBlur.g-vBlur.b)/1.0)-g_bokehLimit)*g_bokehAttack, 0.0, 1.0);
  vp.w = 1.0;   
  // vp = mul(vp, g_mView);
  float4 bill = float4(v.vPosition.x*g_size*ageLeft, v.vPosition.y*g_size*ageLeft, 0.0, 1.0);
  
  // bill = mul(bill, g_mViewBill);

  vp.x += bill.x*9.0/16.0;
  vp.y += bill.y;
  vp.z = 0.0;
  
  //o.vPosition = mul(vp, g_mProj);
  o.vPosition = vp;
  
  o.Depth = vDepth.r*1.0-0.175;
  

  float2 tc = float2(v.vPosition.x+1.0, -v.vPosition.y+1.0)*0.5;
    
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = ((tc)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight))*g_texCoordScale+g_texCoordOfs; 
    /*
  float2 res = float2(512.0, 512.0);

  float3 normalResult;
  o.vTangent = float4(1.0, 0.0, 0.0, 1.0);
 // o.vTangent = rotateXY(o.vTangent, angle);
  o.vTangent *= 1.0/res.x;
  
  o.vBiTangent = float4(0.0, 1.0, 0.0, 1.0);
 // o.vBiTangent = rotateXY(o.vBiTangent, angle);
  o.vBiTangent *= 1.0/res.y;
*/
  o.vColor = float4(col.r, col.g, col.b, ageLeft);
 
  return o;
}





struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

struct PS_OUT_BOKEH {
  float4 rt0 : COLOR0; // final mixed image
  float  Depth  : DEPTH;
};

struct PS_OUT_WATER {
  float4 rt0 : COLOR0; // final mixed image
};


struct PS_OUT_DEF {
  float4 rt0 : COLOR0; // depth
  float4 rt1 : COLOR1; // normal
  float4 rt2 : COLOR2; // diffuse
  float4 rt3 : COLOR3; // ambspec
  float  Depth  : DEPTH;
};

struct PS_OUT_DEF_DEPTH_ONLY {
  float4 rt0 : COLOR0; // depth
  float  Depth  : DEPTH;
};


texture g_texDiffuse;
texture g_texHeight;

sampler sm =
sampler_state {
  Texture = <g_texDiffuse>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smHeight =
sampler_state {
  Texture = <g_texHeight>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};



PS_OUT_BOKEH ps_particle_bokeh( VS_OUTPUT_PIX_PARTICLE_SIMPLE In ) {
  PS_OUT_BOKEH o = (PS_OUT_BOKEH)0;

  float4 result = tex2D(sm, In.vTexcoord);
  result.rgb = result.rgb*In.vColor.rgb*g_color.rgb;
  result.rgb *= g_diffuse;
  result.a *= 0.04;
 // result.a = result.r*0.02;
   
  o.rt0 = result;
  o.Depth = In.Depth;
  return o;
}




VS_OUTPUT_PIX_PARTICLE_SIMPLE vs_particle_waves( const VS_INPUT_PIX_PARTICLE v ) {
  VS_OUTPUT_PIX_PARTICLE_SIMPLE o = (VS_OUTPUT_PIX_PARTICLE_SIMPLE)o;
  
  float4 vp = v.vPosition;
  float4 vpT;
  
  vpT.y = ((float)((int)((vp.z+g_particleIndexOffset)/g_windowWidth)));
  vpT.x = ((vp.z+g_particleIndexOffset)-vpT.y*g_windowWidth);
  
  vpT.x *= 1.0/g_windowWidth;
  vpT.y *= 1.0/g_windowHeight;
  vpT.z = 0.0;
  vpT.w = 0.0;
  
  vpT.x += 0.5/g_windowWidth;
  vpT.y += 0.5/g_windowHeight;
    
  vp = tex2Dlod(smPartPos, vpT);    
  vp.x = vp.x*2.0-1.0;
  vp.y = ((vp.y)*2.0-1.0);
  float ageLeft = vp.z;
  vp.z = 0.0;
  vp.w = 1.0;   
  float4 bill = float4(v.vPosition.x*g_size*ageLeft, v.vPosition.y*g_size*ageLeft, 0.0, 1.0);
  vp.x += bill.x*9.0/16.0;
  vp.y += bill.y;
  vp.z = 0.0;
  
  o.vPosition = vp;  
  o.Depth = 1.0; // vDepth.r*1.0-0.175;

  float2 tc = float2(v.vPosition.x+1.0, -v.vPosition.y+1.0)*0.5;    
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = ((tc)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight))*g_texCoordScale+g_texCoordOfs; 
  o.vColor = float4(1.0, 1.0, 1.0, ageLeft); 
  return o;
}

PS_OUT_WATER ps_particle_waves( VS_OUTPUT_PIX_PARTICLE_SIMPLE In ) {
  PS_OUT_WATER o = (PS_OUT_WATER)0;
  float4 result = tex2D(sm, In.vTexcoord);
  result.rgb *= g_diffuse;
  o.rt0 = result;
  return o;
}






PS_OUT ps_particle( VS_OUTPUT_PIX_PARTICLE In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
 
  result += tex2D(sm, In.vTexcoord);
  result = clamp(result*1.0, 0.0, 100000.0)*g_color;
  result.rgb *= g_diffuse;
  result.a *= 1.0;
   
  o.rt0 = result;
  return o;
}

float g_bumpSphere = 0.0f;

float g_refl = 0.0f;
float g_emitPart = 0.0;

PS_OUT_DEF ps_particle_deferred( VS_OUTPUT_PIX_PARTICLE In ) {
  float depthaa = tex2D(smHeight, In.vTexcoord).g;
  float depthi = (In.vPosSS.z+0.0) / In.vPosSS.w;
  
 // if (depthi < 0.7) discard;
 // if (In.Depth > depthi)
 //   discard;

  float4 depthPart = depthaa*g_color*g_depthClipMul;
  float ageLeft = In.vColor.a;
  depthPart.a *= saturate(ageLeft*0.010);
  if ((depthPart.a) < (1.0-depthPart.g)*1.0 || depthPart.a < 0.01) {
    discard;
  }
	
  PS_OUT_DEF o = (PS_OUT_DEF)0;
  float4 result = 0;
	
  float4 diffu = tex2D(sm, In.vTexcoord);
  result = g_color*diffu*g_diffuse;
  result.rgb *= In.vColor.rgb;
   
  // diffuse 
  result.a = 1.0;
  o.rt2 = result;
    
  // normal
  float4 bumpe = 0;
  if (g_bumpSphere < 0.5f) {
	  bumpe.x = (tex2D(smHeight, In.vTexcoord+float2(In.vTangent.x, In.vTangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(In.vTangent.x, In.vTangent.y)).g)*(-0.667);
	  bumpe.y = (tex2D(smHeight, In.vTexcoord+float2(In.vBiTangent.x, In.vBiTangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(In.vBiTangent.x, In.vBiTangent.y)).g)*(1.0);
	  bumpe = bumpe*g_defBumpness;
	  bumpe.z = -g_defHeight;
  } else {
	  // make a sphere
	  bumpe.xy = (In.vTexcoord*2.0-1.0);
	  bumpe.x = -bumpe.x;
	  float len1 = (bumpe.x*bumpe.x+bumpe.y*bumpe.y);
	  if (len1 > 1.0f) {
		discard;
	  }
	  bumpe.z = sqrt(1.0-bumpe.x*bumpe.x-bumpe.y*bumpe.y);
  }
  bumpe = (normalize(bumpe)+1.0)*0.5;
      
  o.rt1 = float4(bumpe.x, bumpe.y, 0.0, 0.0);  
  
  o.rt2.a = g_emitPart;
  
  // depth
  
  float dee = (In.vPosSS.z)/In.vPosSS.w+0.0005;
  float dee2 = (In.vPosSS.z)/In.vPosSS.w;
  
 // float dee = In.vDepth;
  float depthOfs = depthaa*g_defHeight;
  o.Depth = getPointZ(getPointDist(dee)+depthOfs);
  o.rt0.r = getPointZ(getPointDist(dee2)+depthOfs);//(In.vPosSS.z)/In.vPosSS.w;
  
  o.rt3.x = g_ambience;
  o.rt3.y = g_specular;
  o.rt3.z = 64.0;
  o.rt3.w = g_refl;
  
  return o;
}


PS_OUT_DEF_DEPTH_ONLY ps_particle_deferred_depth_only( VS_OUTPUT_PIX_PARTICLE In ) {
  float depthaa = tex2D(smHeight, In.vTexcoord).g;
  float depthi = (In.vPosSS.z+0.0-1.0*depthaa*g_defHeight) / In.vPosSS.w;
  
  float4 depthPart = depthaa*g_color*g_depthClipMul;
  float ageLeft = In.vColor.a;
  depthPart.a *= saturate(ageLeft*0.010);
  if ((depthPart.a) < (1.0-depthPart.g)*1.0 || depthPart.a < 0.01) {
    discard;
  }
	
  PS_OUT_DEF_DEPTH_ONLY o = (PS_OUT_DEF_DEPTH_ONLY)0;
  float4 result = 0;
	
  // depth
  o.Depth = depthi;
  o.rt0 = depthi;  
  return o;
}


PS_OUT_DEF ps_particle_deferred_ss( VS_OUTPUT_PIX_PARTICLE_SS In ) {
  float depthaa = tex2D(smHeight, In.vTexcoord).g;
  float depthi = (In.vPosSS.z+0.0-1.0*depthaa*g_defHeight) / In.vPosSS.w;
  
 // if (depthi < 0.7) discard;
 // if (In.Depth > depthi)
 //   discard;

  float4 depthPart = depthaa*g_color*g_depthClipMul;
  float ageLeft = 1.0; // In.vColor.a;
  depthPart.a *= saturate(ageLeft*0.10);
  if ((depthPart.a) < (1.0-depthPart.g)*1.0 || depthPart.a < 0.01) {
    discard;
  }
	
  PS_OUT_DEF o = (PS_OUT_DEF)0;
  float4 result = 0;
  
  // smPartPos
  // smPartVel
  // smPartVar
 
	
  float4 diffu = tex2Dlod(smPartCol, float4(In.vPixCoordSS.xy, 0.0, 0.0))*g_color;
  result = diffu*g_diffuse;
   
  // diffuse 
  result.a = 1.0;
  o.rt2 = result;
    
  // normal
  float4 bumpe = 0;
  
  float2 res = float2(512.0, 512.0);
  float4 tangent = float4(1.0, 0.0, 0.0, 1.0);
  tangent *= 1.0/res.x;  
  float4 biTangent = float4(0.0, 1.0, 0.0, 1.0);
  biTangent *= 1.0/res.y;  
  
  // normal
  if (g_bumpSphere < 0.5f) {
	  bumpe.x = (tex2D(smHeight, In.vTexcoord+float2(tangent.x, tangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(tangent.x, tangent.y)).g)*(-0.667);
	  bumpe.y = (tex2D(smHeight, In.vTexcoord+float2(biTangent.x, biTangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(biTangent.x, biTangent.y)).g)*(1.0);
	  bumpe = bumpe*g_defBumpness;
	  bumpe.z = -g_defHeight;
  } else {
	  // make a sphere
	  bumpe.xy = In.vTexcoord*2.0-1.0;
	  float len1 = (bumpe.x*bumpe.x+bumpe.y*bumpe.y);
	  if (len1 > 1.0f) {
		discard;
	  }
	  bumpe.z = sqrt(1.0-bumpe.x*bumpe.x-bumpe.y*bumpe.y);
  }
  bumpe = (normalize(bumpe)+1.0)*0.5;
  
  float ab = saturate(In.vPixCoordSS.z-0.5);
  float ssSizeFactor = saturate(ab*0.75);
  
 
  float4 normalFromTexture = tex2Dlod(smPartVel, float4(In.vPixCoordSS.xy, 0.0, 0.0));
  bumpe = (ssSizeFactor)*bumpe+(1.0-ssSizeFactor)*normalFromTexture;  
 // bumpe *= 0.5;
  o.rt1 = float4(bumpe.x, bumpe.y, 0.0, 0.0);  
  
  o.rt2.a = g_emitPart;
  
  // depth
  o.Depth = depthi;
  o.rt0 = depthi;  
  o.rt3.x = g_ambience;
  o.rt3.y = g_specular;
  o.rt3.z = 132.0;
  o.rt3.w = g_refl;
  
  return o;
}


PS_OUT_DEF_DEPTH_ONLY ps_particle_deferred_ss_depth_only( VS_OUTPUT_PIX_PARTICLE_SS In ) {
  float depthaa = tex2D(smHeight, In.vTexcoord).g;
  float depthi = (In.vPosSS.z+0.0-1.0*depthaa*g_defHeight) / In.vPosSS.w;

  float4 depthPart = depthaa*g_color*g_depthClipMul;
  float ageLeft = 1.0; // In.vColor.a;
  depthPart.a *= saturate(ageLeft*0.010);
  if ((depthPart.a) < (1.0-depthPart.g)*1.0 || depthPart.a < 0.01) {
    discard;
  }
  PS_OUT_DEF_DEPTH_ONLY o = (PS_OUT_DEF_DEPTH_ONLY)0;
  float4 result = 0;
  
  // depth
  o.Depth = depthi;
  o.rt0 = depthi;  

  return o;
}


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero();
        PixelShader  = compile ps_3_0 ps_particle();
    }
}

technique RenderBokeh {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_particle_bokeh();
        PixelShader  = compile ps_3_0 ps_particle_bokeh();
    }
}

technique RenderWaves {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_particle_waves();
        PixelShader  = compile ps_3_0 ps_particle_waves();
    }
}


technique RenderDeferred {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero();
        PixelShader  = compile ps_3_0 ps_particle_deferred();
    }
}

technique RenderDeferred_depthOnly {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero();
        PixelShader  = compile ps_3_0 ps_particle_deferred_depth_only();
    }
}


technique RenderSS {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero_ss();
        PixelShader  = compile ps_3_0 ps_particle_deferred_ss();
    }
}
technique RenderSS_depthOnly {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero_ss();
        PixelShader  = compile ps_3_0 ps_particle_deferred_ss_depth_only();
    }
}




