
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;

float g_time;


texture g_tDiffuse;

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord+float2((-0.5)/g_windowWidth, (-0.5)/g_windowHeight));
  float4 result = colorIn;
  
  float pixIndex = In.vTexcoord.x*(g_windowWidth-1) + (int)(In.vTexcoord.y*(g_windowHeight-1))*(g_windowWidth-1);
  float pf = pixIndex*0.0001;
  
  float t = g_time*0.021;
  
 // result.x = sin(1.7678*cos(pf*0.2348+t*0.01))*100.0;
 // result.x = frac((result.x-t*15.0+50.0)/100.0)*200.0-100.0;
 // result.y = cos(1.28954*sin(pf*0.41243+0.012*t))*100.0-50.0;
 // result.z = sin(pf*0.2442135+0.014*t)*100.0;
 /*
  result.x = 9.0*sin(pf);
  result.y = 9.0*cos(pf)+2.0;
  result.z = pf*1.0-30.0;
  */
  result.x = sin(pf);
  result.y = cos(pf*12.3+t*10.3+result.x)*7.3;
  result.x *= result.y;
  result.z =sin(pf*8.2+result.x+t+result.y)*result.x;
  result.xyz *= 10.0;
  result.y += 0.0;
  
  result.w = 120.0;
    
  o.rt0 = result;
  return o;
} 


PS_OUT psMS( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord+float2((-0.5)/g_windowWidth, (-0.5)/g_windowHeight));
  float4 result = colorIn;
  
  float pixIndex = In.vTexcoord.x*(g_windowWidth-1) + (int)(In.vTexcoord.y*(g_windowHeight-1))*(g_windowWidth-1);
  float pf = pixIndex*0.001;
  
  float t = g_time*1.91;
  
 // result.x = sin(1.7678*cos(pf*0.2348+t*0.01))*100.0;
 // result.x = frac((result.x-t*15.0+50.0)/100.0)*200.0-100.0;
 // result.y = cos(1.28954*sin(pf*0.41243+0.012*t))*100.0-50.0;
 // result.z = sin(pf*0.2442135+0.014*t)*100.0;
 /*
  result.x = 9.0*sin(pf);
  result.y = 9.0*cos(pf)+2.0;
  result.z = pf*1.0-30.0;
  */
  result.x = sin(pf+t);
  result.y = cos(pf*2.3+t*1.3+result.x)*4.3;
  result.x *= result.y;
  result.z =sin(pf+result.x+t+result.y);
  result.xyz *= 3.0;
  result.y += 5.0;
  
  result.w = 1.0;
    
  o.rt0 = result;
  return o;
} 



PS_OUT psMani( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord+float2((-0.5)/g_windowWidth, (-0.5)/g_windowHeight));
  float4 result = colorIn;
  
  float pixIndex = In.vTexcoord.x*(g_windowWidth-1) + (int)(In.vTexcoord.y*(g_windowHeight-1))*(g_windowWidth-1);
  float pf = pixIndex*0.01;
  
  float t = g_time*10.91;
  
 // result.x = sin(1.7678*cos(pf*0.2348+t*0.01))*100.0;
 // result.x = frac((result.x-t*15.0+50.0)/100.0)*200.0-100.0;
 // result.y = cos(1.28954*sin(pf*0.41243+0.012*t))*100.0-50.0;
 // result.z = sin(pf*0.2442135+0.014*t)*100.0;
 /*
  result.x = 9.0*sin(pf);
  result.y = 9.0*cos(pf)+2.0;
  result.z = pf*1.0-30.0;
  */
  result.x = sin(pf+t);
  result.y = cos(pf*44.3+t*212.3+result.x);
  result.x *= result.y;
  result.z =sin(pf+result.x+t+result.y);
  result.xyz *= 3.0;
  result.y += 5.0;
  
  result.w = 1.0;
    
  o.rt0 = result;
  return o;
} 




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

