
float4x4 g_mWorldViewProjection;    

float4x4 g_mInvProj;
float4x4 g_mInvView;


float g_windowWidth;
float g_windowHeight;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // new position
  float4 rt1 : COLOR1; // new normal
  float4 rt2 : COLOR2; // color
 // float4 rt3 : COLOR3; // original screen space position
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;

float g_time;
float g_timeStep;


texture g_tPosPrev;
sampler smPosPrev =
sampler_state {
  Texture = <g_tPosPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVelPrev;
sampler smVelPrev =
sampler_state {
  Texture = <g_tVelPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVarPrev;
sampler smVarPrev =
sampler_state {
  Texture = <g_tVarPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDepth;
sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tNormal;
sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDiffuse;
sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};


const float zFar = 10000.0;
const float zNear = 0.10;


float getPointDist(float z) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return clipB/(z-clipA);  
}

float getPointZ(float d) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  return (clipB + d*clipA)/d;
}

float2 indexToCoords(float index, float width) {
  float2 tc;


  float k = index/width;
  tc.x = frac(k);
  tc.y = (k-tc.x)/width;
  return tc;
}

float coordsToIndex(float2 tc, float2 dim) {
  return tc.x*dim.x + ((int)(tc.y*dim.y))*dim.x;
}

float4 g_boxSize;

float g_emitterRad;
float g_emitterDirSpeed;
float g_emitterRotate;

float g_emitterMove;
float g_emitterMoveSpeed;

float g_spread;

float g_spreadScale;
float g_spreadEvolve;

float g_maxAge;

float4 g_emitPos;
float4 g_outputLinesAndOffset;

float g_collisionAtt;


float4 g_grav;

float4 g_emitLineStartPos;
float4 g_emitLineEndPos;

PS_OUT ps_pixsim1( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
 // float4 pos = tex2D(smPosPrev, In.vTexcoord+tcOfs);
 // float4 vel = tex2D(smVelPrev, In.vTexcoord+tcOfs);
 // float4 var = tex2D(smVarPrev, In.vTexcoord+tcOfs);
  float4 pColor = tex2D(smDiffuse, In.vTexcoord);
  
  float emitAmount = frac(pColor.a);
  
  if (emitAmount < 0.02) { // check if pixel not set to emit
      //->emit empty particle (size 0.0 also)
	  o.rt0 = (float4)0.0;
	  o.rt1 = (float4)0.0;
	  o.rt2 = (float4)0.0;
	  //o.rt3 = float4(0.0, 0.0, 0.0, 0.0);
      return o;	  
  }
  
  float4 pDepth = tex2D(smDepth, In.vTexcoord);
  float4 pNormal = tex2D(smNormal, In.vTexcoord);
  
  float pixIndex = coordsToIndex(In.vTexcoord, float2(g_windowWidth, g_windowHeight)); 
  float2 tCoords = indexToCoords(pixIndex, g_windowWidth);

  if ((pixIndex/g_windowWidth > (g_outputLinesAndOffset.x+g_outputLinesAndOffset.y)) ||
      (pixIndex/g_windowWidth < g_outputLinesAndOffset.y)) {
    discard;
  }
  /*
 float4 vProjectedPos = float4(x, y, z, 1.0f);
    // Transform by the inverse projection matrix
    float4 vPositionVS = mul(vProjectedPos, g_matInvProjection);  
    // Divide by w to get the view-space position
    return vPositionVS.xyz / vPositionVS.w;   
*/	
/*
  if (pDepth.r>0.999) {
    o.rt0 = float4(10000.0, 10000.0, -10000.0, 1.0);
	o.rt1 = float4(0.0, 0.0, 0.0, 0.0);
	o.rt2 = float4(0.0, 0.0, 0.0, 0.0);
	return o;
  }
  */
  
  float2 tc2 = In.vTexcoord*2.0-1.0;
  tc2.y = -tc2.y;
  float4 pos = float4(tc2, (pDepth.r), 1.0);
  pos = mul(pos, g_mInvProj);
  pos = mul(pos, g_mInvView);
  pos.xyz /= pos.w;
  
  float ip;
  // +10000.0 in age marks not inited yet, when first sim starts, decrease -10000 from age and reset velocity ....
  pos.w = 10000.0+50.0+modf(pixIndex/100.0, ip)*50.0;
  
  // set the size to be proportional of the depth...
  pNormal.w = 1.0*getPointDist(pDepth.r);
//  pNormal.w = pow(pNormal.w, 1.5);
  if (pDepth.r > 0.999) {
    pNormal.w = 0.0;
  }
  
  o.rt0 = pos;
  o.rt1 = pNormal;
  o.rt2 = pColor;
 // o.rt3 = float4(In.vTexcoord*2.0-1.0, 0.0, 0.0);
  return o;
} 


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps_pixsim1( );
    }
}

