
float4x4 g_mWorldViewProjection;    

float4x4 g_mInvProj;
float4x4 g_mInvView;


float g_windowWidth;
float g_windowHeight;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // new position
  float4 rt1 : COLOR1; // new velocity
  float4 rt2 : COLOR2; // 
  float4 rt3 : COLOR3; // 
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;

float g_time;
float g_timeStep;


texture g_tDepth;
sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tNormal;
sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tDiffuse;
sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};


const float zFar = 10000.0;
const float zNear = 0.10;


float getPointDist(float z) {
 // float clipA = zFar / (zFar - zNear); // 1.000010000100001000010000100001
 // float clipB = zFar*zNear / (zNear - zFar); // -0.1000010000100001000010000100001
 // return clipB/(z-clipA);  
 
 // (-zFar*zNear) = -1000.0
 // (zFar-zNear) = 9999.9
 // float s = 16777216.0;
 // return (-s*zFar*zNear)/(z*(zFar-zNear)-zFar*s);
 
 float clipA = (zFar+zNear)/(2.0*(zFar-zNear))+0.5;
 float clipB = (-zFar*zNear)/(zFar-zNear);
 // z = clipA+clipB*(1/d);
 // clipB*(1/d) = z-clipA;
 // d = (z-clipA)/clipB;
 //return z;
 return clipB/(z-clipA);
 
}

float getPointZ(float d) {
//  float clipA = zFar / (zFar - zNear);
//  float clipB = zFar*zNear / (zNear - zFar);
//  return (clipB + d*clipA)/d;
 float clipA = (zFar+zNear)/(2.0*(zFar-zNear))+0.5;
 float clipB = (-zFar*zNear)/(zFar-zNear);
 return clipA+clipB/d;
}

bool valueInThr(float v, float thr) {
  if (v<0.0) {
    v = -v;
  }
  if (v<thr) {
    return true;
  }
  return false;
}


float2 indexToCoords(float index, float width) {
  float2 tc;


  float k = index/width;
  tc.x = frac(k);
  tc.y = (k-tc.x)/width;
  return tc;
}

float coordsToIndex(float2 tc, float2 dim) {
  return tc.x*dim.x + ((int)(tc.y*dim.y))*dim.x;
}

float4 g_boxSize;

float g_emitterRad;
float g_emitterDirSpeed;
float g_emitterRotate;

float g_emitterMove;
float g_emitterMoveSpeed;

float g_spread;

float g_spreadScale;
float g_spreadEvolve;

float g_maxAge;

float4 g_emitPos;
float4 g_outputLinesAndOffset;

float g_collisionAtt;


float4 g_grav;

float4 g_emitLineStartPos;
float4 g_emitLineEndPos;

PS_OUT ps_pixsim1( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 pColor = tex2D(smDiffuse, In.vTexcoord);
  float4 pDepth = tex2D(smDepth, In.vTexcoord);
  float4 pNormal = tex2D(smNormal, In.vTexcoord);
  
  float pixIndex = coordsToIndex(In.vTexcoord, float2(g_windowWidth, g_windowHeight)); 
  float2 tCoords = indexToCoords(pixIndex, g_windowWidth);

  if ((pixIndex/g_windowWidth > (g_outputLinesAndOffset.x+g_outputLinesAndOffset.y)) ||
      (pixIndex/g_windowWidth < g_outputLinesAndOffset.y)) {
    discard;
  }

  float4 n = tex2D(smNormal, In.vTexcoord);
  float d = getPointDist((pDepth.r));
  float2 to = 2.0*float2(1.0/g_windowWidth, 1.0/g_windowHeight);
  
  float4 uv = (float4)0.0;
  
  if (n.z != 0.0 && n.w != 0.0) {
    float2 tco;

	float thr = 0.2;	
	int emitParticle = 0;	
	
    float4 noR = (float4)1.0;
	tco = In.vTexcoord+float2(to.x, 0.0);
	if (tco.x < 1.0) {
	  noR = tex2D(smNormal, tco);
	}
	if (noR.z == 0.0 && noR.w == 0.0) {
	  float od = getPointDist(tex2D(smDepth, In.vTexcoord+float2(to.x, 0.0)));
	  if (valueInThr(d-od, thr)) {
		emitParticle = 1;
	  }
	}	
	
    float4 noL = (float4)1.0;
	tco = In.vTexcoord+float2(-to.x, 0.0);
	if (tco.x > 0.0) {
	  noL = tex2D(smNormal, tco);
	}
	if (noL.z == 0.0 && noL.w == 0.0) {
	  float od = getPointDist(tex2D(smDepth, In.vTexcoord+float2(-to.x, 0.0)));
	  if (valueInThr(d-od, thr)) {
		emitParticle = 1;
	  }
	}
	
    float4 noU = (float4)1.0;
	tco = In.vTexcoord+float2(0.0, to.y);
	if (tco.y > 0.0) {
	  noU = tex2D(smNormal, tco);
	}
	if (noU.z == 0.0 && noU.w == 0.0) {
	  float od = getPointDist(tex2D(smDepth, In.vTexcoord+float2(0.0, to.y)));
	  if (valueInThr(d-od, thr)) {
		emitParticle = 1;
	  }
	}
	
    float4 noD = (float4)1.0;
	tco = In.vTexcoord+float2(0.0, -to.y);
	if (tco.y < 1.0) {
	  noD = tex2D(smNormal, tco);
	}
	if (noD.z == 0.0 && noD.w == 0.0) {
	  float od = getPointDist(tex2D(smDepth, In.vTexcoord+float2(0.0, -to.y)));
	  if (valueInThr(d-od, thr)) {
		emitParticle = 1;
	  }
	}
				
	if (emitParticle) {
	  uv = float4(n.z, -n.w, 1.0, 0.0);
	}
  }
 // uv = float4(d, d, d, 0.0);
  
  o.rt0 = uv;
  return o;
} 


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps_pixsim1( );
    }
}

