// DemoContextData.cpp

#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>
#include <string>

#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "effect.h"

#include "ContextData.h"
#include "DemoContextData.h"

#include "common_globals.h"
#include "D3DApp.h"
#include "layout.h"

#include "fmod.h"

#include "music.h"

#include "timeline.h"

#include "MouseSensor.h"

#include "../../demowork/sync/sync.h"


float rocket_bpm = 108.0f; /* beats per minute */
int rocket_rpb = 8; /* rows per beat */
double rocketRowRate = (double(rocket_bpm) / 60) * rocket_rpb;

void SetRocketRowRate(float bpm, int rpb) {
  if (bpm != -1) {
    rocket_bpm = bpm;
  }
  if (rpb != -1) {
    rocket_rpb = rpb;
  }
  rocketRowRate = (double(rocket_bpm) / 60) * rocket_rpb;
}

//#define USE_FMOD_TIME 1
#define USE_CLOCK_TIME 1


double fmod_get_row()
{
//	QWORD pos = BASS_ChannelGetPosition(h, BASS_POS_BYTE);
//	double time = BASS_ChannelBytes2Seconds(h, pos);
  DemoContextData *pDCD = (DemoContextData*)GetCurrentContextData();
  if (pDCD && pDCD->m_demoMusic) {
#ifdef USE_FMOD_TIME
    double time = pDCD->m_demoMusic->GetPosition();
#endif
#ifdef USE_CLOCK_TIME
    double time = pDCD->GetTimelineTime();
#endif
	  return time * rocketRowRate;
  } else {
    return 0.0;
  }
}

double fmod_get_time()
{
//	QWORD pos = BASS_ChannelGetPosition(h, BASS_POS_BYTE);
//	double time = BASS_ChannelBytes2Seconds(h, pos);
  DemoContextData *pDCD = (DemoContextData*)GetCurrentContextData();
  if (pDCD && pDCD->m_demoMusic) {
#ifdef USE_FMOD_TIME
    double time = pDCD->m_demoMusic->GetPosition();
#endif
#ifdef USE_CLOCK_TIME
    double time = pDCD->GetTimelineTime();
#endif
	  return time;
  } else {
    return 0.0;
  }
}


#ifndef SYNC_PLAYER

void fmod_pause(void *d, int flag)
{
  DemoContextData *pDCD = (DemoContextData*)GetCurrentContextData();
  pDCD->SetPaused(flag);
  // m_paused = !m_paused;
/*
	if (flag)
		BASS_ChannelPause((HSTREAM)d);
	else
		BASS_ChannelPlay((HSTREAM)d, false);
    */
  if (pDCD && pDCD->m_demoMusic) {
    pDCD->m_demoMusic->SetPause(flag);
  }
}

void fmod_set_row(void *d, int row)
{
  DemoContextData *pDCD = (DemoContextData*)GetCurrentContextData();
  if (pDCD && pDCD->m_demoMusic) {
    return pDCD->m_demoMusic->SetPosition((float)row/rocketRowRate);
  }

  /*
	QWORD pos = BASS_ChannelSeconds2Bytes((HSTREAM)d, row / row_rate);
	BASS_ChannelSetPosition((HSTREAM)d, pos, BASS_POS_BYTE);
  */
}

int fmod_is_playing(void *d) {
  DemoContextData *pDCD = (DemoContextData*)GetCurrentContextData();
  if (pDCD && pDCD->m_demoMusic) {
    return pDCD->m_demoMusic->IsPlaying();
  }
  return 0;
//	return BASS_ChannelIsActive((HSTREAM)d) == BASS_ACTIVE_PLAYING;
}

struct sync_cb fmod_cb = {
	fmod_pause,
	fmod_set_row,
	fmod_is_playing
};

#endif

sync_device *g_rocket = NULL;



sync_device *GetRocket() { 
  return g_rocket;
}

ContextData* GetNewApplicationContextData(int index) {
  DemoContextData *demoContextData = new DemoContextData(index);
  return (ContextData*)demoContextData;
}

DemoContextData::DemoContextData(int index) : ContextData(index) {




//	if (!rocket)
//		die("out of memory?");

  if (g_syncEditor) {
	  sync_set_callbacks(g_rocket, &fmod_cb, (void *)NULL);
    if (sync_connect(g_rocket, "localhost", SYNC_DEFAULT_PORT)) {
  //		die("failed to connect to host");
    }
  }

  m_timeline = new Timeline();
  m_timeline->Init(g_layout->getElement(g_languageCode, "config")->get("timeline_file")->valueStr);

  m_demoMusic = NULL;
  m_demoMusicAhead = NULL;
  if (g_layout->getElement(g_languageCode, "config")->get("music_file")) {
    std::string musicFile = g_layout->getElement(g_languageCode, "config")->get("music_file")->valueStr;
    if (strcmp(musicFile.c_str(), "") != 0) {
      m_demoMusic = new Music();
      m_demoMusic->LoadSong(musicFile);
      m_demoMusic->SetVolume(g_musicVolume);
      m_demoMusic->SetPause(true);
    }
  }

  m_timelineTime = g_layout->getElement(g_languageCode, "config")->get("start_time")->valueVec[0];
  if (m_demoMusic) {
    m_demoMusic->SetPosition(m_timelineTime);
  }

  m_timelineTimeStep = 0.0f;

//	clear_r = sync_get_track(rocket, "clear.r");



  m_showTime = true;

  m_paused = false;

  m_musicPosNotSet = false;
}

DemoContextData::~DemoContextData() {
  sync_destroy_device(g_rocket);

}

bool DemoContextData::appDoCleanup() {
  return true;
}

HRESULT DemoContextData::appCreateDeviceObjects() {
  return D3D_OK;
}

HRESULT DemoContextData::appDestroyDeviceObjects() {
  return D3D_OK;
}


void DemoContextData::appInput() {

  if (g_bDebugRender) {
    return;
  }

  m_timelineTimeStep = m_timeStep;

  if (m_paused)
    m_timelineTimeStep = 0.0f;

  // handle mouse events for this frame
  // ...TBD


// #ifndef SYNC_PLAYER
  if (g_syncEditor) {
    int row = fmod_get_row();
    int boolDataUpdated = 0;
    if (sync_update(g_rocket, (int)row, &boolDataUpdated)) {
	    sync_connect(g_rocket, "localhost", SYNC_DEFAULT_PORT);
    }
    if (boolDataUpdated) {
      extern bool g_bAdvanceAndRenderEffects;
      g_bAdvanceAndRenderEffects = true;
    }
  }

  UpdateInput();


  float rewindSpeedFast = g_layout->getElement(g_languageCode, "config")->get("rewind_speed_fast")->valueVec[0];
  float rewindSpeedSlow = g_layout->getElement(g_languageCode, "config")->get("rewind_speed_slow")->valueVec[0];

  float endTime = g_layout->getElement(g_languageCode, "config")->get("end_time")->valueVec[0];

  if (!g_syncEditor) {
    if (m_keysDown[VK_LEFT]) {
      if (m_paused)
        m_timelineTimeStep = m_timeStep;
      m_timelineTimeStep *= -rewindSpeedFast;
      if (m_demoMusic) {
        m_demoMusic->SetPosition(m_timelineTime+m_timelineTimeStep);
      }
      if (!m_paused)
        m_musicPosNotSet = true;
    } else if (m_keysDown[VK_RIGHT]) {
      if (m_paused)
        m_timelineTimeStep = m_timeStep;
      m_timelineTimeStep *= rewindSpeedFast;
      if (m_demoMusic) {
        m_demoMusic->SetPosition(m_timelineTime+m_timelineTimeStep);
      }
      if (!m_paused)
        m_musicPosNotSet = true;
    }

    if (m_keysDown[VK_DOWN]) {
      if (m_paused)
        m_timelineTimeStep = m_timeStep;
      m_timelineTimeStep *= -rewindSpeedSlow;
      if (m_keysDown[VK_LEFT])
        m_timelineTimeStep *= -1.0f;
      if (m_demoMusic) {
        m_demoMusic->SetPosition(m_timelineTime+m_timelineTimeStep);
      }
      if (!m_paused)
        m_musicPosNotSet = true;
    } else if (m_keysDown[VK_UP]) {
      if (m_paused)
        m_timelineTimeStep = m_timeStep;
      m_timelineTimeStep *= rewindSpeedSlow;
      if (m_demoMusic) {
        m_demoMusic->SetPosition(m_timelineTime+m_timelineTimeStep);
      }
      if (!m_paused)
        m_musicPosNotSet = true;
    }

    if (m_keysDown[VK_SPACE] == 1) {
      m_paused = !m_paused;
      fmod_pause(NULL, m_paused);
    }
  }

  if (m_keysDown[VK_F5] == 1) {
    g_reloadEffects = true;
  }

  if (m_keysDown[VK_F6] == 1) {
    g_reloadShaders = true;
  }


  if (m_keysDown[VK_F2] == 1) {
    g_debugHide = !g_debugHide;
  }



  if (m_timelineTime > endTime)
    g_quitDemo = true;

  if (m_timelineTime < 0.0) {
    m_musicPosNotSet = true;
    if (m_demoMusic) {
      m_demoMusic->SetPause(true);
    }
  }

  if (m_musicPosNotSet && (m_timelineTime >= 0.0f)) {
    if (m_demoMusic) {
      m_demoMusic->SetPosition(m_timelineTime);
      m_demoMusic->SetPause(false);
    }
    m_musicPosNotSet = false;
  }

}


class DemoContextMouseSensor : public MouseSensor {
private:
  string m_clickTypeString;
public:
  DemoContextMouseSensor(int al, int ar, int at, int ab, string clickTypeString) : MouseSensor(al, ar, at, ab) {
    m_clickTypeString = clickTypeString;
  }
  bool OnAreaAction(int mouseX, int mouseY, bool lDown, bool lClick, bool lDblClick, bool rDown, bool rClick, bool rDlbClick) {
    if (lClick) {
      if (strcmp(m_clickTypeString.c_str(), "hideDebug")==0) {
        g_debugHide = !g_debugHide;
      }
    }
    return true;
  }
};


vector<DemoContextMouseSensor> demoContextMouseSensors;

#define TIME_DIFF_SAMPLES 16
static float timeDiffSamples[TIME_DIFF_SAMPLES*2];
int currTimeDiffSample = 0;

bool DemoContextData::appAdvance() {

  if (g_bDebugRender) {
    return true;
  }

  demoContextMouseSensors.clear();

  float prevTime = m_timelineTime;

#ifdef USE_FMOD_TIME
  m_timelineTime = fmod_get_time();
  m_timelineTimeStep = m_timelineTime - prevTime;
#endif

  m_timeline->SetCurrentTime(m_timelineTime, m_timelineTimeStep);
#ifdef USE_CLOCK_TIME
  m_timelineTime += m_timelineTimeStep;

  double musicTime = 0.0;
  
  if (m_demoMusic) {
    musicTime = m_demoMusic->GetPosition();
  }
  if (GetIsPaused()) {
    m_timelineTime = musicTime;
  }
  float timeDiff = musicTime - m_timelineTime;
  timeDiffSamples[currTimeDiffSample%TIME_DIFF_SAMPLES] = timeDiff;
  currTimeDiffSample++;

  float timeDiffAvg = 0.0f;
  for (int i=0; i<TIME_DIFF_SAMPLES; i++) {
    timeDiffAvg += timeDiffSamples[i];
  }
  timeDiffAvg /= (float)TIME_DIFF_SAMPLES;

  char kukko[512];
  sprintf(kukko, "time diff %d sample average %f\n", TIME_DIFF_SAMPLES, timeDiffAvg);

  if ((fabs(timeDiff) > 0.2)) {
    m_timelineTime = musicTime;
    char kukko[512];
    sprintf(kukko, "time diff by %f\n", timeDiff);
    OutputDebugString(kukko);
  }

  if (m_timelineTime < 0.0f) {
    m_timelineTime = 0.0f;
  }
#endif


  m_timeline->AdvanceEffects();
  return true;
}

HRESULT DemoContextData::appRender() {

  D3DApp *pD3DApp = g_D3DApp;

  if (g_bDebugRender && g_D3DAppDebug) {
    pD3DApp = g_D3DAppDebug;
  }

  LPDIRECT3DDEVICE9 pd3dDevice = pD3DApp->m_pd3dDevice;
  pD3DApp->setRenderDefaultStates();

  D3DVIEWPORT9 vp9;

  vp9.MinZ = 0.0f;
  vp9.MaxZ = 0.0f;

  if (g_D3DApp->m_windowed) {
    vp9.X = 0;
    vp9.Y = 0;
    vp9.Width = pD3DApp->m_windowWidth;
//    vp9.Height = m_height;
    vp9.Height = (DWORD)((float)pD3DApp->m_windowHeight);
  } else {
    float aa = (pD3DApp->m_windowHeight - pD3DApp->m_monitorAspectRatio/(16.0f/9.0f)*pD3DApp->m_windowHeight)*0.5f;
    vp9.X = 0;
    vp9.Y = (DWORD)aa;
    vp9.Width = pD3DApp->m_windowWidth;
    vp9.Height = (DWORD)((float)pD3DApp->m_windowWidth*9.0f/16.0f);
    
  }

  pd3dDevice->SetViewport(&vp9);


  DWORD ticksNow = timeGetTime();
  static DWORD ticksFrameCount=timeGetTime();
  static int fps = 0;
  static int frameCount = 0;


  if (!g_bDebugRender) {
    frameCount++;
    char tempStr[512];
 //   sprintf(tempStr, "frame %d\n", frameCount);
 //   OutputDebugString(tempStr);

    if (g_D3DAppDebug) { // clear the debug device here as the demo code might be drawing some stuff directly to the debug window
      g_D3DAppDebug->m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_RGBA(0, 0, 0, 0), 1.0f, 0 );
    }
    m_timeline->RenderEffects();
  } else {
    // pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, D3DCOLOR_RGBA(0, 0, 0, 0), 1.0f, 0 );
  }

  if (ticksNow-ticksFrameCount >= 1000) {
    ticksFrameCount = ticksNow;
    fps = frameCount;
    frameCount=0;
    char timeStr[512];
    sprintf(timeStr, "fps %d\ntime %3.2f", fps, m_timelineTime);
  //  OutputDebugString(timeStr);
    SetWindowText(g_hWnd, timeStr);
  }

  if (g_bDebugRender || !g_D3DAppDebug) {
    pD3DApp->RenderDebugInfo("HIDE (F2)", 0, 0xFF888888, false, 5, 5);

    DemoContextMouseSensor dMS(5, 5+60, 10, 5+12, "hideDebug");
    demoContextMouseSensors.push_back(dMS);
    MouseSensor *ms = (MouseSensor*)&demoContextMouseSensors.back();
    AddMouseSensor(ms);
    if (m_showTime) {
      char timeStr[512];
      sprintf(timeStr, "fps %d\ntime %3.2f", fps, m_timelineTime);
      int showFps = (int)g_layout->getElement(g_languageCode, "config")->get("show_fps")->valueVec[0];

      if (showFps)
        pD3DApp->RenderDebugInfo(timeStr, 1, 0xFFFFFFFF, false, 10, 10, showFps);
    }
  }


  return D3D_OK;
}

// GetFileModifyTime
// returns the last write time of the file, if file not found FILETIME struct filled with 0
FILETIME GetFileModifyTime(const char *fileName) {
  FILETIME lastWriteTime;
  lastWriteTime.dwHighDateTime = 0;
  lastWriteTime.dwLowDateTime = 0;
  WIN32_FIND_DATA FindFileData;
  HANDLE hFind;
  char buf[512];
  GetCurrentDirectory(512, buf);
  strcat(buf, "\\");
  strcat(buf, fileName);
  hFind = FindFirstFile((LPCSTR)buf, &FindFileData);
  if (hFind != INVALID_HANDLE_VALUE) {
    lastWriteTime = FindFileData.ftLastWriteTime;
    FindClose(hFind);
  }
  return lastWriteTime;
}
