
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>
#include <string>

#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "shader.h"

#include "effect.h"
#include "effectBlit.h"
#include "effectCamera.h"

void EffectBlit::Init() {
}

void EffectBlit::Advance() {
}


// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectBlit::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_MIRROR);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_MIRROR);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);


  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 tempMatrix;

  const EffectParam *ep;

  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;


 // D3DXMatrixPerspectiveFovLH(&matProj, D3DX_PI*0.5f, g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
 // pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);

  int numImages = GetPR()->getN("blit");

  for (int imageI=0; imageI<numImages; imageI++) {

    ep = GetPR()->get("blit", imageI);

    if (ep->hide == 1) {
      continue;
    }

    D3DXMatrixIdentity(&matView);
    pd3dDevice->SetTransform(D3DTS_VIEW, &matView);
    pd3dDevice->SetTransform(D3DTS_WORLD, &matView);
    pd3dDevice->SetTransform(D3DTS_PROJECTION, &matView);

    pd3dDevice->SetPixelShader(NULL);
    pd3dDevice->SetVertexShader(NULL);

    Texture *t = g_D3DApp->addTexture(ep->getString("file").c_str());
    if (t) {
      g_D3DApp->setTexture(t);
      g_D3DApp->drawSquare(1.0f);
    }
  }



  // End the scene.
  pd3dDevice->EndScene();

  return 1;

}

