
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "curve.h"

#include "effect.h"
#include "EffectCamera.h"

void EffectCamera::Init() {
}




D3DXVECTOR3 g_cameraPos;
D3DXVECTOR3 g_cameraLookAt;
D3DXVECTOR3 g_cameraUp;
float g_cameraFov;

float g_cameraRoll;
float g_cameraPitch;
float g_cameraYaw;
float g_cameraPitchLA;
float g_cameraYawLA;

float g_cameraNear;
float g_cameraFar;

D3DXMATRIXA16 g_cameraView;

float g_cameraFOV;

void EffectCamera::Advance() {

}


// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectCamera::Render() {


 // AddToGlobalCamera(this, 1.0f);
  m_position = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
  m_lookAt = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
  m_up = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
  m_fov = 0.0f;

  m_roll = 0.0f;
  m_pitch = 0.0f;
  m_yaw = 0.0f;
  m_pitchLA = 0.0f;
  m_yawLA = 0.0f;

  D3DXVECTOR3 t;

  const EffectParam *ep;

  ep = GetPR()->get("camera");

  float globalFade;

  m_position = ep->getVec3("position", &globalFade);
  g_cameraPos = g_cameraPos*(globalFade) + m_position;

  m_lookAt = ep->getVec3("lookAt", &globalFade);
  g_cameraLookAt = g_cameraLookAt*(globalFade) + m_lookAt;

  m_up = ep->getVec3("up", &globalFade);
  g_cameraUp = g_cameraUp*(globalFade) + m_up;

  m_fov = ep->getFloat("fov");
  g_cameraFOV = g_cameraFOV*globalFade + m_fov;

  m_roll = ep->getFloat("roll");
  g_cameraRoll = g_cameraRoll*globalFade + m_roll;

  m_pitch = ep->getFloat("pitch");
  g_cameraPitch = g_cameraPitch*globalFade + m_pitch;

  m_yaw = ep->getFloat("yaw");
  g_cameraYaw = g_cameraYaw*globalFade + m_yaw;

  m_pitchLA = ep->getFloat("pitchLA");
  g_cameraPitchLA = g_cameraPitchLA*globalFade + m_pitchLA;

  m_yawLA = ep->getFloat("yawLA");
  g_cameraYawLA = g_cameraYawLA*globalFade + m_yawLA;

  return 1;
}

void ResetGlobalCamera() {
  g_cameraPos.x = 0.0f;
  g_cameraPos.y = 0.0f;
  g_cameraPos.z = 0.0f;

  g_cameraLookAt.x = 0.0f;
  g_cameraLookAt.y = 0.0f;
  g_cameraLookAt.z = 0.0f;

  g_cameraUp.x = 0.0f;
  g_cameraUp.y = 0.0f;
  g_cameraUp.z = 0.0f;

  g_cameraFOV = 0.0f;

  g_cameraRoll = 0.0f;
  g_cameraPitch = 0.0f;
  g_cameraYaw = 0.0f;
  g_cameraPitchLA = 0.0f;
  g_cameraYawLA = 0.0f;

  g_cameraNear = CAMERA_NEAR;
  g_cameraFar = CAMERA_FAR;
}

void AddToGlobalCamera(EffectCamera *ec, float weight) {
  g_cameraPos += ec->m_position*weight;
  g_cameraLookAt += ec->m_lookAt*weight;
  g_cameraUp += ec->m_up*weight;
  g_cameraFov += ec->m_fov*weight;
  g_cameraRoll += ec->m_roll*weight;
  g_cameraPitch += ec->m_pitch*weight;
  g_cameraYaw += ec->m_yaw*weight;
  g_cameraPitchLA += ec->m_pitchLA*weight;
  g_cameraYawLA += ec->m_yawLA*weight;
}

void MultiplyGlobalCameraPos(float multiplier) {
  g_cameraPos *= multiplier;
}

void AddToGlobalCameraPos(D3DXVECTOR3 *pos, D3DXVECTOR3 *lookAt) {
  g_cameraPos += *pos;
  g_cameraLookAt += *lookAt;
}


D3DXMATRIXA16 *GetGlobalCameraView() {

  // apply roll 
  D3DXVECTOR3 camUp = g_cameraUp;
  D3DXVECTOR4 camUpRot;
  D3DXMATRIXA16 rollMatrix;
  D3DXMatrixRotationZ(&rollMatrix, g_cameraRoll);
  D3DXVec3Transform(&camUpRot, &camUp, &rollMatrix);
  camUp.x = camUpRot.x;
  camUp.y = camUpRot.y;
  camUp.z = camUpRot.z;

  // still todo: apply yaw, pitch, yawLA and pitchLA ...

  D3DXMatrixLookAtLH(&g_cameraView, &g_cameraPos, &g_cameraLookAt, &camUp);
  return &g_cameraView;

}

D3DXVECTOR3 GetGlobalCameraPos() {
  return g_cameraPos;
}
D3DXVECTOR3 GetGlobalCameraLookAt() {
  return g_cameraLookAt;
}

void SetGlobalCameraPos(D3DXVECTOR3 cameraPos) {
  g_cameraPos = cameraPos;
}

float GetGlobalCameraFOV() {
  return D3DX_PI*g_cameraFOV;
}

float GetGlobalCameraNear() {
  return g_cameraNear;
}

float GetGlobalCameraFar() {
  return g_cameraFar;
}



