
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectConv16bToBB.h"

void EffectConv16bToBB::Init() {
  if (!m_floatToOneZero) {
    m_floatToOneZero = new Shader();
  }
  m_floatToOneZero->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/hdr_float_to_onezero.h");
}

void EffectConv16bToBB::ReloadShaders() {
  Init();
}

bool EffectConv16bToBB::CheckShadersModifiedOnDisk() {
  if (m_floatToOneZero && m_floatToOneZero->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}


void EffectConv16bToBB::Advance() {
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectConv16bToBB::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  Texture *rt16b_buffer0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_buffer0", 1, D3DFMT_A16B16G16R16F); // D3DFMT_A32B32G32R32F); // D3DFMT_A16B16G16R16F);

  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);


  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matWVP;

  D3DXMatrixIdentity(&matProj);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);
  pd3dDevice->SetTransform(D3DTS_VIEW, &matProj);
  pd3dDevice->SetTransform(D3DTS_WORLD, &matProj);
  D3DXMatrixIdentity(&matWorld);

  matWVP = matWorld*matProj*matProj;

  int num = GetPR()->getN("hdr");
  for (int i=0; i<num; i++) {
    const EffectParam *p;
    p = GetPR()->get("hdr", i);
    if (p->hide == 1)
      continue;


    m_floatToOneZero->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

    float luminosity = p->getFloat("luminosity");
    float whiteness = p->getFloat("whiteness");
    float saturation = p->getFloat("saturation");
    float exponent = p->getFloat("exponent");

    D3DXVECTOR4 exponentRGB = p->getVec4("exponent_rgb")*exponent;

    m_floatToOneZero->GetEffect()->SetFloat("g_luminosity", luminosity);
    m_floatToOneZero->GetEffect()->SetFloat("g_whiteness", whiteness);
  //  m_floatToOneZero->GetEffect()->SetFloat("g_exponent", exponent);
    m_floatToOneZero->GetEffect()->SetFloat("g_saturation", saturation);

    m_floatToOneZero->GetEffect()->SetVector("g_exponentRGB", &exponentRGB);

    m_floatToOneZero->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
    m_floatToOneZero->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);

    g_D3DApp->setTexture(rt16b_buffer0);


    m_floatToOneZero->Enable();

    g_D3DApp->drawSquare(1.0f);

    m_floatToOneZero->Disable();
  }

  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
