
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"

#include "deferred.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectLight.h"
#include "EffectCamera.h"
#include "EffectDeferredMixer.h"

EffectDeferredMixer::EffectDeferredMixer() {

  m_timelineType = mixer;

  m_deferredMixer = NULL;

  m_tNoise = g_D3DApp->createTexture(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "gNoise");

  srand(1234);

  D3DLOCKED_RECT locked;
  m_tNoise->lpTexture->LockRect(0, &locked, NULL, D3DLOCK_DISCARD);
  int kukko = locked.Pitch;
  unsigned char* kala = (unsigned char *)locked.pBits;
  int i=0;
  for (int y=0; y<g_D3DApp->m_windowHeight; y++) {
    i = locked.Pitch*y;
    for (int x=0; x<g_D3DApp->m_windowWidth; x++) {
      float kalaA = 0.0f;
      float kalaB = 0.0f;
      float kalaC = 0.0f;
      float kalaL = 0.0f;
      while (kalaL < 0.1f) {
        kalaA = ((float)rand()/RAND_MAX)*2.0f-1.0f;
        kalaB = ((float)rand()/RAND_MAX)*2.0f-1.0f;
        kalaC = ((float)rand()/RAND_MAX)*2.0f-1.0f;
        kalaL = sqrtf(kalaA*kalaA+kalaB*kalaB+kalaC*kalaC);
      }
      float pituus = 0.05f+0.950f*(float)rand()/RAND_MAX;
      kalaA = kalaA*pituus/kalaL;
      kalaB = kalaB*pituus/kalaL;
      kalaC = kalaB*pituus/kalaL;

      kala[i] = (unsigned char)((kalaA+0.0f)*1.0f*255.0f);
      kala[i+1] = (unsigned char)((kalaB+0.0f)*1.0f*255.0f);
      kala[i+2] = (unsigned char)((kalaC+0.0f)*1.0f*255.0f);
      kala[i+3] = (unsigned char)(((float)rand()/RAND_MAX*1.0f+0.0f)*255.0f);
      i+=4;
    }
  }
  m_tNoise->lpTexture->UnlockRect(0);

}


void EffectDeferredMixer::ReloadShaders() {
 // delete m_deferredMixer;
  Init();
}


EffectDeferredMixer::~EffectDeferredMixer() {
}


void EffectDeferredMixer::Init() {
  if (!m_deferredMixer) {
    m_deferredMixer = new Shader();
    m_deferredMixerAO = new Shader();
  }
  m_deferredMixer->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/deferred_mixer.h");
  m_deferredMixerAO->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/deferred_mixer_ao.h");
}

bool EffectDeferredMixer::CheckShadersModifiedOnDisk() {
  if (m_deferredMixer && m_deferredMixer->CheckModifiedOnDisk()) {
    return true;
  }
  if (m_deferredMixerAO && m_deferredMixerAO->CheckModifiedOnDisk()) {
    return true;
  }

  return false;
}


void EffectDeferredMixer::Advance() {
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectDeferredMixer::Render() {

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESS);

  Texture *rt16b_depth = GetDeferred()->GetRT16bDepth();
  Texture *rt16b_normal = GetDeferred()->GetRT16bNormal();
  Texture *rt16b_diffuse = GetDeferred()->GetRT16bDiffuse();

  Texture *rt16b_ambSpec = GetDeferred()->GetRT16bAmbSpec();


  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);

  vector<Light> *lights =  GetGlobalLights();

  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 matWVP;

  D3DXMatrixIdentity(&matProj);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);
  pd3dDevice->SetTransform(D3DTS_VIEW, &matProj);

  D3DXMatrixIdentity(&matWorld);

  pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

  matWVP = matWorld*matProj*matProj;

  int dfmixNum = GetPR()->getN("dfmix");
  for (int mI=0; mI<dfmixNum; mI++) {

    const EffectParam *ep;
    ep = GetPR()->get("dfmix", mI);

    bool aoEnable = false;
    if (((int)ep->getFloat("ao_enable"))) {
      aoEnable = true;
    }

    bool aoBlur = false;
    if (((int)ep->getFloat("ao_blur"))) {
      aoBlur = true;
    }

    int blurLoops = ep->getInt("ao_blur_loops");


    int aoResDiv = ep->getFloat("ao_resdiv");
    int aoBlurResDiv = ep->getFloat("ao_blur_res_div");

    m_deferredMixer->GetEffect()->SetFloat( "g_ambience", ep->getFloat("ambience"));
    m_deferredMixer->GetEffect()->SetFloat( "g_ambience_att", ep->getFloat("ambience_att"));

    m_deferredMixerAO->GetEffect()->SetFloat( "g_ao_darkness", ep->getFloat("ao_darkness"));
    m_deferredMixerAO->GetEffect()->SetFloat( "g_ao_whiteness", ep->getFloat("ao_whiteness"));
    m_deferredMixerAO->GetEffect()->SetFloat( "g_ao_area", ep->getFloat("ao_area"));
    m_deferredMixer->GetEffect()->SetFloat( "g_ao_pow", ep->getFloat("ao_pow"));
    
    m_deferredMixer->GetEffect()->SetMatrix( "g_mView", GetGlobalCameraView());// GetDeferred()->GetView());
    m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

    D3DXMATRIXA16 matInvView;
    D3DXMatrixInverse(&matInvView, NULL, GetGlobalCameraView());
   // m_deferredMixer->GetEffect()->SetMatrix( "g_mInvView", &matInvView);


    m_deferredMixerAO->GetEffect()->SetMatrix( "g_mView", GetGlobalCameraView());// GetDeferred()->GetView());
    m_deferredMixerAO->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );
    
    /*
    m_deferredMixer->GetEffect()->SetMatrix( "g_mView",  GetDeferred()->GetView());
    m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

    m_deferredMixerAO->GetEffect()->SetMatrix( "g_mView",  GetDeferred()->GetView());
    m_deferredMixerAO->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );
    */
    

    D3DXMATRIXA16 matCamProj;
    D3DXMatrixPerspectiveFovLH(&matCamProj, GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
    m_deferredMixer->GetEffect()->SetMatrix( "g_mProj", &matCamProj);
    
    D3DXMATRIXA16 matInvProj;
    D3DXMatrixInverse(&matInvProj, NULL, &matCamProj);
   // m_deferredMixer->GetEffect()->SetMatrix( "g_mInvProj", &matInvProj);
    

    Texture *pTexInputAmb = g_D3DApp->addTexture(ep->getString("ambience_map").c_str());
    Texture *pTexInputEnv = g_D3DApp->addTexture(ep->getString("env_map").c_str());


    m_deferredMixer->GetEffect()->SetTexture("g_tDepth", rt16b_depth->lpTexture);
    m_deferredMixerAO->GetEffect()->SetTexture("g_tDepth", rt16b_depth->lpTexture);
    g_D3DApp->setTexture(rt16b_depth, 0);
    pd3dDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    m_deferredMixer->GetEffect()->SetTexture("g_tNormal", rt16b_normal->lpTexture);
    m_deferredMixerAO->GetEffect()->SetTexture("g_tNormal", rt16b_normal->lpTexture);
    g_D3DApp->setTexture(rt16b_normal, 1);
    pd3dDevice->SetSamplerState(1, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(1, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(1, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pd3dDevice->SetSamplerState(1, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    m_deferredMixer->GetEffect()->SetTexture("g_tDiffuse", rt16b_diffuse->lpTexture);
    m_deferredMixerAO->GetEffect()->SetTexture("g_tDiffuse", rt16b_diffuse->lpTexture);
    g_D3DApp->setTexture(rt16b_diffuse, 2);
    pd3dDevice->SetSamplerState(2, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(2, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
    pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    m_deferredMixer->GetEffect()->SetTexture("g_tNoise", m_tNoise->lpTexture);
    m_deferredMixerAO->GetEffect()->SetTexture("g_tNoise", m_tNoise->lpTexture);
    g_D3DApp->setTexture(m_tNoise, 3);
    pd3dDevice->SetSamplerState(3, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(3, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(3, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
    pd3dDevice->SetSamplerState(3, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);

    m_deferredMixer->GetEffect()->SetTexture("g_tAmbSpec", rt16b_ambSpec->lpTexture);
    g_D3DApp->setTexture(rt16b_ambSpec, 5);
    pd3dDevice->SetSamplerState(5, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(5, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(5, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
    pd3dDevice->SetSamplerState(5, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);




    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);

    if (aoResDiv == 0) {
      aoResDiv = 1;
    }

    char halvedId[512];

    int halver = aoResDiv;
    int kukkee = g_D3DApp->m_windowWidth/halver;

    sprintf(halvedId, "rt16b_buffer0h_%d", aoResDiv);

    Texture *rt16b_buffer0h = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth/halver, g_D3DApp->m_windowHeight/halver, halvedId, 0, D3DFMT_R16F);
    g_D3DApp->resetRenderTarget();
    g_D3DApp->setRenderTarget(rt16b_buffer0h);
    pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(0, 0, 0, 0), 1.0f, 0 );

    m_deferredMixer->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
    m_deferredMixer->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);

    m_deferredMixerAO->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
    m_deferredMixerAO->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);


    if (aoEnable) {

      m_deferredMixerAO->Enable("Render");
      g_D3DApp->drawSquare(1.0f);
      m_deferredMixerAO->Disable();

      if (aoBlur) {

        int halverBlur = aoBlurResDiv;

        if (halverBlur < 1) {
          halverBlur = 1;
        }

        char kukkoStr[512];
        sprintf(kukkoStr, "rt16b_buffer0b1_%d", halverBlur);
        std::string buf1Name = kukkoStr;
        sprintf(kukkoStr, "rt16b_buffer0b2_%d", halverBlur);
        std::string buf2Name = kukkoStr;


        Texture *rt16b_buffer0b1 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth/halverBlur, g_D3DApp->m_windowHeight/halverBlur, buf1Name.c_str(), 0, D3DFMT_R16F);
        Texture *rt16b_buffer0b2 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth/halverBlur, g_D3DApp->m_windowHeight/halverBlur, buf2Name.c_str(), 0, D3DFMT_R16F);
        Texture *rt16b_buffer0b3 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_buffer0b3", 0, D3DFMT_R16F);
        g_D3DApp->resetRenderTarget();

        m_deferredMixer->Enable("BlurAOX");

        // blur ao
        for (int i=0; i<blurLoops; i++) {

          float igor = 1.0f;
          if (i>=4)
            igor = 0.0f;

          float kuhmer = 1.0f*(float)g_D3DApp->m_windowWidth/1024.0f;

          if (i==0)
            m_deferredMixer->GetEffect()->SetFloat("g_blurAmount", (2.0f/(g_D3DApp->m_windowWidth/halverBlur))*kuhmer);
          else
            m_deferredMixer->GetEffect()->SetFloat("g_blurAmount", (1.0f/(g_D3DApp->m_windowWidth/halverBlur)+(float)(i)*igor/(g_D3DApp->m_windowWidth/halverBlur))*kuhmer);

          if ((i&1) == 0) { 
            g_D3DApp->setRenderTarget(rt16b_buffer0b2);

            if (i==0) {
              m_deferredMixer->GetEffect()->SetTexture("g_tAO", rt16b_buffer0h->lpTexture);
              g_D3DApp->setTexture(rt16b_buffer0h, 4);
            } else {
              m_deferredMixer->GetEffect()->SetTexture("g_tAO", rt16b_buffer0b1->lpTexture);
              g_D3DApp->setTexture(rt16b_buffer0b1, 4);
            }
          } else {
            // on last pass, use full-res buffer to obtain sharp ao-edges
            if (i==blurLoops-1)
              g_D3DApp->setRenderTarget(rt16b_buffer0b3);
            else
              g_D3DApp->setRenderTarget(rt16b_buffer0b1);

            m_deferredMixer->GetEffect()->SetTexture("g_tAO", rt16b_buffer0b2->lpTexture);
            g_D3DApp->setTexture(rt16b_buffer0b2, 4);
          }
          pd3dDevice->SetSamplerState(2, D3DSAMP_MINFILTER, D3DTEXF_POINT );
          pd3dDevice->SetSamplerState(2, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
          pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
          pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

          m_deferredMixer->Flush();
          g_D3DApp->drawSquare(1.0f);
          g_D3DApp->resetRenderTarget();

          m_deferredMixer->GetEffect()->SetTexture("g_tAO", rt16b_buffer0b3->lpTexture);
        }
        m_deferredMixer->Disable();
      }

      m_deferredMixer->GetEffect()->SetTexture("g_tDiffuse", rt16b_diffuse->lpTexture);
      g_D3DApp->setTexture(rt16b_diffuse, 2);
      pd3dDevice->SetSamplerState(2, D3DSAMP_MINFILTER, D3DTEXF_POINT );
      pd3dDevice->SetSamplerState(2, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
      pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
      pd3dDevice->SetSamplerState(2, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);

    } else {
      pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(0, 0, 0, 0), 1.0f, 0 );
      g_D3DApp->resetRenderTarget();

    }

    std::vector<RtBuffer> rt16bBufferNames = GetRT16bBufferNames();
    Texture *rt16b_buffer = NULL;

    for (int i=0; i<rt16bBufferNames.size(); i++) {
      if (rt16bBufferNames[i].m_name != "") {
        rt16b_buffer = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, rt16bBufferNames[i].m_name, 0, rt16bBufferNames[i].m_fmt);
        g_D3DApp->setRenderTarget(rt16b_buffer, i);
      }
    }
/*

    string rt32bBufferName = GetRT32bBufferName();
    Texture *rt32b_buffer = NULL;
    if (rt32bBufferName != "") {
      rt32b_buffer = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, rt32bBufferName, 1, D3DFMT_A32B32G32R32F);
      g_D3DApp->setRenderTarget(rt32b_buffer);
    }
*/
    if (!aoEnable || !aoBlur) {
      m_deferredMixer->GetEffect()->SetTexture("g_tAO", rt16b_buffer0h->lpTexture);
      g_D3DApp->setTexture(rt16b_buffer0h, 4);
    }


    pd3dDevice->SetSamplerState(4, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(4, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(4, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
    pd3dDevice->SetSamplerState(4, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);

    pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);


    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);


    if (pTexInputAmb) {
      m_deferredMixer->GetEffect()->SetTexture("g_tAmbienceMap", pTexInputAmb->lpTexture);
      g_D3DApp->setTexture(pTexInputAmb, 3);
    }
    pd3dDevice->SetSamplerState(3, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(3, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(3, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
    pd3dDevice->SetSamplerState(3, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);

    if (pTexInputEnv) {
      m_deferredMixer->GetEffect()->SetTexture("g_tEnvMap", pTexInputEnv->lpTexture);
      g_D3DApp->setTexture(pTexInputEnv, 6);
    }
    pd3dDevice->SetSamplerState(6, D3DSAMP_MINFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(6, D3DSAMP_MAGFILTER, D3DTEXF_POINT );
    pd3dDevice->SetSamplerState(6, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
    pd3dDevice->SetSamplerState(6, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);

    m_deferredMixer->Flush();

    m_deferredMixer->Enable("MixAmbient");
    g_D3DApp->drawSquare(1.0f);
    m_deferredMixer->Disable();



    pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
    pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

    g_D3DApp->MakeWorldMatrix(&matWorld, 
                            &D3DXVECTOR3(0.0f-0.0f/g_D3DApp->m_windowWidth, 0.0f+0.0f/g_D3DApp->m_windowHeight, 0.0f), // translate
                            &D3DXVECTOR3(1.0f, 1.0f, 1.0f), // scale
                            &D3DXVECTOR3(0.0f, 0.0f, 0.0f)); // rotate

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    matWVP = matWorld*matProj*matProj;

    m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

    
    std::vector<Light> lightsWithShadow;
    std::vector<Light> lightsWithoutShadow;
    std::vector<Light> lightsShadowsFirst;

    for (int i=0; i<lights->size(); i++) {
      if ((*lights)[i].m_bCastShadows) {
        lightsWithShadow.push_back((*lights)[i]);
      } else {
        lightsWithoutShadow.push_back((*lights)[i]);
      }
    }
    for (std::vector<Light>::iterator it=lightsWithShadow.begin(); it!=lightsWithShadow.end(); it++) {
      lightsShadowsFirst.push_back(*it);
    }
    for (std::vector<Light>::iterator it=lightsWithoutShadow.begin(); it!=lightsWithoutShadow.end(); it++) {
      lightsShadowsFirst.push_back(*it);
    }

    if (lightsWithShadow.size()) {
      m_deferredMixer->Enable("RenderWithShadow"); // WithShadow");
    } else {
      m_deferredMixer->Enable("Render");
    }
    
    m_deferredMixer->Enable();

    for (int i=0; i<lightsShadowsFirst.size(); i++) {
  //  for (int i=0; i<lights->size(); i++) {

      D3DXVECTOR4 lightViewPos;
      D3DXVECTOR2 lightViewPos2D;

      Light *pLightPrev = NULL;
      if (i>0) {
        pLightPrev = &lightsShadowsFirst[i-1];
      }
      Light *pLight = &lightsShadowsFirst[i];
      
     // Light *pLight = &(*lights)[i];

      if (!pLight->m_bCastShadows && pLightPrev && pLightPrev->m_bCastShadows) {
        m_deferredMixer->Disable();
        m_deferredMixer->Enable("Render");
      }
      
      D3DXVec4Transform(&lightViewPos, &pLight->m_position, GetDeferred()->GetView());

      lightViewPos2D.x = lightViewPos.x/lightViewPos.z;
      lightViewPos2D.y = lightViewPos.y/lightViewPos.z;


      D3DXVECTOR3 kuhmos = D3DXVECTOR3(0.0f, 0.0f, 0.0f);

      float area = pLight->m_ss_size*pLight->m_distance;

      float kaakX = (1.0f+1.0f)*1.33333f;
      float kaakY = (1.0f+1.0f)*1.0f;


      if (lightViewPos.z > 0.0f && 
         lightViewPos2D.x > -kaakX && lightViewPos2D.y > -kaakY &&
         lightViewPos2D.x < kaakX && lightViewPos2D.y < kaakY)  {
    //    area = 2.0f/(sqrtf(lightViewPos.z)*0.2f+1.0f);
        area = area/(lightViewPos.z*1.0f+0.001f);
    //  float area = 32.0f/(lightViewPos.z+0.5f);

        float kohtaX = -lightViewPos2D.x/1.3333333f;
        float kohtaY = lightViewPos2D.y;
        float skaalaX = area;
        float skaalaY = area*1.33333f;

        skaalaX = (float)((int)(skaalaX*g_D3DApp->m_windowWidth))/g_D3DApp->m_windowWidth;
        skaalaY = (float)((int)(skaalaY*g_D3DApp->m_windowHeight))/g_D3DApp->m_windowHeight;

        kohtaX = (float)((int)(kohtaX*g_D3DApp->m_windowWidth))/g_D3DApp->m_windowWidth;
        kohtaY = (float)((int)(kohtaY*g_D3DApp->m_windowHeight))/g_D3DApp->m_windowHeight;

      g_D3DApp->MakeWorldMatrix(&matWorld, 
                              &D3DXVECTOR3(0.0f-kohtaX, kohtaY, 0.0f), // translate
                              &D3DXVECTOR3(skaalaX*1.0f, skaalaY*1.0f, 1.0f), // scale
                              &D3DXVECTOR3(0.0f, 0.0f, 0.0f)); // rotate

      } else {
        g_D3DApp->MakeWorldMatrix(&matWorld, 
                              &D3DXVECTOR3(0.0f, 0.0f, 0.0f), // translate
                              &D3DXVECTOR3(2.0f, 2.0f, 1.0f), // scale
                              &D3DXVECTOR3(0.0f, 0.0f, 0.0f)); // rotate
      }

      matWVP = matWorld*matProj*matProj;

      m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );
      m_deferredMixer->GetEffect()->SetVector( "g_lightPos", &pLight->m_position);
      m_deferredMixer->GetEffect()->SetFloat( "g_lightInvDistance", 1.0f/pLight->m_distance);
      m_deferredMixer->GetEffect()->SetFloat( "g_lightBallSharpness", pLight->m_lightball_sharpness);
      m_deferredMixer->GetEffect()->SetFloat( "g_lightBallSize", pLight->m_lightball_size);

   //   D3DXVECTOR4 camPos = D3DXVECTOR4(GetGlobalCameraPos().x, GetGlobalCameraPos().y, GetGlobalCameraPos().z, 0.0f);
   //   m_deferredMixer->GetEffect()->SetVector( "g_cameraPos", &camPos);
      

      if (pLight->m_bCastShadows) {


        D3DXMATRIXA16 lightInvView;
        D3DXMATRIXA16 lightView;
        g_D3DApp->CopyFloat16ToMatrix(pLight->m_viewMatrix, &lightView);
        //D3DXMatrixInverse(&lightInvView, NULL, &pLight->m_viewMatrix);
        D3DXMatrixInverse(&lightInvView, NULL, &lightView);
      
      //  D3DXMATRIXA16 lightView = pLight->m_viewMatrix;
        D3DXMATRIXA16 temp;
        D3DXMatrixMultiply(&temp, &matInvProj, &lightInvView);
        m_deferredMixer->GetEffect()->SetMatrix( "g_mLightProjToWorld", &temp);

        D3DXMatrixMultiply(&temp, &matInvProj, &matInvView);
        m_deferredMixer->GetEffect()->SetMatrix( "g_mProjToWorld", &temp);

        D3DXMatrixMultiply(&temp, &lightView, &matCamProj);
        m_deferredMixer->GetEffect()->SetMatrix( "g_mWorldToLightProj", &temp);


        D3DXMATRIXA16 matLightView = pLight->m_viewMatrix;
        D3DXMATRIXA16 matView = *GetGlobalCameraView();

       // std::string lightBufName;
       // char tempStr[512];
       // sprintf(tempStr, "rtLightDepth%d", i);
       // lightBufName = tempStr;
        Texture *pRtDepthForLight = pLight->m_pRtDepth; //g_D3DApp->getTexture(lightBufName); // (g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, lightBufName, 0, D3DFMT_G32R32F);
        if (pRtDepthForLight) {
          m_deferredMixer->GetEffect()->SetTexture("g_tLightDepth", pRtDepthForLight->lpTexture);
        }
      }
      
      D3DXVECTOR4 lightCol = pLight->m_color*pLight->m_intensity;
      m_deferredMixer->GetEffect()->SetVector( "g_lightColor", &lightCol);
      m_deferredMixer->Flush();
      g_D3DApp->drawSquare(1.0f);
    }
    m_deferredMixer->Disable();
  }
  

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  g_D3DApp->setTexture(0, 1);
  pd3dDevice->SetSamplerState( 1, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 1, D3DSAMP_MIPFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 1, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  g_D3DApp->setTexture(0, 2);
  pd3dDevice->SetSamplerState( 2, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 2, D3DSAMP_MIPFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 2, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  g_D3DApp->setTexture(0, 3);

  g_D3DApp->setTexture(0, 4);


  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
