
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>
#include <string>

#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "shader.h"

#include "effect.h"
#include "effectKuva.h"
#include "effectCamera.h"

void EffectKuva::Init() {
  kukkoPos[0] = 0.0f;
  kukkoPos[1] = 0.0f;
  if (!m_floatToOneZero) {
    m_floatToOneZero = new Shader();
  }
  m_floatToOneZero->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/kuva.h");
}

void EffectKuva::ReloadShaders() {
  Init();
}

bool EffectKuva::CheckShadersModifiedOnDisk() {
  if (m_floatToOneZero && m_floatToOneZero->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}

void EffectKuva::Advance() {
  kukkoPos[0] = sinf(m_absTime);
  kukkoPos[1] = cosf(m_absTime);
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectKuva::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_MIRROR);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_MIRROR);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);






  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 tempMatrix;

  const EffectParam *ep;

  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;


  D3DXMatrixPerspectiveFovLH(&matProj, D3DX_PI*0.5f, g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  //draw something

  // draw background


  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);


  int numImages = GetPR()->getN("image");

  bool bRt16bSetHere = false;

  for (int imageI=0; imageI<numImages; imageI++) {

    ep = GetPR()->get("image", imageI);

    if (ep->getN("zwrite")==0 || ((int)ep->getFloat("zwrite")==1)) {
      pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
    } else {
      pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
    }

    std::string outBufferName = "";
    if (ep->get("out")) {
      outBufferName = ep->getString("out");
    }
    std::string dBufString = "";
    if (ep->getN("dbuf")) {
      ep->getString("dbuf");
    }
    bool bDoubleBufOut = false;
    if (strcmp(dBufString.c_str(), "true")==0 || strcmp(dBufString.c_str(), "1")==0) {
      bDoubleBufOut = true;
    }
    
    if (strcmp(outBufferName.c_str(), "")!=0) {
      bRt16bSetHere = true;
      UnsetRt16b(0);
      SetRt16b(outBufferName, bDoubleBufOut, D3DFMT_A16B16G16R16F, 0);
    }
    

    if (ep->getN("zenable")==0 || ((int)ep->getFloat("zenable")==1)) {
      pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
    } else {
      pd3dDevice->SetRenderState(D3DRS_ZENABLE, false);
    }

    if (ep->hide == 1)
      continue;

    if (ep->getFloat("setcamera") > 0.5f) {
      // Set the transform matrices for our camera
      vEyePt      = D3DXVECTOR3(0.0f, 0.0f, -7.5f);
      vLookatPt   = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
      vUpVec      = D3DXVECTOR3(0.0f, 1.0f, 0.0f);
    //  vUpVec      = D3DXVECTOR3(1.0f*cosf(m_timeFloat*1.5f), 1.0f*sinf(m_timeFloat*1.5f), 0.0f);

      D3DXMatrixLookAtLH(&matView, &vEyePt, &vLookatPt, &vUpVec);
      pd3dDevice->SetTransform(D3DTS_VIEW, &matView);
    } else {
      matView = *GetGlobalCameraView();
      pd3dDevice->SetTransform(D3DTS_VIEW, &matView);
    }

    Texture *t = g_D3DApp->addTexture(ep->getString("file").c_str());
    if (t) {
      D3DXVECTOR3 trans = ep->getVec3("position");
      D3DXVECTOR3 rot = ep->getVec3("rotate");
      D3DXVECTOR3 scale = ep->getVec3("scale");

      g_D3DApp->MakeWorldMatrix(&matWorld, &trans, &scale, &rot);

      pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

      D3DXMATRIXA16 matWVP = matWorld*matView*matProj;

      D3DXVECTOR4 color = ep->getVec4("color");
      float intensity = ep->getFloat("intensity");
      float alpha = ep->getFloat("alpha");

      D3DXVECTOR4 texCoordScale;
      if (ep->getN("texcoord_scale"))
        texCoordScale = ep->getVec4("texcoord_scale");
      else
        texCoordScale = D3DXVECTOR4(1.0, 1.0, 1.0, 1.0);

      D3DXVECTOR4 texCoordOfs = ep->getVec4("texcoord_ofs");

      color *= intensity;
      color.w = alpha;

      m_floatToOneZero->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

      m_floatToOneZero->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
      m_floatToOneZero->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);


      m_floatToOneZero->GetEffect()->SetVector( "g_color", &color);

      m_floatToOneZero->GetEffect()->SetVector( "g_texCoordScale", &texCoordScale);
      m_floatToOneZero->GetEffect()->SetVector( "g_texCoordOfs", &texCoordOfs);

      std::string blendMode = ep->getString("blend");

      if (blendMode == "add") {
        pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
        pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
      } else if (blendMode == "addna") {
        pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
        pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
        pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
      } else if (blendMode == "normal") {
        pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
        pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
      } else { // "none" / "na" / etc
        pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
        pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
      }

      D3DXVECTOR4 blurSize = ep->getVec4("blur_size");
      D3DXVECTOR4 blurDisp = ep->getVec4("blur_disp");
      D3DXVECTOR4 blurDispRGB = ep->getVec4("blur_disp_rgb");
      int blurSamples = (int)ep->getVec4("blur_samples").x;

    // BUGBUG: this should be the texture size!!!
      blurSize.x /= (float)g_D3DApp->m_windowWidth;
      blurSize.y /= (float)g_D3DApp->m_windowHeight;

      blurDisp.w = 0.0f;
      blurDispRGB.w = 0.0f;

      m_floatToOneZero->GetEffect()->SetVector( "g_blurSize", &blurSize);
      m_floatToOneZero->GetEffect()->SetVector( "g_blurDisp", &blurDisp);
      m_floatToOneZero->GetEffect()->SetVector( "g_blurDispRGB", &blurDispRGB);
      m_floatToOneZero->GetEffect()->SetInt( "g_numSamples", blurSamples);


      std::string blur = "";
      
      if (ep->getN("blur"))
        blur = ep->getString("blur");

      if (blur == "line") {
        m_floatToOneZero->Enable("RenderBlurLine");
      } else if (blur == "line_disp") {
        m_floatToOneZero->Enable("RenderBlurLineDisp");
      } else if (blur == "line_disp_rgb") {
        m_floatToOneZero->Enable("RenderBlurLineDispRGB");
      } else if (blur == "xy") {
        m_floatToOneZero->Enable("RenderBlurXY");
      } else if (blur == "xy_disp_rgb") {
        m_floatToOneZero->Enable("RenderBlurXYDispRGB");
      } else {
        m_floatToOneZero->Enable();
      }

    //  m_floatToOneZero->Flush();
      g_D3DApp->setTexture(t);
      g_D3DApp->drawSquare(1.0f);
      m_floatToOneZero->Disable();

    }
  }

  if (bRt16bSetHere) {
    UnsetRt16b(0);
  }

  // End the scene.
  pd3dDevice->EndScene();

  return 1;

}

