
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"

#include "deferred.h"

#include "EffectLayout.h"

#include "mesh.h"

#include "effect.h"
#include "EffectCamera.h"
#include "EffectMeshView.h"

#include "EffectOfs.h"



static void BuildReplaceList(std::list<MeshReplace> *replaceList, const EffectParam *ep, string uniqueID, float effectTime) {
  int meshReplaceNum = ep->getN("replace");
  for (int mR=0; mR<meshReplaceNum; mR++) {
    MeshReplace meshReplace;

    const EffectParam *epr = ep->get("replace", mR);
    const EffectParam *eprm = epr->get("mesh");

    meshReplace.needle = epr->getString("needle");
    meshReplace.position = eprm->getVec3("position");
    meshReplace.rotate = eprm->getVec3("rotate");
    meshReplace.scale = eprm->getVec3("scale");
    meshReplace.everyNth = (int)epr->getFloat("every_nth");
    meshReplace.offsetNth = (int)epr->getFloat("offset_nth");

    bool conti = false;

    string replaceWithMesh = eprm->getString("file");

    char uniqueMeshName[256];
    sprintf(uniqueMeshName, "%s_r%d", uniqueID.c_str(), mR);

    int meshIndex = g_D3DApp->addAnimatedMesh(replaceWithMesh.c_str(), NULL, NULL); //, uniqueMeshName);
    meshReplace.replaceWithMesh = g_D3DApp->getMesh(meshIndex);

    int numAnim = eprm->getN("animate");
    if (numAnim) {
      for (int ia=0; ia<numAnim; ia++) {
        const EffectParam *epa = eprm->get("animate", ia);

        int set = (int)epa->getFloat("set");
        float freq = 1.0f;
        if (epa->getN("freq"))
          freq = epa->getFloat("freq");

        float modTime;
        float animFade;
        int animIsOn;
        float animStartTime;
        float animEndTime;

        epa->GetFadeParams(&animFade, &animIsOn, &modTime, &animStartTime, &animEndTime, freq);

        if (animIsOn)
          meshReplace.replaceWithMesh->Update(modTime, set);
      }
    }

    if (eprm->getN("replace")) {
      std::list<MeshReplace> childRepList;
      BuildReplaceList(&childRepList, eprm, uniqueMeshName, effectTime);
      meshReplace.replaceList = childRepList;
    }

    replaceList->push_back(meshReplace);
  }
}


void EffectMeshView::Init() {
  m_deferred = GetDeferred();
}

void EffectMeshView::Advance() {
}

// int g_repCount;


// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectMeshView::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);
 // pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }


  if (GetClearFlags())
    m_deferred->BeginDraw(true);
  else 
    m_deferred->BeginDraw(false);



  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matInvView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;

  D3DXMATRIXA16 tempMatrix;


  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;


  D3DXMatrixPerspectiveFovLH(&matProj, GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  // draw foreground stuff
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);

  int meshNum = GetPR()->getN("mesh");

  GetDeferred()->BeginShader();

  for (int mI=0; mI<meshNum; mI++) {

    const EffectParam *ep;
    ep = GetPR()->get("mesh", mI);

    char uniqueMeshName[256];
    sprintf(uniqueMeshName, "e%s_m%d", GetUniqueID().c_str(), mI);

    std::string materialOverride = "";
    std::string meshUniqueName = "";
    if (ep->getN("mat")) {
      materialOverride = ep->getString("mat");
      meshUniqueName = ep->getString("file")+materialOverride;
    }


    int meshIndex = g_D3DApp->addAnimatedMesh(ep->getString("file").c_str(), meshUniqueName.c_str(), materialOverride.c_str()); // , uniqueMeshName);
    Mesh *bMesh = g_D3DApp->getMesh(meshIndex);


    std::list<MeshReplace> replaceList;
    replaceList.clear();
//    g_repCount = 0;
    BuildReplaceList(&replaceList, ep, uniqueMeshName, m_effectTime);


    matView = *GetGlobalCameraView();

    pd3dDevice->SetTransform(D3DTS_VIEW, &matView);

    m_deferred->SetView(&matView);

    D3DXMatrixInverse(&matInvView, NULL, &matView);

    m_deferred->SetInvView(&matInvView);


    D3DXVECTOR4 globalOfs4 = *GetGlobalOffset(); 
    D3DXVECTOR3 globalOfs = D3DXVECTOR3(globalOfs4.x, globalOfs4.y, globalOfs4.z);

    if (ep->getInt("no_offset") == 1) {
      globalOfs *= 0.0f;
    }

    g_D3DApp->MakeWorldMatrix(&matWorld, 
                              &(ep->getVec3("position")+globalOfs), // translate
                              &ep->getVec3("scale"), // scale
                              &ep->getVec3("rotate")); // rotate

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    wvp = matWorld*matView*matProj;
    m_deferred->SetWorld(&matWorld);
    m_deferred->SetProj(&matProj);
    m_deferred->SetWVP(&wvp);

    int numT = ep->getN("texcoord_scale");
    if (numT)
      GetDeferred()->GetEffect()->SetVector("g_texCoordScale", &ep->getVec4("texcoord_scale"));
    else
      GetDeferred()->GetEffect()->SetVector("g_texCoordScale", &D3DXVECTOR4(1.0f, 1.0f, 0.0f, 0.0f));

    numT = ep->getN("texcoord_ofs");
    if (numT)
      GetDeferred()->GetEffect()->SetVector("g_texCoordOfs", &ep->getVec4("texcoord_ofs"));
    else
      GetDeferred()->GetEffect()->SetVector("g_texCoordOfs", &D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f));


    GetDeferred()->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
    GetDeferred()->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);

   

    int numAnim = ep->getN("animate");
    if (numAnim) {
      for (int ia=0; ia<numAnim; ia++) {
        const EffectParam *epa = ep->get("animate", ia);
        int set = (int)epa->getFloat("set");
        float freq = 1.0f;
        if (epa->getN("freq"))
          freq = epa->getFloat("freq");

        float modTime;
        float animFade;
        int animIsOn;
        float animStartTime;
        float animEndTime;

        epa->GetFadeParams(&animFade, &animIsOn, &modTime, &animStartTime, &animEndTime, freq);

        if (animIsOn) 
          bMesh->Update(modTime, set);
      }
    }
    
    g_replaceCount=0;

    bool repeat = false;

    int repeatNum = ep->getN("repeat");
    if (repeatNum) {
      g_D3DApp->drawAnimatedMeshWithInstancing(*bMesh, &matWorld, &matView, &matProj, &replaceList, ep, false);

    } else {
      g_D3DApp->drawAnimatedMeshD(*bMesh, &matWorld, &matView, &matProj, &replaceList);
    }

  }
  GetDeferred()->EndShader();

  m_deferred->EndDraw();


  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
