
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "shader.h"

#include "deferred.h"

#include "effect.h"
#include "EffectPixParticles.h"
#include "EffectCamera.h"



static float quadVerts[3*6] =
{
  1.0f, 1.0f,0.0f,
 -1.0f,-1.0f,0.0f,
 -1.0f, 1.0f,0.0f,
 -1.0f,-1.0f,0.0f,
  1.0f, 1.0f,0.0f,
  1.0f,-1.0f,0.0f
};

const DWORD VertexFVF = (D3DFVF_XYZ);


float *pQV = NULL;

static IDirect3DVertexBuffer9 *pBigSquareVB = NULL;

struct LVertex
{
    FLOAT    x, y, z;
};

int primsPerBuffer = 4096;

void EffectPixParticles::Init() {
  if (!m_shader) {
    m_shader = new Shader();
  }
  m_shader->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/pix_particle.h");

  for (int ii=0; ii<1; ii++) {
    g_D3DApp->m_pd3dDevice->CreateVertexBuffer( primsPerBuffer*6*sizeof(LVertex), 0, VertexFVF, D3DPOOL_DEFAULT, &pBigSquareVB, NULL );
    LVertex *v;
    pBigSquareVB->Lock( 0, 0, (void**)&v, 0 );
    for (int i=0; i<primsPerBuffer; i++) {
      int ip=i*6;
      v[ip+0].x  = -1.0f;  v[ip+0].y  = -1.0;   v[ip+0].z  = i;
      v[ip+1].x  = -1.0f;  v[ip+1].y  = 1.0f;   v[ip+1].z  = i;
      v[ip+2].x  = 1.0f;   v[ip+2].y  = 1.0f;   v[ip+2].z  = i;
      v[ip+3].x  = -1.0f;  v[ip+3].y  = -1.0f;  v[ip+3].z = i;
      v[ip+4].x  = 1.0f;   v[ip+4].y  = 1.0f;  v[ip+4].z = i;
      v[ip+5].x  = 1.0f;   v[ip+5].y  = -1.0f;  v[ip+5].z = i;
    }
    pBigSquareVB->Unlock();
  }
}

EffectPixParticles::EffectPixParticles() {
  m_timelineType = render;
  m_shader = NULL;

  for (int i=0; i<1; i++) {
    pBigSquareVB = NULL;
  }
}

EffectPixParticles::~EffectPixParticles() {
 // if (pQV != NULL) {
 //   delete pQV;
 // }
  if (pBigSquareVB) {
    pBigSquareVB->Release();
  }
}

void EffectPixParticles::ReloadShaders() {
  if (!m_shader) {
    m_shader = new Shader();
  }
  m_shader->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/pix_particle.h");
}


bool EffectPixParticles::CheckShadersModifiedOnDisk() {
  if (m_shader && m_shader->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}



void EffectPixParticles::Advance() {
}


int EffectPixParticles::Render() {


  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);



  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  //  pd3dDevice->SetRenderState(D3DRS_ZENABLE, false);

  bool bDepth = true;
  if (GetPR()->getN("depth")) {
    bDepth = (GetPR()->getFloat("depth") > 0.5f);
  }

  if (!bDepth) {
    pd3dDevice->SetRenderState(D3DRS_ZENABLE, bDepth);
    pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  }


  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  bool deferredParticles = (GetPR()->getFloat("deferred") > 0.5f); 


  if (deferredParticles) {
    if (GetClearFlags()) {
      GetDeferred()->BeginDraw(true);
    } else {
      GetDeferred()->BeginDraw(false);
    }
    pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);

  }


  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;
  D3DXMATRIXA16 tempMatrix;
  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;

  D3DXMatrixPerspectiveFovLH(&matProj,  GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  matView = *GetGlobalCameraView();
  pd3dDevice->SetTransform(D3DTS_VIEW, &matView);

  D3DXMATRIXA16 matViewBill = matView;

  matViewBill._11 = 1.0f;
  matViewBill._12 = 0.0f;
  matViewBill._13 = 0.0f;

  matViewBill._21 = 0.0f;
  matViewBill._22 = 1.0f;
  matViewBill._23 = 0.0f;

  matViewBill._31 = 0.0f;
  matViewBill._32 = 0.0f;
  matViewBill._33 = 1.0f;

  float def_height;
  float def_bumpness;

  Texture *tex;
  Texture *height;

  Texture *pTexInput;
  Texture *pTexInputVel;
  Texture *pTexInputCol;

  float g_depthClipMul;

  int bGlobalTexChange = 0;

  D3DXVECTOR3 inputLines;

  D3DXVECTOR4 color = D3DXVECTOR4(1.0f, 1.0f, 1.0f, 1.0f);
  float diffuse = 1.0f;
  float specular = 1.0f;
  float ambience = 0.1f;
  float gSize = 1.0f;

  int num = GetPR()->getN("pixpart");
  for (int i=0; i<num; i++) {
    const EffectParam *p;
    p = GetPR()->get("pixpart", i);
    if (p->hide == 1)
      continue;

    def_height = p->getFloat("def_height");
    def_bumpness = p->getFloat("def_bumpness");

    tex = g_D3DApp->addTexture(p->getString("image").c_str());

    if (p->getString("height") != "") {
      height = g_D3DApp->addTexture(p->getString("height").c_str());
    } else {
      height = tex;
    }

    // std::string kuukkos = "kuukkos123";
    std::string kuukkos = p->getString("input");

    Texture *pTex = g_D3DApp->getTexture(kuukkos.c_str());
    if (!pTex) {
      pTexInput = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, kuukkos.c_str(), 1, D3DFMT_A32B32G32R32F); // D3DFMT_A16B16G16R16F);
    } else {
      pTexInput = pTex;
    }

    pTexInputVel = g_D3DApp->getTexture(p->getString("input_vel"));
    pTexInputCol = g_D3DApp->getTexture(p->getString("input_col"));

   
    inputLines = p->getVec3("input_lines");

    color = p->getVec4("color");
    diffuse = p->getFloat("diffuse");
    specular = p->getFloat("specular");
    ambience = p->getFloat("ambience");
    gSize = p->getFloat("size");

    D3DXVECTOR4 gAspect = p->getVec4("aspect");

    g_depthClipMul = p->getFloat("depth_clip_mul");
   

    D3DXVECTOR3 globalPos = p->getVec3("global_position");

    std::string shaderToUse;
    
    if (deferredParticles) {
      shaderToUse = "RenderDeferred";
      if (GetDeferred()->GetRenderOnlyDepth()) {
        shaderToUse = "RenderDeferred_depthOnly";
      }
    } else {
      shaderToUse = "Render";
    }
    if (p->getN("shader")) {
      shaderToUse = p->getString("shader");

      if (GetDeferred()->GetRenderOnlyDepth()) {
        shaderToUse = shaderToUse+"_depthOnly";
      }

    }
    m_shader->Enable(shaderToUse.c_str());

    D3DXVECTOR3 globalForce = p->getVec3("force");

    D3DXVECTOR4 texCoordScale = D3DXVECTOR4(1.0f, 1.0f, 1.0f, 1.0f);
    D3DXVECTOR4 texCoordOfs = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);

    m_shader->GetEffect()->SetVector( "g_texCoordScale", &texCoordScale);
    m_shader->GetEffect()->SetVector( "g_texCoordOfs", &texCoordOfs);

    m_shader->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
    m_shader->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);

    
    int numParams = p->getN("param");
    for (int param=0; param<numParams; param++) {
      const EffectParam *epp = p->get("param", param);
      std::string name = epp->getString("shader_name");
      D3DXVECTOR4 value = epp->getVec4("value");
      m_shader->GetEffect()->SetVector(name.c_str(), &value);
    }
    

    Texture *particleTexture = NULL;
    Texture *particleHeightTexture = NULL;

    particleTexture = tex;
    particleHeightTexture = height;

 //   g_D3DApp->setTexture(particleTexture);
    m_shader->SetTexture("g_texDiffuse", particleTexture);
    if (deferredParticles) {
      m_shader->SetTexture("g_texHeight", particleHeightTexture);
 //     g_D3DApp->setTexture(particleHeightTexture, 1);
      m_shader->GetEffect()->SetFloat("g_defHeight", def_height);
      m_shader->GetEffect()->SetFloat("g_defBumpness", def_bumpness);
    }

    m_shader->GetEffect()->SetFloat("g_time", m_effectTime);

    m_shader->SetTexture("g_texPartPos", pTexInput);
    m_shader->SetTexture("g_texPartVel", pTexInputVel);
    m_shader->SetTexture("g_texPartCol", pTexInputCol);

    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
    pd3dDevice->SetRenderState(D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA);
    pd3dDevice->SetRenderState(D3DRS_DESTBLEND,  D3DBLEND_INVSRCALPHA);
    if (p->getN("blend_src")) {
      pd3dDevice->SetRenderState(D3DRS_SRCBLEND, GetD3DBlendFromString(p->getString("blend_src").c_str(), D3DBLEND_SRCALPHA));
    }
    if (p->getN("blend_dst")) {
      pd3dDevice->SetRenderState(D3DRS_DESTBLEND, GetD3DBlendFromString(p->getString("blend_dst").c_str(), D3DBLEND_INVSRCALPHA));
    }
    if (deferredParticles) {
      pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
    }

    m_shader->GetEffect()->SetMatrix( "g_mView", &matView );
    D3DXVECTOR3 trans = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
    D3DXVECTOR3 rot = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
    D3DXVECTOR3 scale = D3DXVECTOR3(1.0f, 1.0f, 1.0f);
    g_D3DApp->MakeWorldMatrix(&matWorld, &trans, &scale, &rot);
    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
    D3DXMATRIXA16 matWVP = matWorld*matViewBill*matProj;

  //  if (deferredParticles) {
      m_shader->GetEffect()->SetMatrix( "g_mWorld", &matWorld );
      m_shader->GetEffect()->SetMatrix( "g_mView", &matView );
      m_shader->GetEffect()->SetMatrix( "g_mViewBill", &matViewBill );
      m_shader->GetEffect()->SetMatrix( "g_mProj", &matProj );
  //  }
    m_shader->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );
    m_shader->GetEffect()->SetFloat( "g_depthClipMul", g_depthClipMul );
    m_shader->GetEffect()->SetVector( "g_color", &color);
    m_shader->GetEffect()->SetFloat("g_diffuse", diffuse);
    m_shader->GetEffect()->SetFloat("g_specular", specular);
    m_shader->GetEffect()->SetFloat("g_ambience", ambience);
    m_shader->GetEffect()->SetFloat("g_size", gSize);
    m_shader->GetEffect()->SetVector("g_aspect", &gAspect);


    int numParts = inputLines.x * g_D3DApp->m_windowWidth;
    int lineOffset = inputLines.y * g_D3DApp->m_windowWidth;

    g_D3DApp->m_pd3dDevice->SetFVF(VertexFVF);
    int buffers = numParts/primsPerBuffer+1;

    for (int i=0; i<buffers; i++) {

      m_shader->GetEffect()->SetFloat("g_particleIndexOffset", i*primsPerBuffer + lineOffset);
      m_shader->Flush();

      int numInBuffer = primsPerBuffer;
      if (i==buffers-1) {
        numInBuffer = numParts-(buffers-1)*primsPerBuffer;
      }
      g_D3DApp->m_pd3dDevice->SetStreamSource(0, pBigSquareVB, 0, sizeof(LVertex));
      g_D3DApp->m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0 , numInBuffer*2);
    }
  }

  m_shader->Disable();

  if (deferredParticles) {
    GetDeferred()->EndDraw();
  }

  // End the scene.
  pd3dDevice->EndScene();


  return true;
}
