

class Shader;

struct TreeBranch {
  D3DXVECTOR3 position;
  D3DXVECTOR3 growthDir;
  D3DXVECTOR3 growthDirU;
  D3DXVECTOR3 growthDirV;
  D3DXVECTOR3 bornPos;
  float branchAge;
  float growthSpeed;
  int branchesNum;
  int branchesLeft;
  float size;
  float age;
  int level;
  std::vector<TreeBranch*> branches;
};

class EffectPixSim : public Effect {
private:
  Shader *m_shader;
  std::vector<TreeBranch*> m_mainTreeBranches;
  bool m_bTreeBranchesInited;
public:
  EffectPixSim() {
    m_timelineType = preproc;
    m_shader = NULL;
    m_bTreeBranchesInited = false;
  }
  ~EffectPixSim() { }

  void Init();
  void Advance();
  int Render();

  void ReloadShaders();
  bool CheckShadersModifiedOnDisk();

  void RenderLineToPixMap(D3DXVECTOR3 *pPosStart, D3DXVECTOR3 *pPosEnd, D3DXVECTOR3 *pVelStart, D3DXVECTOR3 *pVelEnd, float startIndex, float endIndex);

  void ClearTreeBranches();
  void UpdateTreeBranches();
  void UpdateRecTreeBranches(std::vector<TreeBranch*> *tbr, int recurseLevel);
  bool DrawTreeBranches();
  void DrawRecTreeBranches(std::vector<TreeBranch*> *tbr);

  bool DoRenderForLights() { return false; }

};