
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"

#include "deferred.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectCamera.h"
#include "effectSavu.h"

void EffectSavu::Init() {
  kukkoPos[0] = 0.0f;
  kukkoPos[1] = 0.0f;

  m_deferred = GetDeferred();
}

void EffectSavu::Advance() {
  kukkoPos[0] = sinf(m_absTime);
  kukkoPos[1] = cosf(m_absTime);
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectSavu::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);
 // pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);



  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);


  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  if (GetClearFlags())
    m_deferred->BeginDraw(true);
  else 
    m_deferred->BeginDraw(false);

  GetDeferred()->BeginShader();

//   m_deferred->BeginDraw();



  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;

  D3DXMATRIXA16 tempMatrix;

//  const EffectElement *le;

  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;


  D3DXMatrixPerspectiveFovLH(&matProj,  GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 1.0f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);


  //draw something

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);


  const EffectParam *ep;
  ep = GetPR()->get("savu");

  int numMesh = (int)ep->getFloat("numMesh");

  std::string meshName = ep->getString("file");

  int meshTestIndex = g_D3DApp->addAnimatedMesh(meshName.c_str());

  Mesh *aMesh = g_D3DApp->getMesh(meshTestIndex);


  matView = *GetGlobalCameraView();

  pd3dDevice->SetTransform(D3DTS_VIEW, &matView);

  m_deferred->SetView(&matView);


  for (int i=0; i<numMesh; i++) {

    D3DXVECTOR3 paikka;
    float rad = (4.0f*cosf(i*3.3f)+14.0f)+i*1.5f;

    float k = 0.50f;

    paikka = D3DXVECTOR3(
      rad*sinf(i+m_effectTime*k*0.3f),
      5.0f*sinf(cosf(i*0.70f+m_effectTime*k*5.5f))+i*0.0f-8.0f,
      rad*cosf(i+m_effectTime*k*0.3f));

    float kobi=1.0f;
    float kubi=1.0f;
    
    if (i&1) {
      kobi = 8.0f;
      kubi = 0.04f;
    }
    
    paikka += ep->getVec3("position");
    D3DXVECTOR3 rotate = D3DXVECTOR3((i*0.5f+m_effectTime)*1.0f, 0.0f, 0.0f);
    rotate += ep->getVec3("rotate");


    D3DXVECTOR3 skaler = ep->getVec3("scale");

    D3DXVECTOR3 skalex = D3DXVECTOR3(kubi*skaler.x, kobi*skaler.y, kubi*skaler.z);//*(1.0f+0.8f*sinf(i+m_effectTime*k*0.9f));
    g_D3DApp->MakeWorldMatrix(&matWorld, 
                             // &D3DXVECTOR3((i-15)*3.0f, 4.0f, 0.0f), // translate
                              &paikka, // translate
                              &skalex, // scale
                              &rotate); // rotate
    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    wvp = matWorld*matView*matProj;
    m_deferred->SetWorld(&matWorld);
    m_deferred->SetWVP(&wvp);

    GetDeferred()->GetEffect()->SetVector("g_texCoordScale", &D3DXVECTOR4(0.4f, 0.4f, 0.0f, 0.0f));
    GetDeferred()->GetEffect()->SetVector("g_texCoordOfs", &D3DXVECTOR4(0.0f+i*0.20f, 0.0f+01.0f*cosf(i*0.05f), 0.0f, 0.0f));

    g_D3DApp->drawAnimatedMeshD(*aMesh, &matWorld, &matView, &matProj);
  }

  GetDeferred()->EndShader();

  m_deferred->EndDraw();



  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
