// mouse.h

struct MouseEvent {
private:
  enum MouseEventType {
    onClick=0,
    onDblClick,
    onHover
  };
  MouseEventType m_mouseEventType;

  int m_areaLeft; // left = 0
  int m_areaRight; // right = xres
  int m_areaTop; // top = 0
  int m_areaBottom; // bottom = yres

  void *m_eventHandle;
  void *m_eventHandleParam;
  int m_eventType;

  (void *)(m_eventCB)(int mouseX, int mouseY, 
                      bool lDown, bool lClick, bool lDblClick,
                      bool rDown, bool rClick, bool rDblClick,
                      void *eventHandle, void *eventHandleParam, int eventType);

public:
  void SetOnClick() { m_mouseEventType = onClick; }
  void SetOnDblClick() { m_mouseEventType = onDblClick; }
  void SetOnHover() { m_mouseEventType = onHover; }

  bool IsOnClick() { return m_mouseEventType == onClick; }
  bool IsOnDblClick() { return m_mouseEventType == onDblClick; }
  bool IsOnHover() { return m_mouseEventType == onHover; }
};

void ClearMouseEvents();
void ProcessMouse(int mouseX, int mouseY, bool leftDown, bool rightDown);
void AddFrameMouseEvent(int areaLeft, int areaTop, int areaRight, int areaBottom, MouseEvent me);