// shader.cpp

#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <map>

using std::string;
using std::vector;
using std::list;

#include "D3DApp.h"
#include "common_globals.h"


#include "shader.h"

extern FILETIME GetFileModifyTime(const char *fileName);

Shader::Shader() {
  m_pEffect = NULL;
}

Shader::~Shader() {
 // TBD: if m_ps or m_vs non null -> free resources properly
}

std::map<std::string, ID3DXEffect*> globalShaderMap;

bool Shader::CreateFromFile(LPDIRECT3DDEVICE9 pDev9, std::string fileName) {
/*
  std::map<std::string, ID3DXEffect*>::iterator it=globalShaderMap.find(fileName);
  if (it!=globalShaderMap.end()) {
    m_pEffect = it->second;
    return true;
  }
*/
    DWORD timeS = timeGetTime();

    std::string fileNameOrig = fileName;

    FILETIME fmt = GetFileModifyTime(fileName.c_str());

 //   if (g_D3DAppDebug) {
    char tempStr[512];
    sprintf(tempStr, "cache/%so%u", fileName.c_str(), fmt.dwLowDateTime);
    bool bValidCompiledShaderExists = false;
    { 
      FILE *f = fopen(tempStr, "r");
      if (f) {
        bValidCompiledShaderExists = true;
        fclose(f);
      }
    }
    if (bValidCompiledShaderExists) {
      fileName = tempStr;
    } else {
      // create the pre-compiled shader now
      char cmd[512];
      static bool bFxcFailedOnce = false;
      if (!bFxcFailedOnce) {
        sprintf(cmd, "fxc.exe /T fx_2_0 /O3 /Fo %s %s", tempStr, fileName.c_str());
        // sprintf(cmd, "start notepad++ peli.rocket");
        int k = system(cmd);
        if (k==0) {
          fileName = tempStr;
        } else {
          bFxcFailedOnce = true;
          MessageBox(NULL, "fxc.exe HLSL shader effect compiler tool not found. Please place it next to the ade.exe", "Shader pre-compile error!", MB_ICONERROR);
        }
      }
    }
  //  }


    DWORD dwShaderFlags = 0;
    dwShaderFlags = D3DXSHADER_ENABLE_BACKWARDS_COMPATIBILITY*0|D3DXSHADER_OPTIMIZATION_LEVEL3|D3DXSHADER_PREFER_FLOW_CONTROL; // |D3DXSHADER_PARTIALPRECISION;
    // dwShaderFlags = 0*D3DXSHADER_ENABLE_BACKWARDS_COMPATIBILITY|D3DXSHADER_OPTIMIZATION_LEVEL2|D3DXSHADER_AVOID_FLOW_CONTROL; // |D3DXSHADER_PARTIALPRECISION;

    m_shaderFileName = fileNameOrig;

    InsertLoadedFileShader(fileNameOrig);
    ID3DXBuffer *errors=NULL;
    ID3DXEffect* pNewEffect;

    HRESULT hr = D3DXCreateEffectFromFile(
    pDev9, 
    fileName.c_str(), 
    NULL, // CONST D3DXMACRO* pDefines,
    NULL, // LPD3DXINCLUDE pInclude,
    dwShaderFlags, 
    NULL, // LPD3DXEFFECTPOOL pPool,
    &pNewEffect, 
    &errors );

    // this is important to be updated even when compilation fails (to autoreload after fixing the possible error)
    m_shaderFileLastWriteTime = fmt;

    if (hr < 0) { // error compiling
      char errMsg[4096];
      if (errors==NULL) {
        sprintf(errMsg, "Error:\n File not found %s !!", fileName.c_str());
        MessageBox(NULL, errMsg, "Shader error!", MB_ICONERROR);
      }
      if (errors) {
        OutputDebugString( (char*)errors->GetBufferPointer() );
        sprintf(errMsg, "Error:\nShader error in file \"%s\"\n\n%s", fileName.c_str(), (char*)errors->GetBufferPointer());
        MessageBox(NULL, errMsg, "Shader error!", MB_ICONERROR);
        errors->Release();
      }
    //  DebugBreak();
    } else {
      if (m_pEffect) {
        m_pEffect->Release();
      }
      m_pEffect = pNewEffect;
      globalShaderMap[fileName] = m_pEffect;
      DWORD timeE = timeGetTime();
      WriteLoadLogItem("CreateEffectFromFile", fileName.c_str(), timeE-timeS);
    }

  return true;
}

bool Shader::Enable(const char *technique) {
  UINT cPasses;
  m_pEffect->SetTechnique(technique);
  m_pEffect->Begin(&cPasses, 0);
  m_pEffect->BeginPass(0);
  return true;
}

bool Shader::Flush() {
  if (m_pEffect->CommitChanges() == D3D_OK)
    return true;
  return false;
}

bool Shader::Disable() {

  m_pEffect->EndPass();
  m_pEffect->End();

//  HRESULT hr;
  return true;
}


bool Shader::SetTexture(const char *shaderName, Texture *pTexture) {
  if (!m_pEffect) {
    return false;
  }
  if (!pTexture || !pTexture->lpTexture) {
    return false;
  }
  m_pEffect->SetTexture(shaderName, pTexture->lpTexture);
  return true;
}

bool Shader::CheckModifiedOnDisk() {
  FILETIME fmt = GetFileModifyTime(m_shaderFileName.c_str());
  if (fmt.dwLowDateTime != m_shaderFileLastWriteTime.dwLowDateTime) {
    return true;
  }
  return false;
}