/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.domain;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Rakennus;
import com.assypeli.domain.Rakennustiedot;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.geom.Rectangle;

public class Kaupunki
extends Rakennus {
    private Rectangle hitbox;
    private float x;
    private float y;
    private float elamat;
    private boolean tuhoutunut;
    private Image kuva;
    private int tuotanto;
    private boolean keraarahaa;
    private Thread rahankeruuthread;
    private Rahankeruu rahankeruu;
    private boolean keskustabonus;
    private float kerroin;

    public Kaupunki(Pelaaja pelaaja) {
        super(Rakennustiedot.LINNA, pelaaja);
        super.setRakennus(this);
        this.tuhoutunut = false;
        this.elamat = 1000.0f;
        if (pelaaja.getId() == 0) {
            this.x = 0.0f;
            this.kuva = pelaaja.getTekstuurit().getLinnaOikea();
        } else {
            this.x = 3040.0f;
            this.kuva = pelaaja.getTekstuurit().getLinnaVasen();
        }
        this.y = 200.0f;
        this.hitbox = new Rectangle(this.getX(), this.getY(), 200.0f, 200.0f);
        this.keraarahaa = false;
        this.kerroin = 1.0f;
        this.keskustabonus = false;
        this.rahankeruu = new Rahankeruu();
        this.rahankeruuthread = new Thread(this.rahankeruu);
    }

    public float getTuotanto() {
        return (float)this.tuotanto * this.kerroin;
    }

    public void setTuotanto(int tuotanto) {
        this.tuotanto = tuotanto;
    }

    public void keraaRahaa() {
        this.keskeytaKeruu();
        this.rahankeruu = new Rahankeruu();
        this.rahankeruuthread = new Thread(this.rahankeruu);
        this.rahankeruuthread.start();
        this.keraarahaa = true;
    }

    public void keskeytaKeruu() {
        this.keraarahaa = false;
        if (this.rahankeruuthread.isAlive()) {
            try {
                this.rahankeruuthread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void asetaBonus(boolean b) {
        this.keskustabonus = b;
        this.kerroin = b ? 1.2f : 1.0f;
    }

    public boolean getBonus() {
        return this.keskustabonus;
    }

    @Override
    public void tarkistaOminaisuudet() {
        switch (super.getTaso()) {
            case 0: {
                this.setTuotanto(65);
                super.setVaatimukset("Barracks: 1");
                break;
            }
            case 1: {
                this.setTuotanto(95);
                super.setVaatimukset("Barracks: 2");
                break;
            }
            case 2: {
                this.setTuotanto(120);
                super.setVaatimukset("-");
                break;
            }
            case 3: {
                this.setTuotanto(145);
                super.setVaatimukset("Barracks: 3");
                break;
            }
            case 4: {
                this.setTuotanto(180);
                super.setVaatimukset("-");
                break;
            }
            default: {
                super.setVaatimukset("");
                this.setTuotanto(0);
            }
        }
    }

    public void menetaElamaa(int maara) {
        this.elamat = (float)((double)this.elamat - (double)maara * 0.15);
        if (this.elamat <= 0.0f) {
            this.tuhoutunut = true;
            this.getPelaaja().getPeli().voitto(this.getPelaaja());
        }
        System.out.println(this.elamat);
    }

    @Override
    public boolean voiRakentaa() {
        if (super.getTaso() == 0) {
            if (this.getPelaaja().getKasarmi().getTaso() >= 1) {
                return true;
            }
        } else if (super.getTaso() == 1) {
            if (this.getPelaaja().getKasarmi().getTaso() >= 2) {
                return true;
            }
        } else {
            if (super.getTaso() == 2) {
                return true;
            }
            if (super.getTaso() == 3 && this.getPelaaja().getKasarmi().getTaso() >= 3) {
                return true;
            }
        }
        return false;
    }

    public void piirra(Graphics g, int ruudunSijainti) {
        if (this.getPelaaja().getId() == 0) {
            if (this.kuva != null) {
                g.drawImage(this.kuva, this.x - (float)ruudunSijainti - 100.0f, this.y - 50.0f);
            }
        } else if (this.kuva != null) {
            g.drawImage(this.kuva, this.x - (float)ruudunSijainti - 260.0f, this.y - 50.0f);
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Rectangle getHitbox() {
        return this.hitbox;
    }

    public class Rahankeruu
    implements Runnable {
        @Override
        public void run() {
            Kaupunki.this.tarkistaOminaisuudet();
            while (Kaupunki.this.keraarahaa) {
                try {
                    while (Kaupunki.this.getPelaaja().getPeli().getTauko()) {
                    }
                    Thread.sleep(2000L);
                    Kaupunki.this.getPelaaja().getRahavarasto().lisaa((float)Kaupunki.this.tuotanto * Kaupunki.this.kerroin / 30.0f);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

