/*
 * Decompiled with CFR 0.152.
 */
package com.assypeli.domain;

import com.assypeli.domain.Pelaaja;
import com.assypeli.domain.Rakennustiedot;

public abstract class Rakennus {
    private Rakennustiedot rakennus;
    private int maksimitaso;
    private int taso;
    private boolean paivittyy;
    private Pelaaja pelaaja;
    private Rakennus rakennus1;
    private String esittely;
    private String vaatimukset;

    public Rakennus(Rakennustiedot rakennus, Pelaaja pelaaja) {
        this.rakennus = rakennus;
        this.maksimitaso = rakennus.getMaksimitaso();
        this.taso = 0;
        this.paivittyy = false;
        this.pelaaja = pelaaja;
        this.setEsittely();
        this.setVaatimukset();
    }

    public void setVaatimukset() {
    }

    public void setEsittely() {
        this.esittely = this.rakennus == Rakennustiedot.KASARMI ? "Use barracks to build units to destroy your enemy." : (this.rakennus == Rakennustiedot.LINNA ? "Upgrade castle to unlock buildings and increase gold income" : (this.rakennus == Rakennustiedot.TYKKI ? "Catapult shoots at enemies near your castle" : (this.rakennus == Rakennustiedot.LOUHOS ? "Upgrading mine will increase your metal income." : (this.rakennus == Rakennustiedot.METSA ? "Upgrading forest will increase your wood income." : (this.rakennus == Rakennustiedot.PUUVARASTO ? "Wood storage increases your maxium wood capacity." : (this.rakennus == Rakennustiedot.KIVIVARASTO ? "Stone storage increases your maxium stone capacity." : (this.rakennus == Rakennustiedot.RAHAVARASTO ? "Gold storage increases your maxium gold capacity." : (this.rakennus == Rakennustiedot.VELHOTORNI ? "Use magic to destroy enemy units and heal your own units." : (this.rakennus == Rakennustiedot.RAHAVARASTO ? "Gold storage increases your maxium gold capacity." : (this.rakennus == Rakennustiedot.TALLI ? "Stable let you create fast and powerful cavalry." : (this.rakennus == Rakennustiedot.PAJA ? "Unlock unit upgrades in workshop" : (this.rakennus == Rakennustiedot.MACHINERY ? "Create powerful war machines in machinery" : "-"))))))))))));
    }

    public Rakennus getRakennus() {
        return this.rakennus1;
    }

    public int getTaso() {
        return this.taso;
    }

    public void tarkistaOminaisuudet() {
        System.out.println("VIRHE: Rakennus ei tarkastanut ominaisuuksiaan");
    }

    public void setRakennus(Rakennus rakennus1) {
        this.rakennus1 = rakennus1;
    }

    public void huijauskasvatus() {
        new Thread(new Paivitys()).start();
    }

    public void kasvataTasoa() {
        if (!this.paivittyy && this.rakennus.getMaksimitaso() != this.getTaso()) {
            int kultahinta = this.rakennus.getKulta(this.getTaso() + 1);
            int kivihinta = this.rakennus.getKivi(this.getTaso() + 1);
            int puuhinta = this.rakennus.getPuu(this.getTaso() + 1);
            if (this.pelaaja.riittaaResurssit(kultahinta, puuhinta, kivihinta) && this.rakennus1.voiRakentaa()) {
                this.pelaaja.kulutaResursseja(kultahinta, puuhinta, kivihinta);
                this.pelaaja.setRakentaa(true);
                this.paivittyy = true;
                new Thread(new Paivitys()).start();
            } else {
                this.pelaaja.setRakentaa(false);
            }
        } else {
            this.pelaaja.setRakentaa(false);
        }
    }

    public String toString() {
        return String.valueOf(this.rakennus.name()) + " (" + this.getTaso() + ")";
    }

    public Pelaaja getPelaaja() {
        return this.pelaaja;
    }

    public boolean voiRakentaa() {
        return false;
    }

    public boolean equals(Object o) {
        if (o.getClass() == this.getClass()) {
            Rakennus r = (Rakennus)o;
            return r.getRakennustiedot() == this.getRakennustiedot();
        }
        return false;
    }

    public String getEsittely() {
        return this.esittely;
    }

    public int hashCode() {
        return this.rakennus.name().hashCode();
    }

    public String getVaatimukset() {
        return this.vaatimukset;
    }

    public void setVaatimukset(String vaatimukset) {
        this.vaatimukset = vaatimukset;
    }

    public Rakennustiedot getRakennustiedot() {
        return this.rakennus;
    }

    private class Paivitys
    implements Runnable {
        private Paivitys() {
        }

        @Override
        public void run() {
            try {
                try {
                    Rakennus rakennus = Rakennus.this;
                    rakennus.taso = rakennus.taso + 1;
                    Rakennus.this.rakennus1.tarkistaOminaisuudet();
                }
                catch (Exception exception) {
                    Rakennus.this.paivittyy = false;
                    Rakennus.this.pelaaja.setRakentaa(false);
                    Rakennus.this.pelaaja.getYksikonOhjaaja().tarkistaSallitutyksikot();
                    Rakennus.this.pelaaja.getVelhotorni().tarkistaSallitutTaijat();
                }
            }
            finally {
                Rakennus.this.paivittyy = false;
                Rakennus.this.pelaaja.setRakentaa(false);
                Rakennus.this.pelaaja.getYksikonOhjaaja().tarkistaSallitutyksikot();
                Rakennus.this.pelaaja.getVelhotorni().tarkistaSallitutTaijat();
            }
        }
    }
}

