/*
 * Decompiled with CFR 0.152.
 */
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

public class ParallaxTest {
    TextureRegion[] layers;
    ParallaxCamera camera;
    SpriteBatch batch;
    BitmapFont font;

    public void create() {
        Texture texture = new Texture(Gdx.files.internal("data/layers.png"));
        this.layers = new TextureRegion[3];
        this.layers[0] = new TextureRegion(texture, 0, 0, 542, 363);
        this.layers[1] = new TextureRegion(texture, 0, 363, 1024, 149);
        this.layers[2] = new TextureRegion(texture, 547, 0, 224, 51);
        this.camera = new ParallaxCamera(480.0f, 320.0f);
        this.batch = new SpriteBatch();
        this.font = new BitmapFont(Gdx.files.internal("data/arial-15.fnt"), false);
    }

    public void dispose() {
        this.layers[0].getTexture().dispose();
        this.batch.dispose();
        this.font.dispose();
    }

    public void render() {
        this.batch.setProjectionMatrix(this.camera.calculateParallaxMatrix(0.0f, 0.0f));
        this.batch.disableBlending();
        this.batch.begin();
        this.batch.draw(this.layers[0], (float)(-(this.layers[0].getRegionWidth() / 2)), (float)(-(this.layers[0].getRegionHeight() / 2)));
        this.batch.end();
        this.batch.enableBlending();
        this.batch.setProjectionMatrix(this.camera.calculateParallaxMatrix(0.5f, 1.0f));
        this.batch.begin();
        this.batch.draw(this.layers[1], -512.0f, -160.0f);
        this.batch.end();
        this.batch.setProjectionMatrix(this.camera.calculateParallaxMatrix(1.0f, 1.0f));
        this.batch.begin();
        int i = 0;
        while (i < 9) {
            this.batch.draw(this.layers[2], (float)(i * this.layers[2].getRegionWidth() - 1024), -160.0f);
            ++i;
        }
        this.batch.end();
    }

    class ParallaxCamera
    extends OrthographicCamera {
        Matrix4 parallaxView;
        Matrix4 parallaxCombined;
        Vector3 tmp;
        Vector3 tmp2;

        public ParallaxCamera(float viewportWidth, float viewportHeight) {
            super(viewportWidth, viewportHeight);
            this.parallaxView = new Matrix4();
            this.parallaxCombined = new Matrix4();
            this.tmp = new Vector3();
            this.tmp2 = new Vector3();
        }

        public Matrix4 calculateParallaxMatrix(float parallaxX, float parallaxY) {
            this.update();
            this.tmp.set(this.position);
            this.tmp.x *= parallaxX;
            this.tmp.y *= parallaxY;
            this.parallaxView.setToLookAt(this.tmp, this.tmp2.set(this.tmp).add(this.direction), this.up);
            this.parallaxCombined.set(this.projection);
            Matrix4.mul(this.parallaxCombined.val, this.parallaxView.val);
            return this.parallaxCombined;
        }
    }
}

