/*
 * Decompiled with CFR 0.152.
 */
package actors;

import actors.Enemy;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.World;
import com.esotericsoftware.spine.Bone;
import core.OfficeRunnerGame;

public class Gun {
    private String type;
    private boolean ready;
    private int ammo;
    private boolean alive = true;
    private Vector2 position;
    private Vector2 target;
    private float range;
    private float hitDistance;
    private float trackAngle = 0.0f;
    private float lastAngle = 0.0f;
    private Body player;
    private World world;
    private OrthographicCamera cam;
    private OfficeRunnerGame game;
    private Bone shoulder;
    private Enemy victim;
    private float shoulderOrigX;
    private float gunTimer;

    public Gun(Body gamePlayer, World gameWorld, OrthographicCamera gameCam, OfficeRunnerGame gameObj, Bone gameShoulder) {
        this.player = gamePlayer;
        this.world = gameWorld;
        this.cam = gameCam;
        this.game = gameObj;
        this.shoulder = gameShoulder;
        this.gunTimer = 0.0f;
        this.ready = true;
        this.ammo = 1;
    }

    public float rotated() {
        return Math.abs(this.trackAngle);
    }

    public boolean trigger() {
        if (this.ready && this.ammo > 0) {
            this.fire();
            return true;
        }
        return false;
    }

    private void fire() {
        this.ready = false;
        this.gunTimer = 0.08f;
        if (this.alive) {
            this.game.gun.play(MathUtils.random(0.45f, 0.7f), MathUtils.random(0.95f, 1.05f), 0.0f);
        }
        this.alive = !this.alive;
        this.world.rayCast(new RayCastCallback(){

            @Override
            public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
                String udName = "";
                try {
                    udName = fixture.getBody().getUserData().getClass().getSimpleName();
                }
                catch (Exception e) {
                    return 1.0f;
                }
                if (udName.startsWith("Enemy")) {
                    Gun.this.victim = (Enemy)fixture.getBody().getUserData();
                    Gun.this.victim.registerHit(point, Gun.this.position.cpy().sub(Gun.this.target));
                } else if (!udName.equals("Building")) {
                    return 1.0f;
                }
                Gun.this.hitDistance = 500.0f * fraction;
                return 0.0f;
            }
        }, this.position, this.target);
    }

    public void update(Vector2 shoulderPos, Vector2 mouse) {
        float a = mouse.angle();
        while (Math.abs(a - this.lastAngle) > 180.0f) {
            a += (float)(mouse.angle() > this.lastAngle ? -360 : 360);
        }
        this.trackAngle += a - this.lastAngle;
        this.lastAngle = mouse.angle();
        this.position = shoulderPos;
        this.target = mouse;
        mouse.setAngle(MathUtils.random(mouse.angle() - 2.2f, mouse.angle() + 2.2f));
        this.target = shoulderPos.cpy().add(mouse.cpy().scl(500.0f));
        float mouseAngle = mouse.angle() - 120.0f + 32.0f;
        this.shoulder.setRotation(mouseAngle + 15.0f);
        this.shoulderOrigX = this.shoulder.getX();
        if (!this.ready && this.gunTimer > 0.0f) {
            this.gunTimer -= Gdx.graphics.getDeltaTime();
            if (this.gunTimer <= 0.0f) {
                this.gunTimer = 0.0f;
                this.ready = true;
            }
        }
    }

    public Vector2 aimvec() {
        return this.target;
    }

    public float hitdist() {
        float d = this.hitDistance;
        this.hitDistance = 0.0f;
        return d;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReady() {
        return this.ready;
    }

    public int getAmmo() {
        return this.ammo;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Vector2 getTarget() {
        return this.target;
    }

    public float getRange() {
        return this.range;
    }

    public float getHitDistance() {
        return this.hitDistance;
    }

    public float getTrackAngle() {
        return this.trackAngle;
    }

    public float getLastAngle() {
        return this.lastAngle;
    }

    public Body getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.world;
    }

    public OrthographicCamera getCam() {
        return this.cam;
    }

    public OfficeRunnerGame getGame() {
        return this.game;
    }

    public Bone getShoulder() {
        return this.shoulder;
    }

    public Enemy getVictim() {
        return this.victim;
    }

    public float getShoulderOrigX() {
        return this.shoulderOrigX;
    }

    public float getGunTimer() {
        return this.gunTimer;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public void setAmmo(int ammo) {
        this.ammo = ammo;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void setPosition(Vector2 position) {
        this.position = position;
    }

    public void setTarget(Vector2 target) {
        this.target = target;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public void setHitDistance(float hitDistance) {
        this.hitDistance = hitDistance;
    }

    public void setTrackAngle(float trackAngle) {
        this.trackAngle = trackAngle;
    }

    public void setLastAngle(float lastAngle) {
        this.lastAngle = lastAngle;
    }

    public void setPlayer(Body player) {
        this.player = player;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setCam(OrthographicCamera cam) {
        this.cam = cam;
    }

    public void setGame(OfficeRunnerGame game) {
        this.game = game;
    }

    public void setShoulder(Bone shoulder) {
        this.shoulder = shoulder;
    }

    public void setVictim(Enemy victim) {
        this.victim = victim;
    }

    public void setShoulderOrigX(float shoulderOrigX) {
        this.shoulderOrigX = shoulderOrigX;
    }

    public void setGunTimer(float gunTimer) {
        this.gunTimer = gunTimer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Gun)) {
            return false;
        }
        Gun other = (Gun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.isReady() != other.isReady()) {
            return false;
        }
        if (this.getAmmo() != other.getAmmo()) {
            return false;
        }
        if (this.isAlive() != other.isAlive()) {
            return false;
        }
        Vector2 this$position = this.getPosition();
        Vector2 other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Vector2 this$target = this.getTarget();
        Vector2 other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        if (Float.compare(this.getRange(), other.getRange()) != 0) {
            return false;
        }
        if (Float.compare(this.getHitDistance(), other.getHitDistance()) != 0) {
            return false;
        }
        if (Float.compare(this.getTrackAngle(), other.getTrackAngle()) != 0) {
            return false;
        }
        if (Float.compare(this.getLastAngle(), other.getLastAngle()) != 0) {
            return false;
        }
        Body this$player = this.getPlayer();
        Body other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        OrthographicCamera this$cam = this.getCam();
        OrthographicCamera other$cam = other.getCam();
        if (this$cam == null ? other$cam != null : !this$cam.equals(other$cam)) {
            return false;
        }
        OfficeRunnerGame this$game = this.getGame();
        OfficeRunnerGame other$game = other.getGame();
        if (this$game == null ? other$game != null : !this$game.equals(other$game)) {
            return false;
        }
        Bone this$shoulder = this.getShoulder();
        Bone other$shoulder = other.getShoulder();
        if (this$shoulder == null ? other$shoulder != null : !this$shoulder.equals(other$shoulder)) {
            return false;
        }
        Enemy this$victim = this.getVictim();
        Enemy other$victim = other.getVictim();
        if (this$victim == null ? other$victim != null : !((Object)this$victim).equals(other$victim)) {
            return false;
        }
        if (Float.compare(this.getShoulderOrigX(), other.getShoulderOrigX()) != 0) {
            return false;
        }
        return Float.compare(this.getGunTimer(), other.getGunTimer()) == 0;
    }

    public boolean canEqual(Object other) {
        return other instanceof Gun;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $type = this.getType();
        result = result * 31 + ($type == null ? 0 : $type.hashCode());
        result = result * 31 + (this.isReady() ? 1231 : 1237);
        result = result * 31 + this.getAmmo();
        result = result * 31 + (this.isAlive() ? 1231 : 1237);
        Vector2 $position = this.getPosition();
        result = result * 31 + ($position == null ? 0 : ((Object)$position).hashCode());
        Vector2 $target = this.getTarget();
        result = result * 31 + ($target == null ? 0 : ((Object)$target).hashCode());
        result = result * 31 + Float.floatToIntBits(this.getRange());
        result = result * 31 + Float.floatToIntBits(this.getHitDistance());
        result = result * 31 + Float.floatToIntBits(this.getTrackAngle());
        result = result * 31 + Float.floatToIntBits(this.getLastAngle());
        Body $player = this.getPlayer();
        result = result * 31 + ($player == null ? 0 : $player.hashCode());
        World $world = this.getWorld();
        result = result * 31 + ($world == null ? 0 : $world.hashCode());
        OrthographicCamera $cam = this.getCam();
        result = result * 31 + ($cam == null ? 0 : $cam.hashCode());
        OfficeRunnerGame $game = this.getGame();
        result = result * 31 + ($game == null ? 0 : $game.hashCode());
        Bone $shoulder = this.getShoulder();
        result = result * 31 + ($shoulder == null ? 0 : $shoulder.hashCode());
        Enemy $victim = this.getVictim();
        result = result * 31 + ($victim == null ? 0 : ((Object)$victim).hashCode());
        result = result * 31 + Float.floatToIntBits(this.getShoulderOrigX());
        result = result * 31 + Float.floatToIntBits(this.getGunTimer());
        return result;
    }

    public String toString() {
        return "Gun(type=" + this.getType() + ", ready=" + this.isReady() + ", ammo=" + this.getAmmo() + ", alive=" + this.isAlive() + ", position=" + this.getPosition() + ", target=" + this.getTarget() + ", range=" + this.getRange() + ", hitDistance=" + this.getHitDistance() + ", trackAngle=" + this.getTrackAngle() + ", lastAngle=" + this.getLastAngle() + ", player=" + this.getPlayer() + ", world=" + this.getWorld() + ", cam=" + this.getCam() + ", game=" + this.getGame() + ", shoulder=" + this.getShoulder() + ", victim=" + this.getVictim() + ", shoulderOrigX=" + this.getShoulderOrigX() + ", gunTimer=" + this.getGunTimer() + ")";
    }
}

