/*
 * Decompiled with CFR 0.152.
 */
package actors;

import actors.HouseRenderer;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;

public class Level {
    private Array<House> houses;
    private Body player;
    private World world;
    private OrthographicCamera cam;
    private float ppm;
    private HouseRenderer renderer;

    public Level(Body gamePlayer, World gameWordld, OrthographicCamera gameCam, float gamePPM) {
        this.player = gamePlayer;
        this.world = gameWordld;
        this.cam = gameCam;
        this.houses = new Array(true, 50, House.class);
        this.ppm = gamePPM;
        Vector2 pos = this.player.getPosition();
        this.populateNextHouse(pos.x - 55.0f, 1.0f);
        this.renderer = new HouseRenderer();
    }

    public void update() {
        Vector3 lastHouseEnd = new Vector3(this.houses.peek().getBounds().x + this.houses.peek().getBounds().getWidth(), this.houses.peek().getBounds().y + this.houses.peek().getBounds().getHeight(), 0.0f);
        if (this.cam.frustum.pointInFrustum(lastHouseEnd.cpy().set(lastHouseEnd.x * this.ppm, 0.0f, 0.0f))) {
            this.populateNextHouse(lastHouseEnd.x, lastHouseEnd.y);
        }
    }

    private void populateNextHouse(float x, float y) {
        float roofHeight = MathUtils.random(-3.0f, 3.0f);
        float roofWidth = MathUtils.random(55.0f, 105.0f);
        float roofStart = x + MathUtils.random(5.0f, 35.0f);
        this.houses.add(this.createBuilding(roofStart, roofHeight, roofWidth, 50.0f));
    }

    private House createBuilding(float x, float y, float w, float h) {
        House retHouse = new House();
        BodyDef def = new BodyDef();
        def.type = BodyDef.BodyType.StaticBody;
        retHouse.body = this.world.createBody(def);
        PolygonShape poly = new PolygonShape();
        poly.setAsBox(w / 2.0f, h / 2.0f, new Vector2(w / 2.0f, -h / 2.0f), 0.0f);
        retHouse.body.createFixture(poly, 1.0f);
        poly.dispose();
        retHouse.body.setTransform(x, y, 0.0f);
        retHouse.body.setUserData(retHouse);
        retHouse.bounds = new Rectangle(x, y, w, h);
        retHouse.tileset = "default";
        return retHouse;
    }

    public void render(SpriteBatch batch) {
        int i = this.houses.size - 3;
        while (i < this.houses.size) {
            House house = this.houses.get(MathUtils.clamp(i, 0, this.houses.size - 1));
            this.renderer.drawHouse1(batch, ((House)house).bounds.x * this.ppm, ((House)house).bounds.y * this.ppm - ((House)house).bounds.height * this.ppm + 13.0f, ((House)house).bounds.width * this.ppm, ((House)house).bounds.height * this.ppm);
            ++i;
        }
    }

    public Array<House> getHouses() {
        return this.houses;
    }

    public Body getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.world;
    }

    public OrthographicCamera getCam() {
        return this.cam;
    }

    public float getPpm() {
        return this.ppm;
    }

    public HouseRenderer getRenderer() {
        return this.renderer;
    }

    public void setHouses(Array<House> houses) {
        this.houses = houses;
    }

    public void setPlayer(Body player) {
        this.player = player;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setCam(OrthographicCamera cam) {
        this.cam = cam;
    }

    public void setPpm(float ppm) {
        this.ppm = ppm;
    }

    public void setRenderer(HouseRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Level)) {
            return false;
        }
        Level other = (Level)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Array<House> this$houses = this.getHouses();
        Array<House> other$houses = other.getHouses();
        if (this$houses == null ? other$houses != null : !((Object)this$houses).equals(other$houses)) {
            return false;
        }
        Body this$player = this.getPlayer();
        Body other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        OrthographicCamera this$cam = this.getCam();
        OrthographicCamera other$cam = other.getCam();
        if (this$cam == null ? other$cam != null : !this$cam.equals(other$cam)) {
            return false;
        }
        if (Float.compare(this.getPpm(), other.getPpm()) != 0) {
            return false;
        }
        HouseRenderer this$renderer = this.getRenderer();
        HouseRenderer other$renderer = other.getRenderer();
        return !(this$renderer == null ? other$renderer != null : !this$renderer.equals(other$renderer));
    }

    public boolean canEqual(Object other) {
        return other instanceof Level;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Array<House> $houses = this.getHouses();
        result = result * 31 + ($houses == null ? 0 : $houses.hashCode());
        Body $player = this.getPlayer();
        result = result * 31 + ($player == null ? 0 : $player.hashCode());
        World $world = this.getWorld();
        result = result * 31 + ($world == null ? 0 : $world.hashCode());
        OrthographicCamera $cam = this.getCam();
        result = result * 31 + ($cam == null ? 0 : $cam.hashCode());
        result = result * 31 + Float.floatToIntBits(this.getPpm());
        HouseRenderer $renderer = this.getRenderer();
        result = result * 31 + ($renderer == null ? 0 : $renderer.hashCode());
        return result;
    }

    public String toString() {
        return "Level(houses=" + this.getHouses() + ", player=" + this.getPlayer() + ", world=" + this.getWorld() + ", cam=" + this.getCam() + ", ppm=" + this.getPpm() + ", renderer=" + this.getRenderer() + ")";
    }

    public class Building {
    }

    public class House {
        private String tileset;
        private Body body;
        private Rectangle bounds;

        public String getTileset() {
            return this.tileset;
        }

        public Body getBody() {
            return this.body;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void setTileset(String tileset) {
            this.tileset = tileset;
        }

        public void setBody(Body body) {
            this.body = body;
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof House)) {
                return false;
            }
            House other = (House)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tileset = this.getTileset();
            String other$tileset = other.getTileset();
            if (this$tileset == null ? other$tileset != null : !this$tileset.equals(other$tileset)) {
                return false;
            }
            Body this$body = this.getBody();
            Body other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Rectangle this$bounds = this.getBounds();
            Rectangle other$bounds = other.getBounds();
            return !(this$bounds == null ? other$bounds != null : !this$bounds.equals(other$bounds));
        }

        public boolean canEqual(Object other) {
            return other instanceof House;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            String $tileset = this.getTileset();
            result = result * 31 + ($tileset == null ? 0 : $tileset.hashCode());
            Body $body = this.getBody();
            result = result * 31 + ($body == null ? 0 : $body.hashCode());
            Rectangle $bounds = this.getBounds();
            result = result * 31 + ($bounds == null ? 0 : $bounds.hashCode());
            return result;
        }

        public String toString() {
            return "Level.House(tileset=" + this.getTileset() + ", body=" + this.getBody() + ", bounds=" + this.getBounds() + ")";
        }
    }
}

