/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.analysis;

public abstract class FourierTransform {
    public static final int NONE = 0;
    public static final int HAMMING = 1;
    protected static final int LINAVG = 2;
    protected static final int LOGAVG = 3;
    protected static final int NOAVG = 4;
    protected static final float TWO_PI = (float)Math.PI * 2;
    protected int timeSize;
    protected int sampleRate;
    protected float bandWidth;
    protected int whichWindow;
    protected float[] real;
    protected float[] imag;
    protected float[] spectrum;
    protected float[] averages;
    protected int whichAverage;
    protected int octaves;
    protected int avgPerOctave;

    FourierTransform(int ts, float sr) {
        this.timeSize = ts;
        this.sampleRate = (int)sr;
        this.bandWidth = 2.0f / (float)this.timeSize * ((float)this.sampleRate / 2.0f);
        this.noAverages();
        this.allocateArrays();
        this.whichWindow = 0;
    }

    protected abstract void allocateArrays();

    protected void setComplex(float[] r, float[] i) {
        if (this.real.length != r.length && this.imag.length != i.length) {
            throw new IllegalArgumentException("This won't work");
        }
        System.arraycopy(r, 0, this.real, 0, r.length);
        System.arraycopy(i, 0, this.imag, 0, i.length);
    }

    protected void fillSpectrum() {
        block6: {
            int i;
            block5: {
                for (i = 0; i < this.spectrum.length; ++i) {
                    this.spectrum[i] = (float)Math.sqrt(this.real[i] * this.real[i] + this.imag[i] * this.imag[i]);
                }
                if (this.whichAverage != 2) break block5;
                int avgWidth = this.spectrum.length / this.averages.length;
                for (int i2 = 0; i2 < this.averages.length; ++i2) {
                    int offset;
                    int j;
                    float avg = 0.0f;
                    for (j = 0; j < avgWidth && (offset = j + i2 * avgWidth) < this.spectrum.length; ++j) {
                        avg += this.spectrum[offset];
                    }
                    this.averages[i2] = avg /= (float)(j + 1);
                }
                break block6;
            }
            if (this.whichAverage != 3) break block6;
            for (i = 0; i < this.octaves; ++i) {
                float lowFreq = i == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - i);
                float hiFreq = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - i - 1);
                float freqStep = (hiFreq - lowFreq) / (float)this.avgPerOctave;
                float f = lowFreq;
                for (int j = 0; j < this.avgPerOctave; ++j) {
                    int offset = j + i * this.avgPerOctave;
                    this.averages[offset] = this.calcAvg(f, f + freqStep);
                    f += freqStep;
                }
            }
        }
    }

    public void noAverages() {
        this.averages = new float[0];
        this.whichAverage = 4;
    }

    public void linAverages(int numAvg) {
        if (numAvg > this.spectrum.length / 2) {
            throw new IllegalArgumentException("The number of averages for this transform can be at most " + this.spectrum.length / 2 + ".");
        }
        this.averages = new float[numAvg];
        this.whichAverage = 2;
    }

    public void logAverages(int minBandwidth, int bandsPerOctave) {
        float nyq = (float)this.sampleRate / 2.0f;
        this.octaves = 1;
        while (true) {
            float f;
            nyq /= 2.0f;
            if (!(f > (float)minBandwidth)) break;
            ++this.octaves;
        }
        this.avgPerOctave = bandsPerOctave;
        this.averages = new float[this.octaves * bandsPerOctave];
        this.whichAverage = 3;
    }

    public void window(int which) {
        if (which < 0 || which > 1) {
            throw new IllegalArgumentException("Invalid window type.");
        }
        this.whichWindow = which;
    }

    protected void doWindow(float[] samples) {
        switch (this.whichWindow) {
            case 1: {
                this.hamming(samples);
            }
        }
    }

    protected void hamming(float[] samples) {
        for (int i = 0; i < samples.length; ++i) {
            int n = i;
            samples[n] = (float)((double)samples[n] * ((double)0.54f - (double)0.46f * Math.cos((float)Math.PI * 2 * (float)i / (float)(samples.length - 1))));
        }
    }

    public int timeSize() {
        return this.timeSize;
    }

    public int specSize() {
        return this.spectrum.length;
    }

    public float getBand(int i) {
        if (i < 0) {
            i = 0;
        }
        if (i > this.spectrum.length - 1) {
            i = this.spectrum.length - 1;
        }
        return this.spectrum[i];
    }

    public float getBandWidth() {
        return this.bandWidth;
    }

    public abstract void setBand(int var1, float var2);

    public abstract void scaleBand(int var1, float var2);

    public int freqToIndex(float freq) {
        if (freq < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (freq > (float)(this.sampleRate / 2) - this.getBandWidth() / 2.0f) {
            return this.spectrum.length - 1;
        }
        float fraction = freq / (float)this.sampleRate;
        int i = Math.round((float)this.timeSize * fraction);
        return i;
    }

    public float indexToFreq(int i) {
        float bw = this.getBandWidth();
        if (i == 0) {
            return bw * 0.25f;
        }
        if (i == this.spectrum.length - 1) {
            float lastBinBeginFreq = (float)(this.sampleRate / 2) - bw / 2.0f;
            float binHalfWidth = bw * 0.25f;
            return lastBinBeginFreq + binHalfWidth;
        }
        return (float)i * bw;
    }

    public float getAverageCenterFrequency(int i) {
        if (this.whichAverage == 2) {
            int avgWidth = this.spectrum.length / this.averages.length;
            int centerBinIndex = i * avgWidth + avgWidth / 2;
            return this.indexToFreq(centerBinIndex);
        }
        if (this.whichAverage == 3) {
            int octave = i / this.avgPerOctave;
            int offset = i % this.avgPerOctave;
            float lowFreq = octave == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - octave);
            float hiFreq = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - octave - 1);
            float freqStep = (hiFreq - lowFreq) / (float)this.avgPerOctave;
            float f = lowFreq + (float)offset * freqStep;
            return f + freqStep / 2.0f;
        }
        return 0.0f;
    }

    public float getFreq(float freq) {
        return this.getBand(this.freqToIndex(freq));
    }

    public void setFreq(float freq, float a) {
        this.setBand(this.freqToIndex(freq), a);
    }

    public void scaleFreq(float freq, float s) {
        this.scaleBand(this.freqToIndex(freq), s);
    }

    public int avgSize() {
        return this.averages.length;
    }

    public float getAvg(int i) {
        float ret = this.averages.length > 0 ? this.averages[i] : 0.0f;
        return ret;
    }

    public float calcAvg(float lowFreq, float hiFreq) {
        int lowBound = this.freqToIndex(lowFreq);
        int hiBound = this.freqToIndex(hiFreq);
        float avg = 0.0f;
        for (int i = lowBound; i <= hiBound; ++i) {
            avg += this.spectrum[i];
        }
        return avg /= (float)(hiBound - lowBound + 1);
    }

    public abstract void forward(float[] var1);

    public void forward(float[] buffer, int startAt) {
        if (buffer.length - startAt < this.timeSize) {
            throw new IllegalArgumentException("FourierTransform.forward: not enough samples in the buffer between " + startAt + " and " + buffer.length + " to perform a transform.");
        }
        float[] section = new float[this.timeSize];
        System.arraycopy(buffer, startAt, section, 0, section.length);
        this.forward(section);
    }

    public abstract void inverse(float[] var1);

    public void inverse(float[] freqReal, float[] freqImag, float[] buffer) {
        this.setComplex(freqReal, freqImag);
        this.inverse(buffer);
    }

    public float[] getSpectrum() {
        return this.spectrum;
    }

    public float[] getRealPart() {
        return this.real;
    }

    public float[] getImaginaryPart() {
        return this.imag;
    }
}

