/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.audio.io;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.audio.io.Decoder;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.SharedLibraryLoader;

public class VorbisDecoder
extends Decoder {
    private final long handle;

    public VorbisDecoder(FileHandle file) {
        if (file.type() != Files.FileType.External && file.type() != Files.FileType.Absolute) {
            throw new IllegalArgumentException("File must be absolute or external!");
        }
        this.handle = VorbisDecoder.openFile(file.file().getAbsolutePath());
        if (this.handle == 0L) {
            throw new IllegalArgumentException("couldn't open file '" + file + "'");
        }
    }

    @Override
    public synchronized void dispose() {
        VorbisDecoder.closeFile(this.handle);
    }

    @Override
    public synchronized float getLength() {
        return VorbisDecoder.getLength(this.handle);
    }

    @Override
    public synchronized int getChannels() {
        return VorbisDecoder.getNumChannels(this.handle);
    }

    @Override
    public synchronized int getRate() {
        return VorbisDecoder.getRate(this.handle);
    }

    @Override
    public synchronized int readSamples(short[] samples, int offset, int numSamples) {
        return VorbisDecoder.readSamples(this.handle, samples, offset, numSamples);
    }

    @Override
    public synchronized int skipSamples(int numSamples) {
        return VorbisDecoder.skipSamples(this.handle, numSamples);
    }

    @Override
    public synchronized boolean canSeek() {
        return VorbisDecoder.seekable(this.handle) != 0;
    }

    @Override
    public synchronized boolean setPosition(float seconds) {
        return VorbisDecoder.timeSeek(this.handle, seconds) == 0;
    }

    @Override
    public synchronized float getPosition() {
        return VorbisDecoder.tellTime(this.handle);
    }

    private static native long openFile(String var0);

    private static native int getNumChannels(long var0);

    private static native int getRate(long var0);

    private static native float getLength(long var0);

    private static native int readSamples(long var0, short[] var2, int var3, int var4);

    private static native int skipSamples(long var0, int var2);

    private static native void closeFile(long var0);

    private static native int seekable(long var0);

    private static native float tellTime(long var0);

    private static native int timeSeek(long var0, float var2);

    static {
        new SharedLibraryLoader().load("gdx-audio");
    }
}

