/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglFileHandle;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LwjglPreferences
implements Preferences {
    private final String name;
    private final Properties properties = new Properties();
    private final FileHandle file;

    public LwjglPreferences(String name) {
        this(new LwjglFileHandle(new File(".prefs/" + name), Files.FileType.External));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LwjglPreferences(FileHandle file) {
        this.name = file.name();
        this.file = file;
        if (!file.exists()) {
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(file.read());
            this.properties.loadFromXML(in);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void putBoolean(String key, boolean val2) {
        this.properties.put(key, Boolean.toString(val2));
    }

    @Override
    public void putInteger(String key, int val2) {
        this.properties.put(key, Integer.toString(val2));
    }

    @Override
    public void putLong(String key, long val2) {
        this.properties.put(key, Long.toString(val2));
    }

    @Override
    public void putFloat(String key, float val2) {
        this.properties.put(key, Float.toString(val2));
    }

    @Override
    public void putString(String key, String val2) {
        this.properties.put(key, val2);
    }

    @Override
    public void put(Map<String, ?> vals) {
        for (Map.Entry<String, ?> val2 : vals.entrySet()) {
            if (val2.getValue() instanceof Boolean) {
                this.putBoolean(val2.getKey(), (Boolean)val2.getValue());
            }
            if (val2.getValue() instanceof Integer) {
                this.putInteger(val2.getKey(), (Integer)val2.getValue());
            }
            if (val2.getValue() instanceof Long) {
                this.putLong(val2.getKey(), (Long)val2.getValue());
            }
            if (val2.getValue() instanceof String) {
                this.putString(val2.getKey(), (String)val2.getValue());
            }
            if (!(val2.getValue() instanceof Float)) continue;
            this.putFloat(val2.getKey(), ((Float)val2.getValue()).floatValue());
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Override
    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    @Override
    public String getString(String key) {
        return this.getString(key, "");
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        return Boolean.parseBoolean(this.properties.getProperty(key, Boolean.toString(defValue)));
    }

    @Override
    public int getInteger(String key, int defValue) {
        return Integer.parseInt(this.properties.getProperty(key, Integer.toString(defValue)));
    }

    @Override
    public long getLong(String key, long defValue) {
        return Long.parseLong(this.properties.getProperty(key, Long.toString(defValue)));
    }

    @Override
    public float getFloat(String key, float defValue) {
        return Float.parseFloat(this.properties.getProperty(key, Float.toString(defValue)));
    }

    @Override
    public String getString(String key, String defValue) {
        return this.properties.getProperty(key, defValue);
    }

    @Override
    public Map<String, ?> get() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> val2 : this.properties.entrySet()) {
            if (val2.getValue() instanceof Boolean) {
                map.put((String)val2.getKey(), Boolean.parseBoolean((String)val2.getValue()));
            }
            if (val2.getValue() instanceof Integer) {
                map.put((String)val2.getKey(), Integer.parseInt((String)val2.getValue()));
            }
            if (val2.getValue() instanceof Long) {
                map.put((String)val2.getKey(), Long.parseLong((String)val2.getValue()));
            }
            if (val2.getValue() instanceof String) {
                map.put((String)val2.getKey(), (String)val2.getValue());
            }
            if (!(val2.getValue() instanceof Float)) continue;
            map.put((String)val2.getKey(), Float.valueOf(Float.parseFloat((String)val2.getValue())));
        }
        return map;
    }

    @Override
    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public void flush() {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(this.file.write(false));
            this.properties.storeToXML(out, null);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error writing preferences: " + this.file, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void remove(String key) {
        this.properties.remove(key);
    }
}

