/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.utils.Array;
import java.util.Comparator;
import java.util.Iterator;

public class Material
implements Iterable<Attribute>,
Comparator<Attribute> {
    private static final Array<String> types = new Array();
    private static int counter = 0;
    public String id;
    protected long mask;
    protected final Array<Attribute> attributes = new Array();
    protected boolean sorted = true;

    protected static final long getAttributeType(String alias) {
        for (int i = 0; i < Material.types.size; ++i) {
            if (types.get(i).compareTo(alias) != 0) continue;
            return 1L << i;
        }
        return 0L;
    }

    protected static final String getAttributeAlias(long type) {
        int idx = -1;
        while (type != 0L && ++idx < 63 && (type >> idx & 1L) == 0L) {
        }
        return idx >= 0 && idx < Material.types.size ? types.get(idx) : null;
    }

    protected static final long register(String alias) {
        long result = Material.getAttributeType(alias);
        if (result > 0L) {
            return result;
        }
        types.add(alias);
        return 1L << Material.types.size - 1;
    }

    public Material() {
        this("mtl" + ++counter);
    }

    public Material(String id) {
        this.id = id;
    }

    public Material(Attribute ... attributes) {
        this();
        this.set(attributes);
    }

    public Material(String id, Attribute ... attributes) {
        this(id);
        this.set(attributes);
    }

    public Material(Array<Attribute> attributes) {
        this();
        this.set(attributes);
    }

    public Material(String id, Array<Attribute> attributes) {
        this(id);
        this.set(attributes);
    }

    public Material(Material copyFrom) {
        this(copyFrom.id, copyFrom);
    }

    public Material(String id, Material copyFrom) {
        this(id);
        for (Attribute attr : copyFrom) {
            this.set(attr.copy());
        }
    }

    private final void enable(long mask) {
        this.mask |= mask;
    }

    private final void disable(long mask) {
        this.mask &= 0xFFFFFFFFFFFFFFFFL ^ mask;
    }

    public final long getMask() {
        return this.mask;
    }

    public final boolean has(long type) {
        return type > 0L && (this.mask & type) == type;
    }

    protected int indexOf(long type) {
        if (this.has(type)) {
            for (int i = 0; i < this.attributes.size; ++i) {
                if (this.attributes.get((int)i).type != type) continue;
                return i;
            }
        }
        return -1;
    }

    public final void set(Attribute attribute) {
        int idx = this.indexOf(attribute.type);
        if (idx < 0) {
            this.enable(attribute.type);
            this.attributes.add(attribute);
            this.sorted = false;
        } else {
            this.attributes.set(idx, attribute);
        }
    }

    public final void set(Attribute ... attributes) {
        for (Attribute attr : attributes) {
            this.set(attr);
        }
    }

    public final void set(Array<Attribute> attributes) {
        for (Attribute attr : attributes) {
            this.set(attr);
        }
    }

    public final void remove(long mask) {
        for (int i = 0; i < this.attributes.size; ++i) {
            long type = this.attributes.get((int)i).type;
            if ((mask & type) != type) continue;
            this.attributes.removeIndex(i);
            this.disable(type);
            this.sorted = false;
        }
    }

    public final Attribute get(long type) {
        if (this.has(type)) {
            for (int i = 0; i < this.attributes.size; ++i) {
                if (this.attributes.get((int)i).type != type) continue;
                return this.attributes.get(i);
            }
        }
        return null;
    }

    public final Array<Attribute> get(Array<Attribute> out, long type) {
        for (int i = 0; i < this.attributes.size; ++i) {
            if ((this.attributes.get((int)i).type & type) == 0L) continue;
            out.add(this.attributes.get(i));
        }
        return out;
    }

    public final void clear() {
        this.mask = 0L;
        this.attributes.clear();
    }

    public int size() {
        return this.attributes.size;
    }

    public final Material copy() {
        return new Material(this);
    }

    @Override
    public final int compare(Attribute arg0, Attribute arg1) {
        return (int)(arg0.type - arg1.type);
    }

    public final void sort() {
        if (!this.sorted) {
            this.attributes.sort(this);
            this.sorted = true;
        }
    }

    public final boolean same(Material other) {
        return this.mask == other.mask;
    }

    public final boolean equals(Material other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.same(other)) {
            return false;
        }
        this.sort();
        other.sort();
        for (int i = 0; i < this.attributes.size; ++i) {
            if (this.attributes.get(i).equals(other.attributes.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof Material ? this.equals((Material)obj) : false;
    }

    @Override
    public final Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }

    public static abstract class Attribute {
        public final long type;

        protected static long register(String type) {
            return Material.register(type);
        }

        protected Attribute(long type) {
            this.type = type;
        }

        public abstract Attribute copy();

        protected abstract boolean equals(Attribute var1);

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)obj;
            if (other.type != other.type) {
                return false;
            }
            return this.equals(other);
        }

        public String toString() {
            return Material.getAttributeAlias(this.type);
        }
    }
}

